/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs.EditorRibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs.GenericEditorRibbonComponentGroupController;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationEngine;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditorViewType;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.RawRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonButton;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.CustomChoiceDialog;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.convert.RspecConverter;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;
import org.controlsfx.dialog.CommandLinksDialog;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspecEditorRibbonTab
extends EditorRibbonTab {
    private static final Logger LOG = LoggerFactory.getLogger(RspecEditorRibbonTab.class);
    private final RspecValidationEngine validationEngine = new RspecValidationEngine();
    private JFedGuiConfig config;
    private TestbedInfoSource testbedInfoSource;
    @FXML
    private RibbonButton formatCodeButton;
    @FXML
    private RibbonButton verifyCodeButton;
    @FXML
    private RibbonButton bindButton;
    @FXML
    private RibbonButton searchCodeButton;
    @FXML
    private RibbonButton replaceCodeButton;

    public RspecEditorRibbonTab() {
        FXMLUtil.injectFXML((Object)((Object)this), aClass -> {
            if (aClass == GenericEditorRibbonComponentGroupController.class) {
                return new GenericEditorRibbonComponentGroupController(this);
            }
            throw new RuntimeException("Unexpected class in ControllerFactory: " + aClass.getName());
        });
        this.setOnSelectionChanged(event -> {
            if (this.isSelected() && this.getActiveExperimentEditor().getCurrentEditorViewType() != EditorViewType.RAW) {
                this.getActiveExperimentEditor().switchToEditorViewByType(EditorViewType.RAW);
            }
        });
    }

    public void setJFedGuiConfig(JFedGuiConfig conf) {
        this.config = conf;
    }

    public void setAuthorityList(TestbedInfoSource testbedInfoSource) {
        this.testbedInfoSource = testbedInfoSource;
    }

    private RawRspecEditor getActiveRawRspecEditor() {
        assert (this.getActiveExperimentEditor().getCurrentEditorViewType() == EditorViewType.RAW);
        return (RawRspecEditor)this.getActiveExperimentEditor().getCurrentEditableRspecView();
    }

    @FXML
    private void onFormatCodeAction() {
        assert (this.formatCodeButton != null);
        if (!this.getActiveRawRspecEditor().formatXmlCode()) {
            JFDialogs.create().owner((Node)this.formatCodeButton).message("Formatting your Rspec failed. Please check if the XML is valid").title("The Rspec could not be formatted").showWarning();
        }
    }

    @FXML
    private void onVerifyRspecAction() {
        RequestRspecSource source = this.getActiveExperimentEditor().getCurrentRequestRspecSource();
        RspecValidationResult verifyRspecResult = this.validationEngine.validateRSpec(RspecCheckReason.CHECK_RSPEC, source, this.verifyCodeButton.getScene().getWindow());
        assert (this.verifyCodeButton != null);
        if (verifyRspecResult == null) {
            JFDialogs.create().owner((Node)this.verifyCodeButton).title("Rspec Verify Result").message("No problems found in RSpec.").showInformation();
        } else {
            this.getActiveExperimentEditor().getEditableRspec().setRequestRspecSource(verifyRspecResult.getReplacementRequestRspecSource());
        }
    }

    @FXML
    private void onBindRspecAction() {
        RequestRspecSource source = this.getActiveExperimentEditor().getCurrentRequestRspecSource();
        FXModelRspec model = (FXModelRspec)source.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        if (model == null) {
            JFDialogs.create().owner((Node)this.bindButton).title("Rspec Parse Error").message("The RSpec does not correctly parse.").showError();
            return;
        }
        Boolean isLosingData = source.isLosingData(ModelRspecType.FX);
        if (isLosingData == null || isLosingData.booleanValue()) {
            JFDialogs.create().owner((Node)this.bindButton).title("Rspec is losing data").message("This operation will cause data loss. Try \"Verify\" first to solve the problems.").showError();
            return;
        }
        CommandLinksDialog.CommandLinksButtonType bindButtonType = new CommandLinksDialog.CommandLinksButtonType("Bind resources", "Bind all the nodes and links in this RSpec to a new component_manger", true);
        CommandLinksDialog.CommandLinksButtonType unbindButtonType = new CommandLinksDialog.CommandLinksButtonType("Unbind resources", "Unbind all nodes and links, making the entire RSpec unbound.", false);
        CommandLinksDialog dialog = new CommandLinksDialog(new CommandLinksDialog.CommandLinksButtonType[]{bindButtonType, unbindButtonType});
        dialog.setTitle("Binding or Unbinding an RSpec");
        dialog.setHeaderText("Binding or Unbinding an RSpec");
        dialog.setContentText("Choose your action:");
        dialog.showAndWait().ifPresent(chosenAction -> {
            if (chosenAction == bindButtonType.getButtonType()) {
                assert (this.config != null);
                assert (this.testbedInfoSource != null);
                ArrayList<Server> bindableAuthorities = new ArrayList<Server>(this.config.getBindableServers());
                bindableAuthorities.sort(Comparator.comparing(auth -> auth.getName().toLowerCase()));
                CustomChoiceDialog unboundNodesDialog = new CustomChoiceDialog();
                unboundNodesDialog.setStringConverter(new StringConverter<Server>(){

                    public String toString(Server object) {
                        return object.getName();
                    }

                    public Server fromString(String string) {
                        throw new UnsupportedOperationException();
                    }
                });
                unboundNodesDialog.setComboboxBelowText(true);
                unboundNodesDialog.initOwner(this.bindButton.getScene().getWindow());
                unboundNodesDialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PUZZLE_PIECE, (Color)Color.CHOCOLATE));
                unboundNodesDialog.setHeaderText("Unbound nodes detected");
                unboundNodesDialog.setContentText("Please select the testbed to which the unbound nodes and links must be assigned:");
                unboundNodesDialog.getItems().setAll(bindableAuthorities);
                Optional chosenAuthorityInfo = unboundNodesDialog.showAndWait();
                if (chosenAuthorityInfo.isPresent()) {
                    RspecConverter converter = new RspecConverter();
                    RspecFactory rspecFactory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.FX);
                    FXModelRspec newModelRspec = (FXModelRspec)converter.forceComponentManagerBindings((ModelRspec)model, rspecFactory, ((Server)chosenAuthorityInfo.get()).getDefaultComponentManagerAsGeniUrn());
                    this.getActiveExperimentEditor().getEditableRspec().setRequestRspecSource((RequestRspecSource)new ImmutableRequestRspecSource((ModelRspec)newModelRspec));
                }
            } else if (chosenAction == unbindButtonType.getButtonType()) {
                RspecConverter converter = new RspecConverter();
                RspecFactory rspecFactory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.FX);
                FXModelRspec newModelRspec = (FXModelRspec)converter.removeComponentManagerBindings((ModelRspec)model, rspecFactory);
                this.getActiveExperimentEditor().getEditableRspec().setRequestRspecSource((RequestRspecSource)new ImmutableRequestRspecSource((ModelRspec)newModelRspec));
            }
        });
    }

    @FXML
    private void onSearchAction() {
        this.getActiveRawRspecEditor().showSearch();
    }

    @FXML
    private void onReplaceAction() {
        this.getActiveRawRspecEditor().showReplace();
    }
}

