/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs.EditorRibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs.GenericEditorRibbonComponentGroupController;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ribbon_tabs.RspecEditorRibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableCanvasEditorView;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditorViewType;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonButton;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.util.BindingsUtil;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;

public class TopologyEditorRibbonTab
extends EditorRibbonTab {
    private final RspecEditorRibbonTab rspecEditorRibbonTab;
    @FXML
    private RibbonButton pasteButton;
    @FXML
    private RibbonButton copyButton;
    @FXML
    private RibbonButton duplicateButton;
    @FXML
    private RibbonButton zoomInButton;
    @FXML
    private RibbonButton zoomOutButton;
    @FXML
    private RibbonButton resetZoomButton;

    public TopologyEditorRibbonTab(RspecEditorRibbonTab rspecEditorRibbonTab) {
        this.rspecEditorRibbonTab = rspecEditorRibbonTab;
        FXMLUtil.injectFXML((Object)((Object)this), aClass -> {
            if (aClass == GenericEditorRibbonComponentGroupController.class) {
                return new GenericEditorRibbonComponentGroupController(this);
            }
            throw new RuntimeException("Unexpected class in ControllerFactory: " + aClass.getName());
        });
        this.setOnSelectionChanged(event -> {
            boolean success;
            if (this.isSelected() && this.getActiveExperimentEditor().getCurrentEditorViewType() != EditorViewType.CANVAS && !(success = this.getActiveExperimentEditor().trySwitchToEditorViewByType(EditorViewType.CANVAS))) {
                this.getTabPane().getSelectionModel().select((Object)this.rspecEditorRibbonTab);
            }
        });
        this.activeExperimentEditor.addListener((observableValue, oldValue, newValue) -> {
            if (oldValue != null) {
                this.unbindButtons();
            }
            if (newValue != null && newValue.getCurrentEditorViewType() == EditorViewType.CANVAS) {
                this.bindButtons();
            }
        });
    }

    private EditableCanvasEditorView getActiveCanvasEditorView() {
        assert (this.getActiveExperimentEditor().getCurrentEditorViewType() == EditorViewType.CANVAS);
        return (EditableCanvasEditorView)this.getActiveExperimentEditor().getCurrentEditableRspecView();
    }

    private void bindButtons() {
        assert (this.getActiveCanvasEditorView() != null);
        assert (this.getActiveCanvasEditorView().getCanvas() != null);
        EditableExperimentCanvas canvas = this.getActiveCanvasEditorView().getCanvas();
        this.copyButton.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)BindingsUtil.instanceOfBinding(canvas.getSelectionProvider().selectedObjectProperty(), RspecCanvasNode.class)));
        this.duplicateButton.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)BindingsUtil.instanceOfBinding(canvas.getSelectionProvider().selectedObjectProperty(), RspecCanvasNode.class)));
        this.pasteButton.disableProperty().bind((ObservableValue)canvas.getClipboard().emptyProperty());
    }

    private void unbindButtons() {
        this.copyButton.disableProperty().unbind();
        this.duplicateButton.disableProperty().unbind();
        this.pasteButton.disableProperty().unbind();
    }

    @FXML
    private void onCopyAction() {
        this.getActiveCanvasEditorView().getCanvas().copySelected();
    }

    @FXML
    private void onPasteAction() {
        this.getActiveCanvasEditorView().getCanvas().paste();
    }

    @FXML
    private void onDuplicateAction() {
        this.getActiveCanvasEditorView().getCanvas().duplicateSelected();
    }

    @FXML
    private void onAutoLayoutAction() {
        this.getActiveCanvasEditorView().autoLayout();
    }

    @FXML
    private void onAutoFitAction() {
        this.getActiveCanvasEditorView().autoFit();
    }

    @FXML
    private void onCircleLayoutAction() {
        this.getActiveCanvasEditorView().arrangeNodesOnCircle();
    }

    @FXML
    public void onZoomInAction() {
        this.getActiveCanvasEditorView().getCanvas().zoomIn();
    }

    @FXML
    public void onZoomOutAction() {
        this.getActiveCanvasEditorView().getCanvas().zoomOut();
    }

    @FXML
    public void onResetZoomAction() {
        this.getActiveCanvasEditorView().getCanvas().setZoom(1.0);
    }
}

