/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicDistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;

public class AnsibleServiceValidator
implements RspecValidator {
    @Override
    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        FXModelRspec modelRspec = (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        if (modelRspec.getNodes().stream().anyMatch(node -> !node.getAnsibleServices().isEmpty()) && modelRspec.getDistributeSshKeypairs().isEmpty()) {
            Alert dialog = new Alert(Alert.AlertType.WARNING);
            dialog.initOwner(dialogOwner);
            dialog.setTitle("Ansible services defined without distributed SSH Keys");
            dialog.setHeaderText("No distributed SSH Keys defined");
            dialog.setContentText("The RSpec contains an Ansible Service, but no distributed SSH keys. The latter is needed to allow the Ansible-node to connect to the other nodes in the experiment. Do you want to add a distributed SSH Keypair?");
            dialog.setResizable(true);
            ButtonType addKeypairButtonType = new ButtonType("Add keypair", ButtonBar.ButtonData.YES);
            ButtonType ignoreButtonType = new ButtonType("Ignore", ButtonBar.ButtonData.NO);
            dialog.getButtonTypes().setAll((Object[])new ButtonType[]{addKeypairButtonType, ignoreButtonType, ButtonType.CANCEL});
            Optional result = dialog.showAndWait();
            if (!result.isPresent() || result.get() == ButtonType.CANCEL) {
                return new RspecValidationResult(requestRspecSource, true);
            }
            if (result.get() == addKeypairButtonType) {
                modelRspec.addDistributeSshKeypair((DistributeSshKeypair)new BasicDistributeSshKeypair(null, null));
                return new RspecValidationResult(modelRspec);
            }
            return new RspecValidationResult(requestRspecSource, false);
        }
        return null;
    }
}

