/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.parser.RspecCompare;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;

public class CheckIfLosingDataValidator
implements RspecValidator {
    private static final ButtonType MORE_DETAILS = new ButtonType("More Details...", ButtonBar.ButtonData.HELP);

    @Override
    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        Boolean isLosingData = requestRspecSource.isLosingData(ModelRspecType.FX);
        if (isLosingData == null || isLosingData.booleanValue()) {
            Optional response = reason.equals((Object)RspecCheckReason.SWITCH_TO_VISUAL_EDITOR) || reason.equals((Object)RspecCheckReason.RUN_EXPERIMENT) ? JFDialogs.create().owner(dialogOwner).message("The Rspec contains directives that are not supported by the jFed Experimenter toolkit! " + (Objects.equals((Object)reason, (Object)RspecCheckReason.SWITCH_TO_VISUAL_EDITOR) ? "Changing to the graphical editor will incur data loss. " : "") + "Are you sure you want to continue?").title("Data loss imminent!").masthead("Data loss imminent!").buttonTypes(new ButtonType[]{ButtonType.YES, MORE_DETAILS, ButtonType.NO}).showWarning() : JFDialogs.create().owner(dialogOwner).message("The Rspec contains directives that are not supported by the jFed Experimenter toolkit! Note that because of this, switching to the graphical editor will incur data loss.").title("Data loss imminent!").masthead("Data loss imminent!").buttonTypes(new ButtonType[]{MORE_DETAILS, ButtonType.OK}).showWarning();
            if (response.isPresent() && response.get() == MORE_DETAILS) {
                JFDialogs.create().owner(dialogOwner).message(RspecCompare.differencesListToString((List)requestRspecSource.getLosingDataDifferences(ModelRspecType.FX))).title("Data loss details").buttonTypes(new ButtonType[]{ButtonType.CLOSE}).showInformation();
                System.out.println("Differences:\n" + RspecCompare.differencesListToString((List)requestRspecSource.getLosingDataDifferences(ModelRspecType.FX)));
            }
            if (reason.equals((Object)RspecCheckReason.SWITCH_TO_VISUAL_EDITOR) || reason.equals((Object)RspecCheckReason.RUN_EXPERIMENT)) {
                boolean doAbort = response.isPresent() && response.get() != ButtonType.YES;
                return new RspecValidationResult(requestRspecSource, doAbort);
            }
            return new RspecValidationResult(requestRspecSource, false);
        }
        return null;
    }
}

