/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.SliverTypeBuilder;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskImageUrlValidator
implements RspecValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DiskImageUrlValidator.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        String abortText;
        FXModelRspec modelRspec = (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (modelRspec != null);
        HashSet<Object> permanentProblemNodes = new HashSet<Object>();
        ArrayList<DiskImage> permanentProblemDiskImages = new ArrayList<DiskImage>();
        HashSet<Object> fixableProblemNodes = new HashSet<Object>();
        ArrayList<DiskImage> fixableProblemDiskImages = new ArrayList<DiskImage>();
        for (Object node : modelRspec.getNodes()) {
            for (SliverType sliverType : node.getSliverTypes()) {
                for (DiskImage diskImage : sliverType.getDiskImages()) {
                    if (diskImage.getName() == null && diskImage.getUrl() == null) {
                        permanentProblemNodes.add(node);
                        permanentProblemDiskImages.add(diskImage);
                    }
                    if (diskImage.getName() != null || diskImage.getUrl() == null) continue;
                    fixableProblemNodes.add(node);
                    fixableProblemDiskImages.add(diskImage);
                }
            }
        }
        Object permanentProblemNodesString = "";
        for (Object node : permanentProblemNodes) {
            if (((String)permanentProblemNodesString).isEmpty()) {
                permanentProblemNodesString = (String)permanentProblemNodesString + node.getClientId();
                continue;
            }
            permanentProblemNodesString = (String)permanentProblemNodesString + "," + node.getClientId();
        }
        Object fixableProblemNodesString = "";
        for (RspecNode rspecNode : fixableProblemNodes) {
            if (((String)fixableProblemNodesString).isEmpty()) {
                fixableProblemNodesString = (String)fixableProblemNodesString + rspecNode.getClientId();
                continue;
            }
            fixableProblemNodesString = (String)fixableProblemNodesString + "," + rspecNode.getClientId();
        }
        if (!permanentProblemDiskImages.isEmpty()) {
            void var12_18;
            abortText = "Abort";
            String string = "Ignore";
            boolean showIgnore = false;
            switch (reason) {
                case SWITCH_TO_VISUAL_EDITOR: {
                    abortText = "Abort and return to editor";
                    String string2 = "Ignore";
                    showIgnore = true;
                    break;
                }
                case RUN_EXPERIMENT: {
                    abortText = "Abort and continue editing";
                    String string3 = "Ignore and Run Experiment Anyway";
                    showIgnore = true;
                    break;
                }
                case CHECK_RSPEC: {
                    abortText = "Ok";
                    showIgnore = false;
                    break;
                }
                case OPENED_FILE: {
                    abortText = "Ok";
                    showIgnore = false;
                }
            }
            ButtonType abort = new ButtonType(abortText, ButtonBar.ButtonData.CANCEL_CLOSE);
            ButtonType ignore = new ButtonType((String)var12_18, ButtonBar.ButtonData.CANCEL_CLOSE);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner(dialogOwner);
            alert.setTitle("disk_image without name");
            alert.setContentText("Problem in RSpec: The following nodes have a disk_image without a name: " + (String)permanentProblemNodesString);
            alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            alert.setResizable(true);
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{abort});
            if (showIgnore) {
                alert.getButtonTypes().add((Object)ignore);
            }
            Optional chosenAction = alert.showAndWait();
            switch (reason) {
                case SWITCH_TO_VISUAL_EDITOR: 
                case RUN_EXPERIMENT: {
                    return new RspecValidationResult(requestRspecSource, chosenAction.isPresent() && chosenAction.get() == abort);
                }
                case CHECK_RSPEC: 
                case OPENED_FILE: {
                    return new RspecValidationResult(requestRspecSource, false);
                }
            }
        }
        if (!fixableProblemDiskImages.isEmpty()) {
            void var12_24;
            abortText = "Abort";
            String string = "Fix and continue";
            String ignoreText = "Keep as is and continue";
            boolean showIgnore = false;
            switch (reason) {
                case SWITCH_TO_VISUAL_EDITOR: {
                    abortText = "Keep as is but return to editor";
                    ignoreText = "Ignore";
                    showIgnore = true;
                    break;
                }
                case RUN_EXPERIMENT: {
                    abortText = "Abort and continue editing";
                    ignoreText = "Ignore and Run Experiment Anyway";
                    String string4 = "Fix and Run Experiment";
                    showIgnore = true;
                    break;
                }
                case CHECK_RSPEC: {
                    abortText = "Keep as is";
                    String string5 = "Fix";
                    showIgnore = false;
                    break;
                }
                case OPENED_FILE: {
                    abortText = "Keep as is";
                    String string6 = "Fix";
                    showIgnore = false;
                }
            }
            ButtonType fixButtonType = new ButtonType((String)var12_24, ButtonBar.ButtonData.YES);
            ButtonType ignoreButtonType = new ButtonType(ignoreText, ButtonBar.ButtonData.CANCEL_CLOSE);
            ButtonType abortButtonType = new ButtonType(abortText, ButtonBar.ButtonData.CANCEL_CLOSE);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner(dialogOwner);
            alert.setTitle("disk_image without name");
            alert.setContentText("Problem in RSpec:\nThe following nodes have a disk_image without the required name attribute (instead they have an url attribute):\n  " + (String)fixableProblemNodesString + "\n\nThis disk_image tag without name is not strictly valid, and may fail on some AMs.\n\nDo you want to fix this by converting the url to name?");
            alert.setResizable(true);
            if (showIgnore) {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, ignoreButtonType, abortButtonType});
            } else {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, abortButtonType});
            }
            ButtonType chosenAction = alert.showAndWait().orElse(null);
            if (chosenAction == fixButtonType) {
                LOG.info("Fixing RSpec disk_image");
                for (FXRspecNode fXRspecNode : fixableProblemNodes) {
                    boolean fixSliverTypes = false;
                    ArrayList<SliverType> newSliverTypes = new ArrayList<SliverType>();
                    for (SliverType sliverType : fXRspecNode.getSliverTypes()) {
                        ArrayList<DiskImage> newDiskImages = new ArrayList<DiskImage>();
                        boolean fixDiskImage = false;
                        for (DiskImage diskImage : sliverType.getDiskImages()) {
                            if (diskImage.getName() == null && diskImage.getUrl() != null) {
                                newDiskImages.add(new DiskImage(diskImage.getUrl(), null, diskImage.getOs(), diskImage.getVersion(), diskImage.getDescription(), null));
                                fixDiskImage = true;
                                LOG.info("   Fixed disk_image for name " + fXRspecNode.getClientId());
                                continue;
                            }
                            newDiskImages.add(diskImage);
                        }
                        if (fixDiskImage) {
                            SliverType newSliverType = new SliverTypeBuilder(sliverType).setDiskImages(newDiskImages).build();
                            newSliverTypes.add(newSliverType);
                            fixSliverTypes = true;
                            continue;
                        }
                        newSliverTypes.add(sliverType);
                    }
                    if (!fixSliverTypes) continue;
                    fXRspecNode.getSliverTypes().setAll(newSliverTypes);
                }
                return new RspecValidationResult(modelRspec);
            }
            boolean doAbort = chosenAction == abortButtonType;
            return new RspecValidationResult(requestRspecSource, doAbort);
        }
        return null;
    }
}

