/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentCommandNamespaceValidator
implements RspecValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentCommandNamespaceValidator.class);

    @Override
    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        if (requestRspecSource.getRspecXmlString().contains("experimentCommand xmlns=\"http://jfed.iminds.be/rspec/ext/jfed/1\"")) {
            String abortText = "Abort";
            String fixText = "Fix and continue";
            String ignoreText = "Keep as is and continue";
            boolean showIgnore = false;
            switch (reason) {
                case SWITCH_TO_VISUAL_EDITOR: {
                    abortText = "Keep as is but return to editor";
                    ignoreText = "Ignore";
                    showIgnore = true;
                    break;
                }
                case RUN_EXPERIMENT: {
                    abortText = "Abort and continue editing";
                    ignoreText = "Ignore and Run Experiment Anyway";
                    fixText = "Fix and Run Experiment";
                    showIgnore = true;
                    break;
                }
                case CHECK_RSPEC: {
                    abortText = "Keep as is";
                    fixText = "Fix";
                    showIgnore = false;
                    break;
                }
                case OPENED_FILE: {
                    abortText = "Keep as is";
                    fixText = "Fix";
                    showIgnore = false;
                }
            }
            ButtonType fixButtonType = new ButtonType(fixText, ButtonBar.ButtonData.YES);
            ButtonType ignoreButtonType = new ButtonType(ignoreText, ButtonBar.ButtonData.CANCEL_CLOSE);
            ButtonType abortButtonType = new ButtonType(abortText, ButtonBar.ButtonData.CANCEL_CLOSE);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Wrong experimentCommands namespace");
            alert.setContentText("Problem in RSpec:\nSome experimentCommands in the RSpec are from an older jFed version that had a bug causing them to be in the wrong namespace.\n\nDo you want to fix this by automatically changing to the correct namespace?");
            alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            alert.setResizable(true);
            if (showIgnore) {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, ignoreButtonType, abortButtonType});
            } else {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, abortButtonType});
            }
            Optional result = alert.showAndWait();
            if (result.isPresent() && result.get() == fixButtonType) {
                LOG.info("Fixing experimentCommands namespace");
                FXModelRspec modelRspec = (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
                return new RspecValidationResult(modelRspec);
            }
            if (result.isPresent() && result.get() == ignoreButtonType) {
                return new RspecValidationResult(requestRspecSource, false);
            }
            assert (!result.isPresent() || result.get() == abortButtonType);
            return new RspecValidationResult(requestRspecSource, true);
        }
        return null;
    }
}

