/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;

public class HasComponentManagerIdsValidator
implements RspecValidator {
    @Override
    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        Alert alert;
        FXModelRspec modelRspec = (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (modelRspec != null);
        boolean showAlert = reason != RspecCheckReason.OPENED_FILE && reason != RspecCheckReason.SWITCH_TO_VISUAL_EDITOR;
        boolean invalid = false;
        if (HasComponentManagerIdsValidator.hasNodeWithNullComponentManagerId(modelRspec)) {
            if (showAlert) {
                alert = new Alert(Alert.AlertType.ERROR, "One or more nodes do not have a component_manager_id. This is a mandatory field. thus the Rspec is invalid.", new ButtonType[0]);
                alert.setResizable(true);
                alert.showAndWait();
            }
            invalid = true;
        }
        if (HasComponentManagerIdsValidator.hasLinkWithNullComponentManagerId(modelRspec)) {
            if (showAlert) {
                alert = new Alert(Alert.AlertType.ERROR, "One or more links do not have a component_manager_id. This is a mandatory field. thus the Rspec is invalid.", new ButtonType[0]);
                alert.setResizable(true);
                alert.showAndWait();
            }
            invalid = true;
        }
        if (HasComponentManagerIdsValidator.hasChannelWithNullComponentManagerId(modelRspec)) {
            if (showAlert) {
                alert = new Alert(Alert.AlertType.ERROR, "One or more channels do not have a component_manager_id. This is a mandatory field. thus the Rspec is invalid.", new ButtonType[0]);
                alert.setResizable(true);
                alert.showAndWait();
            }
            invalid = true;
        }
        if (HasComponentManagerIdsValidator.hasAddressPoolWithNullComponentManagerId(modelRspec)) {
            if (showAlert) {
                alert = new Alert(Alert.AlertType.ERROR, "One or more address pools do not have a component_manager_id. This is a mandatory field. thus the Rspec is invalid.", new ButtonType[0]);
                alert.setResizable(true);
                alert.showAndWait();
            }
            invalid = true;
        }
        if (invalid) {
            switch (reason) {
                case RUN_EXPERIMENT: {
                    return new RspecValidationResult(requestRspecSource, true);
                }
                case SWITCH_TO_VISUAL_EDITOR: 
                case CHECK_RSPEC: 
                case OPENED_FILE: {
                    return new RspecValidationResult(requestRspecSource, false);
                }
            }
            throw new IllegalStateException("Unexpected reason");
        }
        return null;
    }

    private static boolean hasNodeWithNullComponentManagerId(FXModelRspec modelRspec) {
        for (FXRspecNode node : modelRspec.getNodes()) {
            if (node.getComponentManagerId() != null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLinkWithNullComponentManagerId(FXModelRspec modelRspec) {
        for (FXRspecLink link : modelRspec.getLinks()) {
            if (!link.getComponentManagerUrns().contains(null)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChannelWithNullComponentManagerId(FXModelRspec modelRspec) {
        for (FXRspecChannel channel : modelRspec.getChannels()) {
            if (channel.getComponentManagerId() != null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAddressPoolWithNullComponentManagerId(FXModelRspec modelRspec) {
        for (FXAddressPool pool : modelRspec.getAddressPools()) {
            if (pool.getComponentManagerId() != null) continue;
            return true;
        }
        return false;
    }
}

