/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasExpiresValidator
implements RspecValidator {
    private static final Logger LOG = LoggerFactory.getLogger(HasExpiresValidator.class);

    @Override
    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        if (requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]).getExpiresString() != null) {
            String abortText = "Abort";
            String fixText = "Remove \"expires\" and continue";
            String ignoreText = "Keep as is and continue";
            boolean showIgnore = false;
            switch (reason) {
                case SWITCH_TO_VISUAL_EDITOR: {
                    return null;
                }
                case RUN_EXPERIMENT: {
                    abortText = "Abort and continue editing";
                    ignoreText = "Ignore and Run Experiment Anyway";
                    fixText = "Remove \"expires\" and Run Experiment";
                    showIgnore = true;
                    break;
                }
                case CHECK_RSPEC: {
                    abortText = "Keep as is";
                    fixText = "Remove \"expires\"";
                    showIgnore = false;
                    break;
                }
                case OPENED_FILE: {
                    abortText = "Keep as is";
                    fixText = "Remove \"expires\"";
                    showIgnore = false;
                }
            }
            ButtonType fixButtonType = new ButtonType(fixText, ButtonBar.ButtonData.YES);
            ButtonType ignoreButtonType = new ButtonType(ignoreText, ButtonBar.ButtonData.CANCEL_CLOSE);
            ButtonType abortButtonType = new ButtonType(abortText, ButtonBar.ButtonData.CANCEL_CLOSE);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner(dialogOwner);
            alert.setTitle("RSpec has \"expires\" attribute");
            alert.setContentText("Problem in RSpec:\nThis RSpec has the \"expires\" attribute. This attribute determines the expiration time of the slivers when sent to certain AM's.\njFed add and removes this attribute when needed, but when using this RSpec with older jFed versions, or other tools, it can cause problems.\nIt is advised to remove the \"expires\" attribute.\n\nDo you want to remove the \"expires\" attribute?");
            alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            alert.setResizable(true);
            if (showIgnore) {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, ignoreButtonType, abortButtonType});
            } else {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, abortButtonType});
            }
            ButtonType chosenAction = alert.showAndWait().orElse(null);
            if (chosenAction == fixButtonType) {
                LOG.info("Removing expires attribute");
                FXModelRspec newModel = (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]).copy();
                newModel.setExpires((String)null);
                return new RspecValidationResult(newModel);
            }
            if (chosenAction == ignoreButtonType) {
                return new RspecValidationResult(requestRspecSource, false);
            }
            if (chosenAction == abortButtonType) {
                return new RspecValidationResult(requestRspecSource, true);
            }
            throw new RuntimeException("Unknown chosen action: " + String.valueOf(chosenAction));
        }
        return null;
    }
}

