/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Alert;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceIdsValidator
implements RspecValidator {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceIdsValidator.class);

    @Override
    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        FXModelRspec modelRspec = (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (modelRspec != null);
        List invalidIds = modelRspec.getLinks().stream().flatMap(link -> link.getInterfaces().stream()).filter(rspecIface -> !rspecIface.isBound()).map(FXRspecInterface::getClientId).distinct().sorted().collect(Collectors.toList());
        if (!invalidIds.isEmpty()) {
            List unboundNodeIfaces = modelRspec.getNodes().stream().flatMap(node -> node.getInterfaces().stream()).filter(rspecIface -> !rspecIface.isBound()).map(FXRspecInterface::getClientId).distinct().sorted().collect(Collectors.toList());
            Alert errorAlert = new Alert(Alert.AlertType.ERROR);
            errorAlert.setHeaderText("Invalid interface references");
            errorAlert.setTitle("Invalid interface references");
            errorAlert.setContentText("The Rspec contains the following link interface reference ids in links that could not be matched to an interface on a node: " + invalidIds.stream().collect(Collectors.joining(", ")) + ".\n\nThe following node interfaces have nothing bound to it: " + unboundNodeIfaces.stream().collect(Collectors.joining(", ")) + ".");
            errorAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            errorAlert.setResizable(true);
            errorAlert.showAndWait();
            return new RspecValidationResult(requestRspecSource, true);
        }
        return null;
    }
}

