/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.rspec.convert.RspecConverter;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import java.util.Objects;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsRequestValidator
implements RspecValidator {
    private static final Logger LOG = LoggerFactory.getLogger(IsRequestValidator.class);

    @Override
    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        if (Objects.equals(requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]).getType(), "manifest")) {
            String abortText = "Abort";
            String fixText = "Convert to Request and continue";
            String ignoreText = "Keep as is and continue";
            boolean showIgnore = false;
            switch (reason) {
                case SWITCH_TO_VISUAL_EDITOR: {
                    return null;
                }
                case RUN_EXPERIMENT: {
                    abortText = "Abort and continue editing";
                    ignoreText = "Ignore and Run Experiment Anyway";
                    fixText = "Convert to Request and Run Experiment";
                    showIgnore = true;
                    break;
                }
                case CHECK_RSPEC: {
                    abortText = "Keep as is";
                    fixText = "Convert to Request";
                    showIgnore = false;
                    break;
                }
                case OPENED_FILE: {
                    abortText = "Keep as is";
                    fixText = "Convert to Request";
                    showIgnore = false;
                }
            }
            ButtonType fixButtonType = new ButtonType(fixText, ButtonBar.ButtonData.YES);
            ButtonType ignoreButtonType = new ButtonType(ignoreText, ButtonBar.ButtonData.CANCEL_CLOSE);
            ButtonType abortButtonType = new ButtonType(abortText, ButtonBar.ButtonData.CANCEL_CLOSE);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner(dialogOwner);
            alert.setContentText("Problem in RSpec:\nThis is a manifest RSpec, and not a request RSpec.\n\nDo you want to convert the manifest to a request?");
            alert.setTitle("Not a Request RSpec");
            alert.setResizable(true);
            if (showIgnore) {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, ignoreButtonType, abortButtonType});
            } else {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, abortButtonType});
            }
            ButtonType chosenAction = alert.showAndWait().orElse(null);
            if (chosenAction == fixButtonType) {
                LOG.info("Converting to Request RSpec");
                RspecConverter converter = new RspecConverter();
                RspecFactory rspecFactory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.FX);
                ButtonType boundNodes = new ButtonType("Keep All Bindings", ButtonBar.ButtonData.OTHER);
                ButtonType unboundNodes = new ButtonType("Remove Resource Bindings", ButtonBar.ButtonData.OTHER);
                ButtonType unboundCMs = new ButtonType("Remove all Bindings", ButtonBar.ButtonData.OTHER);
                Alert bindingAlert = new Alert(Alert.AlertType.CONFIRMATION);
                bindingAlert.initOwner(dialogOwner);
                bindingAlert.setContentText("In a manifest, all nodes are bound to a specific resource.\nIn a request, this is optional.\nYou can also remove the component manager bindings (thus creating an unbound RSpec).\nWhat do you want to do when converting to a request RSpec?\n");
                bindingAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                bindingAlert.setTitle("Convert To Request Options");
                bindingAlert.setResizable(true);
                bindingAlert.getButtonTypes().setAll((Object[])new ButtonType[]{boundNodes, unboundNodes, unboundCMs});
                ButtonType chosenBinding = bindingAlert.showAndWait().orElse(null);
                boolean keepNodeBindings = chosenBinding == boundNodes;
                FXModelRspec newModel = (FXModelRspec)converter.convertManifestToRequest(requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]), keepNodeBindings, rspecFactory);
                if (chosenBinding == unboundCMs) {
                    newModel = (FXModelRspec)converter.removeComponentManagerBindings((ModelRspec)newModel, rspecFactory);
                }
                return new RspecValidationResult(newModel);
            }
            if (chosenAction == ignoreButtonType) {
                return new RspecValidationResult(requestRspecSource, false);
            }
            if (chosenAction == abortButtonType || chosenAction == null) {
                return new RspecValidationResult(requestRspecSource, true);
            }
        }
        return null;
    }
}

