/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.AnsibleServiceValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.CheckIfLosingDataValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.DiskImageUrlValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.ExperimentCommandNamespaceValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.HasComponentManagerIdsValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.HasExpiresValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.InterfaceIdsValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.IsRequestValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.ModelParsingValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.UniqueCliendIdValidator;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import javafx.application.Platform;
import javafx.stage.Window;

public class RspecValidationEngine {
    private final RspecValidator[] validators = new RspecValidator[]{new ModelParsingValidator(), new CheckIfLosingDataValidator(), new InterfaceIdsValidator(), new DiskImageUrlValidator(), new ExperimentCommandNamespaceValidator(), new UniqueCliendIdValidator(), new IsRequestValidator(), new HasExpiresValidator(), new HasComponentManagerIdsValidator(), new AnsibleServiceValidator()};

    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        assert (Platform.isFxApplicationThread());
        boolean requestRspecSourceChanged = false;
        for (RspecValidator validator : this.validators) {
            RspecValidationResult validationResult = validator.validateRSpec(reason, requestRspecSource, dialogOwner);
            if (validationResult == null) continue;
            if (validationResult.isAbort()) {
                return validationResult;
            }
            requestRspecSource = validationResult.getReplacementRequestRspecSource();
            requestRspecSourceChanged = true;
        }
        if (requestRspecSourceChanged) {
            return new RspecValidationResult(requestRspecSource, false);
        }
        return null;
    }
}

