/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation;

import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecCheckReason;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidationResult;
import be.iminds.ilabt.jfed.experimenter_gui.editor.rspec_validation.RspecValidator;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;
import javax.annotation.Nonnull;

public class UniqueCliendIdValidator
implements RspecValidator {
    @Override
    public RspecValidationResult validateRSpec(RspecCheckReason reason, RequestRspecSource requestRspecSource, Window dialogOwner) {
        FXModelRspec modelRspec = (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (modelRspec != null);
        HashSet<String> clientIds = new HashSet<String>();
        HashSet<FXRspecNode> nodesWithDuplicateIds = new HashSet<FXRspecNode>();
        for (FXRspecNode node : modelRspec.getNodes()) {
            if (clientIds.contains(node.getClientId())) {
                nodesWithDuplicateIds.add(node);
            }
            clientIds.add(node.getClientId());
        }
        if (!nodesWithDuplicateIds.isEmpty()) {
            String abortText = "Abort";
            String fixText = "Fix and continue";
            String ignoreText = "Ignore";
            boolean showIgnore = false;
            switch (reason) {
                case SWITCH_TO_VISUAL_EDITOR: {
                    abortText = "Abort and return to editor";
                    ignoreText = "Ignore";
                    showIgnore = true;
                    break;
                }
                case RUN_EXPERIMENT: {
                    abortText = "Abort and continue editing";
                    ignoreText = "Ignore and Run Experiment Anyway";
                    fixText = "Fix and Run Experiment";
                    showIgnore = true;
                    break;
                }
                case CHECK_RSPEC: {
                    abortText = "Ok";
                    fixText = "Fix";
                    showIgnore = false;
                    break;
                }
                case OPENED_FILE: {
                    abortText = "Ok";
                    fixText = "Fix";
                    showIgnore = false;
                }
            }
            List duplicateIds = nodesWithDuplicateIds.stream().map(FXRspecNode::getClientId).distinct().sorted().collect(Collectors.toList());
            ButtonType fixButtonType = new ButtonType(fixText, ButtonBar.ButtonData.YES);
            ButtonType ignoreButtonType = new ButtonType(ignoreText, ButtonBar.ButtonData.CANCEL_CLOSE);
            ButtonType abortButtonType = new ButtonType(abortText, ButtonBar.ButtonData.CANCEL_CLOSE);
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.initOwner(dialogOwner);
            alert.setContentText(String.format("Problem in RSpec: the %s %s %s been used multiple times. This is confusing and will likely lead to problems during deployment.", duplicateIds.size() > 1 ? "id's" : "id", duplicateIds.stream().map(id -> "'" + id + "'").collect(Collectors.joining(", ")), duplicateIds.size() > 1 ? "have" : "has"));
            alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            alert.setTitle("Duplicate id detected!");
            alert.setResizable(true);
            if (showIgnore) {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, ignoreButtonType, abortButtonType});
            } else {
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{fixButtonType, abortButtonType});
            }
            ButtonType chosenAction = alert.showAndWait().orElse(null);
            if (chosenAction == fixButtonType) {
                for (FXRspecNode node : nodesWithDuplicateIds) {
                    String oldClientId = node.getClientId();
                    assert (oldClientId != null);
                    String nextId = UniqueCliendIdValidator.createNextId(node.getClientId() == null ? "node" : node.getClientId());
                    while (clientIds.contains(nextId)) {
                        nextId = UniqueCliendIdValidator.createNextId(nextId);
                    }
                    node.setClientId(nextId);
                    for (FXRspecInterface fxRspecInterface : node.getInterfaces()) {
                        fxRspecInterface.setClientId(fxRspecInterface.getClientId().replace(oldClientId, nextId));
                    }
                    clientIds.add(nextId);
                }
                return new RspecValidationResult(modelRspec);
            }
            switch (reason) {
                case SWITCH_TO_VISUAL_EDITOR: 
                case RUN_EXPERIMENT: {
                    return new RspecValidationResult(requestRspecSource, chosenAction == abortButtonType);
                }
                case CHECK_RSPEC: 
                case OPENED_FILE: {
                    return new RspecValidationResult(requestRspecSource, false);
                }
            }
            throw new IllegalStateException("Unexpected reason");
        }
        return null;
    }

    @Nonnull
    static String createNextId(@Nonnull String id) {
        int numberOfTrailingDigits;
        for (numberOfTrailingDigits = 0; id.length() > numberOfTrailingDigits && Character.isDigit(id.charAt(id.length() - numberOfTrailingDigits - 1)); ++numberOfTrailingDigits) {
        }
        int trailingNumber = 1;
        if (numberOfTrailingDigits > 0) {
            trailingNumber = Integer.parseInt(id.substring(id.length() - numberOfTrailingDigits));
            ++trailingNumber;
        }
        return id.substring(0, id.length() - numberOfTrailingDigits) + Integer.toString(trailingNumber);
    }
}

