/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.tasks;

import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.io.File;
import java.io.FileWriter;
import javafx.concurrent.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveRspecTask
extends Task<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(SaveRspecTask.class);
    private final RequestRspecSource requestRspecSource;
    private final File saveFile;

    public SaveRspecTask(RequestRspecSource requestRspecSource, File saveFile) {
        this.requestRspecSource = requestRspecSource;
        this.saveFile = saveFile;
        this.updateTitle("Saving manifest to \"" + saveFile.getAbsolutePath() + "\"");
    }

    protected Void call() throws Exception {
        FileWriter writer = new FileWriter(this.saveFile);
        writer.write(this.requestRspecSource.getRspecXmlString());
        writer.flush();
        writer.close();
        this.updateMessage("Successfully saved experiment in \"" + this.saveFile.getAbsolutePath() + "\"");
        return null;
    }

    protected void failed() {
        LOG.error("Error while saving experiment to file '" + this.saveFile.getAbsolutePath() + "'", this.getException());
        JFDialogs.create().message("An error occurred while saving the rspec.").masthead("Error").title("Error").showException(this.getException());
    }
}

