/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.views;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilter;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilterBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import org.controlsfx.control.CheckListView;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditCollToolBoxFilterDialog<T extends PrimaryIdObject>
extends BorderPane {
    private static final Logger LOG = LoggerFactory.getLogger(EditCollToolBoxFilterDialog.class);
    private final Class<T> collClazz;
    private final JFedGuiConfig config;
    private final TestbedInfoSource testbedInfoSource;
    private final ToolBoxFilter origToolBoxFilter;
    private final ToolBoxFilterBuilder toolBoxFilter;
    @FXML
    private Label titleLabel;
    @FXML
    private Label filterHeaderLabel;
    @FXML
    private Label selectedCollCountLabel;
    @FXML
    private CheckListView<CollWrapper> collIdList;
    private Map<T, Set<Testbed>> testbedsPerColMap;
    private Map<String, Set<Testbed>> testbedsPerColIdMap;
    private boolean cancel = true;

    public EditCollToolBoxFilterDialog(Class<T> collClazz, JFedGuiConfig config, TestbedInfoSource testbedInfoSource, ToolBoxFilter toolBoxFilter) {
        this.collClazz = collClazz;
        if (!(collClazz.equals(Federation.class) || collClazz.equals(TestbedCategory.class) || collClazz.equals(Organisation.class))) {
            throw new RuntimeException("Unsupported coll class " + collClazz.getSimpleName());
        }
        this.config = config;
        this.testbedInfoSource = testbedInfoSource;
        this.origToolBoxFilter = toolBoxFilter;
        this.toolBoxFilter = new ToolBoxFilterBuilder(toolBoxFilter);
        URL location = ((Object)((Object)this)).getClass().getResource("EditCollToolBoxFilterDialog.fxml");
        assert (location != null);
        FXMLLoader fxmlLoader = new FXMLLoader(location, null);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<T> getAllColls() {
        if (this.collClazz.equals(Federation.class)) {
            Set res = this.config.getAllServersInVisibleResources().stream().map(Server::getTestbed).filter(Objects::nonNull).flatMap(t -> t.getFederations().stream()).filter(Objects::nonNull).filter(f -> !Objects.equals(f.getId(), "fed4fire")).map(arg_0 -> ((TestbedInfoSource)this.testbedInfoSource).getFederation(arg_0)).collect(Collectors.toSet());
            return res;
        }
        if (this.collClazz.equals(TestbedCategory.class)) {
            Set res = this.config.getAllServersInVisibleResources().stream().map(Server::getTestbed).filter(Objects::nonNull).flatMap(t -> t.getCategories().stream()).filter(Objects::nonNull).map(arg_0 -> ((TestbedInfoSource)this.testbedInfoSource).getTestbedCategory(arg_0)).filter(TestbedCategory::isGuiFilter).collect(Collectors.toSet());
            return res;
        }
        if (this.collClazz.equals(Organisation.class)) {
            Set res = this.config.getAllServersInVisibleResources().stream().map(Server::getTestbed).filter(Objects::nonNull).map(Testbed::getOrganisation).filter(Objects::nonNull).map(arg_0 -> ((TestbedInfoSource)this.testbedInfoSource).getOrganisation(arg_0)).collect(Collectors.toSet());
            return res;
        }
        throw new RuntimeException("Unsupported coll class " + this.collClazz.getSimpleName());
    }

    private Map<T, Set<Testbed>> getTestbedsPerColMap() {
        if (this.collClazz.equals(Federation.class)) {
            HashMap<Federation, Set> res = new HashMap<Federation, Set>();
            for (Testbed tb : this.config.getAllServersInVisibleResources().stream().map(Server::getTestbed).filter(Objects::nonNull).collect(Collectors.toSet())) {
                for (Federation f : tb.getFederations()) {
                    res.computeIfAbsent(this.testbedInfoSource.getFederation(f), ff -> new HashSet()).add(tb);
                }
            }
            return res;
        }
        if (this.collClazz.equals(TestbedCategory.class)) {
            HashMap<TestbedCategory, Set> res = new HashMap<TestbedCategory, Set>();
            for (Testbed tb : this.config.getAllServersInVisibleResources().stream().map(Server::getTestbed).filter(Objects::nonNull).collect(Collectors.toSet())) {
                for (TestbedCategory c : tb.getCategories()) {
                    res.computeIfAbsent(this.testbedInfoSource.getTestbedCategory(c), cc -> new HashSet()).add(tb);
                }
            }
            return res;
        }
        if (this.collClazz.equals(Organisation.class)) {
            HashMap<Organisation, Set> res = new HashMap<Organisation, Set>();
            for (Testbed tb : this.config.getAllServersInVisibleResources().stream().map(Server::getTestbed).filter(Objects::nonNull).collect(Collectors.toSet())) {
                if (tb.getOrganisation() == null) continue;
                res.computeIfAbsent(this.testbedInfoSource.getOrganisation(tb.getOrganisation()), k -> new HashSet()).add(tb);
            }
            return res;
        }
        throw new RuntimeException("Unsupported coll class " + this.collClazz.getSimpleName());
    }

    private Collection<String> getFilteredIds(@Nonnull ToolBoxFilter toolBoxFilter) {
        if (this.collClazz.equals(Federation.class)) {
            return toolBoxFilter.getFederationIds();
        }
        if (this.collClazz.equals(TestbedCategory.class)) {
            return toolBoxFilter.getCategoryNames();
        }
        if (this.collClazz.equals(Organisation.class)) {
            return toolBoxFilter.getOrganisationIds();
        }
        throw new RuntimeException("Unsupported coll class " + this.collClazz.getSimpleName());
    }

    @FXML
    private void initialize() {
        assert (this.titleLabel != null);
        assert (this.filterHeaderLabel != null);
        assert (this.selectedCollCountLabel != null);
        assert (this.collIdList != null);
        this.titleLabel.setText(this.collClazz.getSimpleName() + " Filters");
        this.filterHeaderLabel.setText(this.collClazz.getSimpleName() + " Filter:");
        Set allColls = this.getAllColls().stream().map(x$0 -> new CollWrapper(this, x$0)).collect(Collectors.toCollection(TreeSet::new));
        Set filteredColls = allColls.stream().filter(cw -> this.getFilteredIds(this.origToolBoxFilter).contains(cw.getCollId())).collect(Collectors.toCollection(TreeSet::new));
        this.testbedsPerColMap = this.getTestbedsPerColMap();
        this.testbedsPerColIdMap = this.testbedsPerColMap.entrySet().stream().collect(Collectors.toMap(e -> this.getCollId((PrimaryIdObject)e.getKey()), Map.Entry::getValue));
        Comparator collWrapperComparable = (a, b) -> {
            boolean bFirst;
            boolean aFirst = filteredColls.contains(a);
            if (aFirst != (bFirst = filteredColls.contains(b))) {
                return aFirst ? -1 : 1;
            }
            return a.compareTo(b);
        };
        List allTestbedsSorted = allColls.stream().sorted(collWrapperComparable).collect(Collectors.toList());
        this.collIdList.setItems(FXCollections.observableArrayList(allTestbedsSorted));
        for (CollWrapper tw : filteredColls) {
            this.collIdList.getCheckModel().check(this.collIdList.getCheckModel().getItemIndex((Object)tw));
        }
        this.collIdList.getCheckModel().getCheckedItems().addListener(e -> this.updateCountLabel());
        this.updateCountLabel();
    }

    private void updateCountLabel() {
        int count = this.collIdList.getCheckModel().getCheckedItems().size();
        this.selectedCollCountLabel.setText("(" + count + " " + this.collClazz.getSimpleName() + " selected)");
    }

    public void onSaveAction(ActionEvent e) {
        this.cancel = false;
        Stage stage = (Stage)this.getScene().getWindow();
        stage.hide();
    }

    public void onCancelAction(ActionEvent e) {
        this.cancel = true;
        Stage stage = (Stage)this.getScene().getWindow();
        stage.hide();
    }

    public ToolBoxFilter getToolBoxFilter() {
        if (this.cancel) {
            return this.origToolBoxFilter;
        }
        Set<String> selectedCollIds = this.collIdList.getCheckModel().getCheckedItems().stream().map(CollWrapper::getCollId).collect(Collectors.toSet());
        if (this.collClazz.equals(Federation.class)) {
            this.toolBoxFilter.setFederationIds(selectedCollIds);
        }
        if (this.collClazz.equals(TestbedCategory.class)) {
            this.toolBoxFilter.setCategoryNames(selectedCollIds);
        }
        if (this.collClazz.equals(Organisation.class)) {
            this.toolBoxFilter.setOrganisationIds(selectedCollIds);
        }
        return this.toolBoxFilter.create();
    }

    @Nonnull
    public String getCollId(@Nonnull T coll) {
        if (this.collClazz.equals(Federation.class)) {
            return (String)((Federation)coll).getId();
        }
        if (this.collClazz.equals(TestbedCategory.class)) {
            return ((TestbedCategory)coll).getName();
        }
        if (this.collClazz.equals(Organisation.class)) {
            return (String)((Organisation)coll).getId();
        }
        throw new RuntimeException("Unsupported coll class " + this.collClazz.getSimpleName());
    }

    private static class CollWrapper
    implements Comparable {
        @Nonnull
        private final T coll;
        final /* synthetic */ EditCollToolBoxFilterDialog this$0;

        public CollWrapper(T coll) {
            this.this$0 = var1_1;
            this.coll = coll;
        }

        @Nonnull
        public T getColl() {
            return this.coll;
        }

        @Nonnull
        public String getCollId() {
            return this.this$0.getCollId(this.coll);
        }

        public String toString() {
            String suffix;
            assert (this.coll != null);
            String string = suffix = this.this$0.testbedsPerColIdMap == null ? "" : " (contains " + this.this$0.testbedsPerColIdMap.getOrDefault(this.getCollId(), Collections.emptySet()).size() + " testbeds)";
            if (this.this$0.collClazz.equals(Federation.class)) {
                return (((Federation)this.coll).getLongName() == null ? (String)((Federation)this.coll).getId() : ((Federation)this.coll).getLongName()) + suffix;
            }
            if (this.this$0.collClazz.equals(TestbedCategory.class)) {
                return (String)(((TestbedCategory)this.coll).getName() == null ? String.valueOf(((TestbedCategory)this.coll).getId()) : ((TestbedCategory)this.coll).getName()) + suffix;
            }
            if (this.this$0.collClazz.equals(Organisation.class)) {
                return (((Organisation)this.coll).getName() == null ? (String)((Organisation)this.coll).getId() : ((Organisation)this.coll).getName()) + suffix;
            }
            throw new RuntimeException("Unsupported coll class " + this.this$0.collClazz.getSimpleName());
        }

        public int compareTo(@NotNull Object o) {
            assert (o != null);
            return this.toString().toLowerCase().compareTo(o.toString().toLowerCase());
        }

        public boolean equals(Object o) {
            return o instanceof CollWrapper && this.compareTo(o) == 0;
        }
    }
}

