/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.views;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilter;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilterBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.controlsfx.control.CheckListView;
import org.jetbrains.annotations.NotNull;

public class EditTestbedToolBoxFilterDialog
extends BorderPane {
    private final JFedGuiConfig config;
    private final TestbedInfoSource testbedInfoSource;
    private final ToolBoxFilter origToolBoxFilter;
    private final ToolBoxFilterBuilder toolBoxFilter;
    @FXML
    private Label selectedTestbedCountLabel;
    @FXML
    private CheckListView<TestbedWrapper> testbedIdList;
    private boolean cancel = true;

    public EditTestbedToolBoxFilterDialog(JFedGuiConfig config, TestbedInfoSource testbedInfoSource, ToolBoxFilter toolBoxFilter) {
        this.config = config;
        this.testbedInfoSource = testbedInfoSource;
        this.origToolBoxFilter = toolBoxFilter;
        this.toolBoxFilter = new ToolBoxFilterBuilder(toolBoxFilter);
        URL location = ((Object)((Object)this)).getClass().getResource("EditTestbedToolBoxFilterDialog.fxml");
        assert (location != null);
        FXMLLoader fxmlLoader = new FXMLLoader(location, null);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @FXML
    private void initialize() {
        assert (this.selectedTestbedCountLabel != null);
        assert (this.testbedIdList != null);
        Set allTestbeds = this.config.getAllServersInVisibleResources().stream().map(Server::getTestbed).map(TestbedWrapper::new).collect(Collectors.toCollection(TreeSet::new));
        Set filteredTestbeds = allTestbeds.stream().filter(tw -> this.origToolBoxFilter.getTestbedIds().contains(tw.getTestbed().getId())).collect(Collectors.toCollection(TreeSet::new));
        Comparator testbedWrapperComparable = (a, b) -> {
            boolean bFirst;
            boolean aFirst = filteredTestbeds.contains(a);
            if (aFirst != (bFirst = filteredTestbeds.contains(b))) {
                return aFirst ? -1 : 1;
            }
            return a.compareTo(b);
        };
        List allTestbedsSorted = allTestbeds.stream().sorted(testbedWrapperComparable).collect(Collectors.toList());
        this.testbedIdList.setItems(FXCollections.observableArrayList(allTestbedsSorted));
        for (TestbedWrapper tw2 : filteredTestbeds) {
            this.testbedIdList.getCheckModel().check(this.testbedIdList.getCheckModel().getItemIndex((Object)tw2));
        }
        this.testbedIdList.getCheckModel().getCheckedItems().addListener(e -> this.updateCountLabel());
        this.updateCountLabel();
    }

    private void updateCountLabel() {
        int count = this.testbedIdList.getCheckModel().getCheckedItems().size();
        this.selectedTestbedCountLabel.setText("(" + count + " testbeds selected)");
    }

    public void onSaveAction(ActionEvent e) {
        this.cancel = false;
        Stage stage = (Stage)this.getScene().getWindow();
        stage.hide();
    }

    public void onCancelAction(ActionEvent e) {
        this.cancel = true;
        Stage stage = (Stage)this.getScene().getWindow();
        stage.hide();
    }

    public ToolBoxFilter getToolBoxFilter() {
        if (this.cancel) {
            return this.origToolBoxFilter;
        }
        this.toolBoxFilter.setTestbedIds(this.testbedIdList.getCheckModel().getCheckedItems().stream().map(TestbedWrapper::getTestbed).map(PrimaryIdObject::getId).collect(Collectors.toSet()));
        return this.toolBoxFilter.create();
    }

    private static class TestbedWrapper
    implements Comparable {
        private final Testbed testbed;

        public TestbedWrapper(Testbed testbed) {
            this.testbed = testbed;
        }

        public Testbed getTestbed() {
            return this.testbed;
        }

        public int compareTo(@NotNull Object o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.testbed.getLongName();
        }
    }
}

