/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.views;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilter;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilterBuilder;
import be.iminds.ilabt.jfed.experimenter_gui.editor.properties.map.MapDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditCollToolBoxFilterDialog;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditTestbedToolBoxFilterDialog;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.FXUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Federation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Organisation;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestbedCategory;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EditToolBoxFiltersDialogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EditToolBoxFiltersDialogFactory.class);
    @Nonnull
    private final JFedGuiConfig config;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final MapDialogFactory mapDialogFactory;

    @Inject
    public EditToolBoxFiltersDialogFactory(@Nonnull JFedGuiConfig config, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull MapDialogFactory mapDialogFactory) {
        this.config = config;
        this.testbedInfoSource = testbedInfoSource;
        this.mapDialogFactory = mapDialogFactory;
    }

    public ToolBoxFilter showAddTestbedFromMapDialog(@Nullable Window parent, @Nonnull ToolBoxFilter toolBoxFilter) {
        ResourceClass allResourcesClass = this.config.getResourceClass("generic-node-wall2");
        Resource selectedResource = this.mapDialogFactory.showTestbedMapDialog(parent, this.config, allResourcesClass);
        if (selectedResource != null && selectedResource.getServer() != null && selectedResource.getServer().getTestbed() != null) {
            Testbed tb = selectedResource.getServer().getTestbed();
            return new ToolBoxFilterBuilder(toolBoxFilter).addTestbedId((String)tb.getId()).create();
        }
        return toolBoxFilter;
    }

    public ToolBoxFilter showEditTestbedsDialog(@Nullable Window parent, @Nonnull ToolBoxFilter toolBoxFilter) {
        EditTestbedToolBoxFilterDialog editTestbedToolBoxFilterDialog = new EditTestbedToolBoxFilterDialog(this.config, this.testbedInfoSource, toolBoxFilter);
        Scene scene = new Scene((Parent)editTestbedToolBoxFilterDialog);
        Stage dialogStage = new Stage();
        StageUtils.setJFedStageIcons((Stage)dialogStage);
        dialogStage.setScene(scene);
        dialogStage.setTitle("Testbed Filters");
        dialogStage.setMinHeight(600.0);
        dialogStage.setMaxHeight(800.0);
        dialogStage.setMinWidth(500.0);
        if (parent != null) {
            FXUtils.centerToOwner(parent, (Window)dialogStage);
        }
        dialogStage.showAndWait();
        return editTestbedToolBoxFilterDialog.getToolBoxFilter();
    }

    private <T extends PrimaryIdObject> ToolBoxFilter showEditCollDialog(@Nullable Window parent, @Nonnull ToolBoxFilter toolBoxFilter, @Nonnull Class<T> collClazz) {
        EditCollToolBoxFilterDialog<T> editCollToolBoxFilterDialog = new EditCollToolBoxFilterDialog<T>(collClazz, this.config, this.testbedInfoSource, toolBoxFilter);
        Scene scene = new Scene(editCollToolBoxFilterDialog);
        Stage dialogStage = new Stage();
        StageUtils.setJFedStageIcons((Stage)dialogStage);
        dialogStage.setScene(scene);
        dialogStage.setTitle(collClazz.getName() + " Filters");
        dialogStage.setMinHeight(600.0);
        dialogStage.setMaxHeight(800.0);
        dialogStage.setMinWidth(500.0);
        if (parent != null) {
            FXUtils.centerToOwner(parent, (Window)dialogStage);
        }
        dialogStage.showAndWait();
        return editCollToolBoxFilterDialog.getToolBoxFilter();
    }

    public ToolBoxFilter showEditFederationDialog(@Nullable Window parent, @Nonnull ToolBoxFilter toolBoxFilter) {
        return this.showEditCollDialog(parent, toolBoxFilter, Federation.class);
    }

    public ToolBoxFilter showEditOrganisationDialog(@Nullable Window parent, @Nonnull ToolBoxFilter toolBoxFilter) {
        return this.showEditCollDialog(parent, toolBoxFilter, Organisation.class);
    }

    public ToolBoxFilter showEditCategoryDialog(@Nullable Window parent, @Nonnull ToolBoxFilter toolBoxFilter) {
        return this.showEditCollDialog(parent, toolBoxFilter, TestbedCategory.class);
    }
}

