/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.views;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.CanvasNodeFactory;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ModelRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilter;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolboxItem;
import be.iminds.ilabt.jfed.experimenter_gui.editor.addresspool_properties.AddressPoolPropertiesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.channel_properties.ChannelPropertiesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.impl.AddressPoolToolboxItem;
import be.iminds.ilabt.jfed.experimenter_gui.editor.impl.ChannelToolboxItem;
import be.iminds.ilabt.jfed.experimenter_gui.editor.impl.NodeResourceClassToolboxItem;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditToolBoxFiltersDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditableRspecView;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditorViewType;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.ToolBoxFilterPane;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageSize;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditableCanvasEditorView
extends BorderPane
implements EditableRspecView {
    private static final Logger LOG = LoggerFactory.getLogger(EditableCanvasEditorView.class);
    private static final String EDITABLE_CANVAS_EDITOR_VIEW_FXML = "EditableCanvasEditorView.fxml";
    private final ModelRspecEditor modelRspecEditor;
    private final JFedGuiConfig conf;
    private final TestbedInfoSource testbedInfoSource;
    private final JFedHLPreferences preferences;
    private final EditableExperimentCanvas canvas;
    private final VBox toolbox;
    private final ToolBoxFilterPane toolBoxFilterPane;
    private final TilePane resourcesPane;
    private final StringProperty statusProperty = new SimpleStringProperty();
    private final ObjectProperty<ToolBoxFilter> toolBoxFilter = new SimpleObjectProperty((Object)new ToolBoxFilter());
    private final List<ToolboxItem> toolboxItems = new ArrayList<ToolboxItem>();
    private final EventHandler<MouseEvent> toolboxOnDragDetectedHandler = mouseEvent -> {
        ToolboxItem originalItem = (ToolboxItem)mouseEvent.getSource();
        Dragboard dragboard = originalItem.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
        ClipboardContent content = new ClipboardContent();
        content.put((Object)ToolboxItem.getDragDataFormat(), (Object)originalItem.getId());
        dragboard.setContent((Map)content);
        dragboard.setDragView(ImageUtil.imageOrFallback(originalItem.getDragImage(), ImageSize.SMALL));
        this.setStatus("Drop the item somewhere in the canvas.");
        mouseEvent.consume();
    };
    private final EventHandler<DragEvent> toolboxOnDragDoneHandler = event -> {
        if (event.getGestureTarget() == null) {
            this.setStatus("Item can only be dropped on the canvas");
        }
        event.consume();
    };
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String WIRELESS_CHANNEL_ID_PREFIX = "wireless-channel";
    private static final String GEANT_TESTBED_ID_PREFIX = "geant-testbed";
    private static final String ADDRESS_POOL_ID_PREFIX = "address-pool";

    EditableCanvasEditorView(ModelRspecEditor modelRspecEditor, JFedGuiConfig conf, CanvasNodeFactory canvasNodeFactory, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, ChannelPropertiesDialogFactory channelPropertiesDialogFactory, AddressPoolPropertiesDialogFactory addressPoolPropertiesDialogFactory, EventBus eventBus, EditToolBoxFiltersDialogFactory editToolBoxFiltersDialogFactory, JFedHLPreferences preferences) {
        this.modelRspecEditor = modelRspecEditor;
        this.conf = conf;
        this.testbedInfoSource = testbedInfoSource;
        this.preferences = preferences;
        this.toolBoxFilter.setValue((Object)this.getPreferencesToolBoxFilter());
        this.getStylesheets().add((Object)this.getClass().getResource("ExperimenterEditor.css").toExternalForm());
        this.canvas = new EditableExperimentCanvas(modelRspecEditor, conf, canvasNodeFactory, testbedInfoSource, authorityFinder, channelPropertiesDialogFactory, addressPoolPropertiesDialogFactory, eventBus);
        this.canvas.statusProperty().addListener(observable -> this.setStatus(this.canvas.getStatus()));
        this.canvas.setOnDragOver(event -> {
            if (event.getDragboard().hasContent(ToolboxItem.getDragDataFormat())) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
            event.consume();
        });
        this.canvas.setOnDragDropped(event -> {
            String draggedItemId = (String)event.getDragboard().getContent(ToolboxItem.getDragDataFormat());
            ToolboxItem draggedItem = this.findToolboxItemById(draggedItemId);
            Point2D location = new Point2D(event.getSceneX() - this.getCanvas().getLocalToSceneTransform().getTx(), event.getSceneY() - this.getCanvas().getLocalToSceneTransform().getTy());
            Platform.runLater(() -> draggedItem.onAddedToCanvas(this.canvas, location));
            event.consume();
        });
        this.setCenter((Node)this.canvas);
        this.toolBoxFilterPane = new ToolBoxFilterPane(editToolBoxFiltersDialogFactory);
        this.toolBoxFilterPane.setFilter((ToolBoxFilter)this.toolBoxFilter.getValue());
        this.toolBoxFilterPane.setMaxWidth(210.0);
        this.resourcesPane = new TilePane();
        this.resourcesPane.getStyleClass().add((Object)"toolbox-pane");
        this.resourcesPane.setPrefWidth(200.0);
        ScrollPane resourcesScrollPane = new ScrollPane();
        resourcesScrollPane.setContent((Node)this.resourcesPane);
        resourcesScrollPane.setPrefWidth(210.0);
        resourcesScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        resourcesScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        Label toolBoxTitle = new Label("Resources");
        toolBoxTitle.getStyleClass().add((Object)"toolbox-title");
        toolBoxTitle.setPrefWidth(210.0);
        VBox.setVgrow((Node)toolBoxTitle, (Priority)Priority.NEVER);
        this.toolbox = new VBox();
        this.toolbox.getChildren().addAll((Object[])new Node[]{toolBoxTitle, this.toolBoxFilterPane, resourcesScrollPane});
        this.resourcesPane.getChildren().addListener(c -> {
            while (c.next()) {
                for (Node node : c.getAddedSubList()) {
                    assert (node instanceof ToolboxItem);
                    this.registerToolboxDragHandlers((ToolboxItem)node);
                }
            }
        });
        this.resourcesPane.prefHeightProperty().bind((ObservableValue)this.toolbox.heightProperty());
        this.setLeft((Node)this.toolbox);
        this.loadToolboxContent();
        assert (new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                EditableCanvasEditorView.this.toolBoxFilter.addListener((observable, oldValue, newValue) -> {
                    assert (newValue != null);
                });
                return true;
            }
        }.get().booleanValue());
        this.toolBoxFilter.bind(this.toolBoxFilterPane.filterProperty());
        this.toolBoxFilter.addListener((observable, oldValue, newValue) -> this.loadToolboxContent());
        this.toolBoxFilter.addListener((observable, oldValue, newValue) -> this.setPreferencesToolBoxFilter((ToolBoxFilter)newValue));
        modelRspecEditor.setEditableExperimentCanvas(this.canvas);
    }

    @Nonnull
    private ToolBoxFilter getPreferencesToolBoxFilter() {
        String toolBoxfilterJson = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_TOOLBOX_PREV_FILTER);
        if (toolBoxfilterJson == null) {
            return new ToolBoxFilter();
        }
        try {
            return (ToolBoxFilter)MAPPER.readValue(toolBoxfilterJson, ToolBoxFilter.class);
        }
        catch (IOException e) {
            LOG.warn("Failed to restore ToolBoxFilter. Falling back to no filter.", (Throwable)e);
            return new ToolBoxFilter();
        }
    }

    private void setPreferencesToolBoxFilter(@Nonnull ToolBoxFilter toolBoxFilter) {
        try {
            String toolBoxfilterJson = MAPPER.writeValueAsString((Object)toolBoxFilter);
            this.preferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_TOOLBOX_PREV_FILTER, toolBoxfilterJson);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Failed to write ToolBoxFilter. not saving filter.", (Throwable)e);
        }
    }

    private ToolboxItem findToolboxItemById(@Nonnull String draggedItemId) {
        return this.toolboxItems.stream().filter(item -> draggedItemId.equals(item.getId())).findFirst().orElseThrow(() -> new RuntimeException("Could not find ToolboxItem with id " + draggedItemId));
    }

    private static boolean isNormalResourceClass(ResourceClass resourceClass) {
        if (((String)resourceClass.getId()).startsWith(WIRELESS_CHANNEL_ID_PREFIX)) {
            return false;
        }
        if (((String)resourceClass.getId()).startsWith(GEANT_TESTBED_ID_PREFIX)) {
            return false;
        }
        return !((String)resourceClass.getId()).startsWith(ADDRESS_POOL_ID_PREFIX);
    }

    public void setToolBoxFilter(@Nonnull ToolBoxFilter toolBoxFilter) {
        if (toolBoxFilter == null) {
            toolBoxFilter = new ToolBoxFilter();
        }
        this.toolBoxFilter.set((Object)toolBoxFilter);
    }

    @Nullable
    public ToolBoxFilter getToolBoxFilter() {
        return (ToolBoxFilter)this.toolBoxFilter.get();
    }

    @Nonnull
    public ObjectProperty<ToolBoxFilter> toolBoxFilterProperty() {
        return this.toolBoxFilter;
    }

    private void loadToolboxContent() {
        assert (this.toolBoxFilter.get() != null);
        Predicate<ResourceClass> resourceClassFilter = ((ToolBoxFilter)this.toolBoxFilter.get()).getResourceClassFilter();
        Predicate<Server> serverFilter = ((ToolBoxFilter)this.toolBoxFilter.get()).getServerFilter();
        this.toolboxItems.clear();
        this.toolboxItems.addAll(this.conf.getResourceClasses().stream().filter(item -> Objects.equals(item.getVisibleInToolbox(), Boolean.TRUE)).filter(EditableCanvasEditorView::isNormalResourceClass).filter(resourceClassFilter).map(NodeResourceClassToolboxItem::new).collect(Collectors.toList()));
        if ((((ToolBoxFilter)this.toolBoxFilter.get()).isEmpty() || this.testbedInfoSource.getServers().stream().filter(server -> server.hasFlag(Server.Flag.featureWirelessChannelReservation)).filter(serverFilter).findAny().isPresent()) && this.conf.getResourceClasses().stream().filter(item -> Objects.equals(item.getVisibleInToolbox(), Boolean.TRUE)).filter(item -> ((String)item.getId()).startsWith(WIRELESS_CHANNEL_ID_PREFIX)).findAny().isPresent()) {
            this.toolboxItems.add(new ChannelToolboxItem());
        }
        if ((((ToolBoxFilter)this.toolBoxFilter.get()).isEmpty() || this.testbedInfoSource.getServers().stream().filter(server -> server.hasFlag(Server.Flag.featureIPv4AddressPool)).filter(serverFilter).findAny().isPresent()) && this.conf.getResourceClasses().stream().filter(item -> Objects.equals(item.getVisibleInToolbox(), Boolean.TRUE)).filter(item -> ((String)item.getId()).startsWith(ADDRESS_POOL_ID_PREFIX)).findAny().isPresent()) {
            this.toolboxItems.add(new AddressPoolToolboxItem());
        }
        this.toolboxItems.sort(Comparator.naturalOrder());
        this.resourcesPane.getChildren().setAll(this.toolboxItems);
    }

    private void registerToolboxDragHandlers(ToolboxItem toolboxItem) {
        toolboxItem.setOnDragDetected(this.toolboxOnDragDetectedHandler);
        toolboxItem.setOnDragDone(this.toolboxOnDragDoneHandler);
    }

    public void setStatus(String status) {
        this.statusProperty.set((Object)status);
    }

    public StringProperty statusProperty() {
        return this.statusProperty;
    }

    @Override
    public Region getView() {
        return this;
    }

    @Override
    public EditorViewType getType() {
        return EditorViewType.CANVAS;
    }

    @Override
    public RequestRspecSource getRequestRspecSource() {
        return new ImmutableRequestRspecSource((ModelRspec)this.modelRspecEditor.getModelRspec());
    }

    @Override
    public void dispose() {
        this.modelRspecEditor.setEditableExperimentCanvas(null);
    }

    public EditableExperimentCanvas getCanvas() {
        return this.canvas;
    }

    public ModelRspecEditor getModelRspecEditor() {
        return this.modelRspecEditor;
    }

    public void autoLayout() {
        this.canvas.autoLayout();
    }

    public void arrangeNodesOnCircle() {
        this.canvas.arrangeNodesOnCircle();
    }

    public void autoFit() {
        Platform.runLater(this.canvas::autoFit);
    }

    public void autoFit(double screenWidth, double screenHeight) {
        Platform.runLater(() -> this.canvas.autoFit(screenWidth, screenHeight));
    }
}

