/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.views;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.AbstractEditableCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.CanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.NewCanvasLink;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.AddressPoolCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.CanvasNodeFactory;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.ModelRspecToCanvasBinding;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasLink;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecChannelCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ModelRspecEditor;
import be.iminds.ilabt.jfed.experimenter_gui.editor.addresspool_properties.AddressPoolPropertiesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.channel_properties.ChannelPropertiesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.editor.events.ShowLinkPropertiesEvent;
import be.iminds.ilabt.jfed.experimenter_gui.editor.events.ShowNodePropertiesEvent;
import be.iminds.ilabt.jfed.experimenter_gui.util.LinkInfoMatcher;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.DelayRspecNode;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecChannel;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecFactory;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditableExperimentCanvas
extends AbstractEditableCanvas {
    private static final Logger LOG = LoggerFactory.getLogger(EditableExperimentCanvas.class);
    private final ModelRspecEditor modelRspecEditor;
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final JFedGuiConfig config;
    private final FXModelRspec model;
    private final ModelRspecToCanvasBinding binding;
    private final ContextMenu nodeContextMenu;
    private final ContextMenu linkContextMenu;
    private final ContextMenu linkInterfaceContextMenu;
    private final ContextMenu channelContextMenu;
    private final ContextMenu addressPoolContextMenu;
    private final FXRspecFactory rspecFactory = FXRspecFactory.getInstance();
    private final ChannelPropertiesDialogFactory channelPropertiesDialogFactory;
    private final AddressPoolPropertiesDialogFactory addressPoolPropertiesDialogFactory;
    private final EventBus eventBus;

    public EditableExperimentCanvas(ModelRspecEditor modelRspecEditor, JFedGuiConfig config, CanvasNodeFactory canvasNodeFactory, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, ChannelPropertiesDialogFactory channelPropertiesDialogFactory, AddressPoolPropertiesDialogFactory addressPoolPropertiesDialogFactory, EventBus eventBus) {
        this.modelRspecEditor = modelRspecEditor;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.config = config;
        this.model = modelRspecEditor.getModelRspec();
        this.binding = new ModelRspecToCanvasBinding(modelRspecEditor.getModelRspec(), this, config, canvasNodeFactory);
        this.channelPropertiesDialogFactory = channelPropertiesDialogFactory;
        this.addressPoolPropertiesDialogFactory = addressPoolPropertiesDialogFactory;
        this.eventBus = eventBus;
        this.nodeContextMenu = new ContextMenu();
        MenuItem configureItem = new MenuItem("Configure node", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PENCIL));
        configureItem.setOnAction(actionEvent -> {
            assert (this.getSelectionProvider().getSelectedObject() instanceof RspecCanvasNode);
            RspecCanvasNode rspecCanvasNode = (RspecCanvasNode)this.getSelectionProvider().getSelectedObject();
            if (rspecCanvasNode != null) {
                this.onConfigureNodePressed(rspecCanvasNode);
            }
        });
        this.nodeContextMenu.getItems().add((Object)configureItem);
        MenuItem deleteItem = new MenuItem("Delete", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES));
        deleteItem.setOnAction(actionEvent -> {
            assert (this.getSelectionProvider().getSelectedObject() instanceof RspecCanvasNode);
            RspecCanvasNode rspecCanvasNode = (RspecCanvasNode)this.getSelectionProvider().getSelectedObject();
            if (rspecCanvasNode != null) {
                this.onDeleteNodePressed(rspecCanvasNode);
            }
        });
        this.nodeContextMenu.getItems().add((Object)deleteItem);
        this.linkContextMenu = new ContextMenu();
        MenuItem configureLinkItem = new MenuItem("Configure link", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PENCIL));
        configureLinkItem.setOnAction(actionEvent -> {
            assert (this.getSelectionProvider().getSelectedObject() instanceof RspecCanvasLink);
            RspecCanvasLink rspecCanvasLink = (RspecCanvasLink)this.getSelectionProvider().getSelectedObject();
            if (rspecCanvasLink != null) {
                this.onConfigureLinkPressed(rspecCanvasLink.getRspecLink());
            }
        });
        this.linkContextMenu.getItems().add((Object)configureLinkItem);
        MenuItem impairLinkItem = new MenuItem("Add impairment bridge to link", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.EXPAND));
        impairLinkItem.setOnAction(actionEvent -> {
            assert (this.getSelectionProvider().getSelectedObject() instanceof RspecCanvasLink);
            RspecCanvasLink rspecCanvasLink = (RspecCanvasLink)this.getSelectionProvider().getSelectedObject();
            if (rspecCanvasLink != null) {
                this.convertLinkToImpairmentBridge(rspecCanvasLink.getRspecLink());
            }
        });
        this.linkContextMenu.getItems().add((Object)impairLinkItem);
        MenuItem linkDeleteItem = new MenuItem("Delete", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES));
        linkDeleteItem.setOnAction(actionEvent -> {
            assert (this.getSelectionProvider().getSelectedObject() instanceof RspecCanvasLink);
            RspecCanvasLink rspecCanvasLink = (RspecCanvasLink)this.getSelectionProvider().getSelectedObject();
            if (rspecCanvasLink != null) {
                this.onDeleteLinkPressed(rspecCanvasLink);
            }
        });
        this.linkContextMenu.getItems().add((Object)linkDeleteItem);
        this.linkInterfaceContextMenu = new ContextMenu();
        MenuItem deleteItem2 = new MenuItem("Delete", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES));
        deleteItem2.setOnAction(actionEvent -> {
            RspecCanvasLink.InterfaceLink ifaceLink = this.getSelectionProvider().getSelectedInterfaceLink();
            assert (ifaceLink != null);
            this.onDeleteLinkInterfacePressed(ifaceLink);
        });
        this.linkInterfaceContextMenu.getItems().add((Object)deleteItem2);
        this.channelContextMenu = new ContextMenu();
        MenuItem configureChannelMenuItem = new MenuItem("Configure channel", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PENCIL));
        configureChannelMenuItem.setOnAction(actionEvent -> {
            RspecChannelCanvasNode rspecChannelCanvasNode = this.getSelectionProvider().getSelectedChannel();
            this.onConfigureChannelPressed(rspecChannelCanvasNode.getChannel());
        });
        this.channelContextMenu.getItems().add((Object)configureChannelMenuItem);
        deleteItem = new MenuItem("Delete", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES));
        deleteItem.setOnAction(actionEvent -> {
            RspecChannelCanvasNode rspecChannelCanvasNode = this.getSelectionProvider().getSelectedChannel();
            this.onDeleteChannelPressed(rspecChannelCanvasNode);
        });
        this.channelContextMenu.getItems().add((Object)deleteItem);
        this.addressPoolContextMenu = new ContextMenu();
        MenuItem configureMenuItem = new MenuItem("Configure address pool", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PENCIL));
        configureMenuItem.setOnAction(actionEvent -> {
            AddressPoolCanvasNode addressPoolCanvasNode = this.getSelectionProvider().getSelectedAddressPool();
            this.onConfigureAddressPoolPressed(addressPoolCanvasNode.getAddressPool());
        });
        this.addressPoolContextMenu.getItems().add((Object)configureMenuItem);
        deleteItem = new MenuItem("Delete", (Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES));
        deleteItem.setOnAction(actionEvent -> {
            AddressPoolCanvasNode addressPoolCanvasNode = this.getSelectionProvider().getSelectedAddressPool();
            this.onDeleteAddressPoolPressed(addressPoolCanvasNode);
        });
        this.addressPoolContextMenu.getItems().add((Object)deleteItem);
    }

    private void onDeleteChannelPressed(@Nonnull RspecChannelCanvasNode rspecChannelCanvasNode) {
        this.modelRspecEditor.getModelRspec().deleteChannel((Channel)rspecChannelCanvasNode.getChannel());
        if (this.getSelectionProvider().getSelectedObject() == rspecChannelCanvasNode) {
            this.getSelectionProvider().clearAllSelections();
        }
    }

    public boolean onConfigureChannelPressed(@Nonnull FXRspecChannel channel) {
        return this.channelPropertiesDialogFactory.showChannelPropertiesDialog(this.getScene().getWindow(), channel, this.model);
    }

    public boolean onConfigureAddressPoolPressed(@Nonnull FXAddressPool addressPool) {
        return this.addressPoolPropertiesDialogFactory.showAddressPoolPropertiesDialog(this.getScene().getWindow(), addressPool, this.model);
    }

    private void onDeleteAddressPoolPressed(@Nonnull AddressPoolCanvasNode addressPoolCanvasNode) {
        this.model.deleteAddressPool((AddressPool)addressPoolCanvasNode.getAddressPool());
        if (this.getSelectionProvider().getSelectedObject() == addressPoolCanvasNode) {
            this.getSelectionProvider().clearAllSelections();
        }
    }

    @Override
    protected void deleteSelectedItem() {
        if (this.getSelectionProvider().getSelectedObject() instanceof RspecCanvasNode) {
            this.onDeleteNodePressed((RspecCanvasNode)this.getSelectionProvider().getSelectedObject());
        } else if (this.getSelectionProvider().getSelectedObject() instanceof RspecCanvasLink) {
            this.onDeleteLinkPressed((RspecCanvasLink)this.getSelectionProvider().getSelectedObject());
        } else if (this.getSelectionProvider().getSelectedObject() instanceof RspecCanvasLink.InterfaceLink) {
            this.onDeleteLinkInterfacePressed((RspecCanvasLink.InterfaceLink)((Object)this.getSelectionProvider().getSelectedObject()));
        } else if (this.getSelectionProvider().getSelectedObject() instanceof RspecChannelCanvasNode) {
            this.onDeleteChannelPressed((RspecChannelCanvasNode)((Object)this.getSelectionProvider().getSelectedObject()));
        } else if (this.getSelectionProvider().getSelectedObject() != null) {
            LOG.warn("I don't know how to remove {}", this.getSelectionProvider().getSelectedObject());
        }
    }

    private void convertLinkToImpairmentBridge(@Nonnull FXRspecLink rspecLink) {
        if (rspecLink.getInterfaces().size() > 2) {
            JFDialogs.create().owner((Node)this).message("An impairment bridge can only be added on a link between two nodes!").masthead("Unsupported operation").showWarning();
            return;
        }
        DelayRspecNode delayRspecNode = this.modelRspecEditor.convertLinkToImpairmentBridge(rspecLink);
        this.eventBus.post((Object)new ShowNodePropertiesEvent((FXRspecNode)delayRspecNode, this.modelRspecEditor, this.getScene().getWindow()));
    }

    private void onDeleteLinkInterfacePressed(@Nonnull RspecCanvasLink.InterfaceLink ifaceLink) {
        if (ifaceLink.getRspecInterface().getLink().getInterfaces().size() <= 2) {
            this.model.deleteLink((RspecLink)ifaceLink.getRspecInterface().getLink());
        } else {
            ifaceLink.getRspecInterface().delete();
        }
        if (this.getSelectionProvider().getSelectedObject() == ifaceLink) {
            this.getSelectionProvider().clearAllSelections();
        }
    }

    private void onConfigureNodePressed(@Nonnull RspecCanvasNode rspecCanvasNode) {
        this.eventBus.post((Object)new ShowNodePropertiesEvent(rspecCanvasNode.getRspecNode(), this.modelRspecEditor, this.getScene().getWindow()));
    }

    private void onConfigureLinkPressed(@Nonnull FXRspecLink rspecLink) {
        this.eventBus.post((Object)new ShowLinkPropertiesEvent(rspecLink, this.modelRspecEditor, this.getScene().getWindow()));
    }

    private void onDeleteNodePressed(@Nonnull RspecCanvasNode rspecCanvasNode) {
        this.model.deleteNode((RspecNode)rspecCanvasNode.getRspecNode());
        if (this.getSelectionProvider().getSelectedObject() == rspecCanvasNode) {
            this.getSelectionProvider().clearAllSelections();
        }
    }

    private void onDeleteLinkPressed(@Nonnull RspecCanvasLink rspecCanvasLink) {
        this.model.deleteLink((RspecLink)rspecCanvasLink.getRspecLink());
        if (this.getSelectionProvider().getSelectedObject() == rspecCanvasLink) {
            this.getSelectionProvider().clearAllSelections();
        }
    }

    @Override
    public void canvasItemOnMouseClicked(MouseEvent mouseEvent) {
        super.canvasItemOnMouseClicked(mouseEvent);
        if (mouseEvent.getSource() instanceof RspecCanvasNode) {
            RspecCanvasNode node = (RspecCanvasNode)mouseEvent.getSource();
            this.getSelectionProvider().setSelectedObject(node);
            if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2) {
                this.onConfigureNodePressed(node);
            } else if (mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isControlDown()) {
                this.nodeContextMenu.show((Node)node, mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        }
        if (mouseEvent.getSource() instanceof RspecCanvasLink.LinkCenter) {
            RspecCanvasLink link = ((RspecCanvasLink.LinkCenter)mouseEvent.getSource()).getRspecCanvasLink();
            this.getSelectionProvider().setSelectedObject(link);
            if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2) {
                this.onConfigureLinkPressed(link.getRspecLink());
            } else if (mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isControlDown()) {
                this.linkContextMenu.show((Node)link.getLinkCenter(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        }
        if (mouseEvent.getSource() instanceof RspecCanvasLink.InterfaceLink && (mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isControlDown())) {
            RspecCanvasLink.InterfaceLink interfaceLink = (RspecCanvasLink.InterfaceLink)((Object)mouseEvent.getSource());
            this.getSelectionProvider().setSelectedObject((Object)interfaceLink);
            this.linkInterfaceContextMenu.show((Node)interfaceLink, mouseEvent.getScreenX(), mouseEvent.getScreenY());
        }
        if (mouseEvent.getSource() instanceof RspecChannelCanvasNode) {
            RspecChannelCanvasNode channelCanvasNode = (RspecChannelCanvasNode)((Object)mouseEvent.getSource());
            this.getSelectionProvider().setSelectedObject((Object)channelCanvasNode);
            if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2) {
                this.onConfigureChannelPressed(channelCanvasNode.getChannel());
            } else if (mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isControlDown()) {
                this.channelContextMenu.show((Node)channelCanvasNode, mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        }
        if (mouseEvent.getSource() instanceof AddressPoolCanvasNode) {
            AddressPoolCanvasNode addressPoolCanvasNode = (AddressPoolCanvasNode)((Object)mouseEvent.getSource());
            this.getSelectionProvider().setSelectedObject((Object)addressPoolCanvasNode);
            if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2) {
                this.onConfigureAddressPoolPressed(addressPoolCanvasNode.getAddressPool());
            } else if (mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isControlDown()) {
                this.addressPoolContextMenu.show((Node)addressPoolCanvasNode, mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        }
    }

    @Deprecated
    private boolean testForTestbedLinkSupport(FXRspecNode node) {
        if (node.getComponentManagerId() == null) {
            LOG.warn("ComponentManagerId is null for node '{}'", (Object)node.getUniqueId());
            return true;
        }
        ResourceClass resourceClass = node.getResourceClassId() == null ? null : this.config.getResourceClass(node.getResourceClassId());
        Resource resource = this.config.findBestResource(resourceClass, (RspecNode)node, null);
        if (resource == null) {
            return true;
        }
        return resource.getAllowLinksOrDefault() || resource.getAllowStitchedLinksOrDefault();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean processNewLinkRequest(NewCanvasLink newCanvasLink) {
        Optional reply;
        LOG.trace("Received new link request between {} AND {}", (Object)newCanvasLink.getOrigin(), (Object)newCanvasLink.getTarget());
        if (!this.checkNewLinkRequest(newCanvasLink)) {
            return false;
        }
        Resource.LinkInfoRules rules = this.getLinkRules(newCanvasLink);
        if (this.isStitchedLink(newCanvasLink, rules.getDefaultLinkType()) && (!(reply = JFDialogs.create().title("Create stitched link?").message("Stitched links are dedicated L2 links between testbeds. If you run into trouble with this, always mention you are using stitched links when requesting help. Are you sure this is the type of link you want to create?").buttonTypes(new ButtonType[]{ButtonType.YES, ButtonType.CANCEL}).showConfirm()).isPresent() || reply.get() != ButtonType.YES)) {
            LOG.trace("User cancelled new link because it is stitched");
            return false;
        }
        LOG.trace("Received link request is OK!");
        FXRspecLink extendedLink = null;
        if (newCanvasLink.getOrigin() instanceof RspecCanvasNode) {
            FXRspecNode originNode = ((RspecCanvasNode)newCanvasLink.getOrigin()).getRspecNode();
            if (newCanvasLink.getTarget() instanceof RspecCanvasNode) {
                FXRspecNode targetNode = ((RspecCanvasNode)newCanvasLink.getTarget()).getRspecNode();
                FXRspecLink newLink = this.modelRspecEditor.addLink(originNode, targetNode);
                if (rules.getDefaultLinkType() != null) {
                    newLink.getLinkTypes().setAll((Object[])new String[]{rules.getDefaultLinkType()});
                } else {
                    newLink.getLinkTypes().clear();
                }
                this.setStatus("Created a new link '" + newLink.getClientId() + "'");
            } else {
                if (!(newCanvasLink.getTarget() instanceof RspecCanvasLink.LinkCenter)) throw new RuntimeException("Unexpected type of target node: " + newCanvasLink.getTarget().getClass().getName());
                extendedLink = ((RspecCanvasLink.LinkCenter)newCanvasLink.getTarget()).getRspecLink();
                boolean success = this.modelRspecEditor.addLink(extendedLink, originNode);
                if (success) {
                    this.setStatus(String.format("Added node %s to existing link %s", originNode.getClientId(), extendedLink.getClientId()));
                }
            }
        } else {
            if (!(newCanvasLink.getOrigin() instanceof RspecCanvasLink.LinkCenter)) throw new RuntimeException("Unexpected type of origin node: " + newCanvasLink.getOrigin().getClass().getName());
            extendedLink = ((RspecCanvasLink.LinkCenter)newCanvasLink.getOrigin()).getRspecLink();
            if (newCanvasLink.getTarget() instanceof RspecCanvasNode) {
                FXRspecNode targetNode = ((RspecCanvasNode)newCanvasLink.getTarget()).getRspecNode();
                boolean success = this.modelRspecEditor.addLink(extendedLink, targetNode);
                if (success) {
                    this.setStatus(String.format("Added node %s to existing link %s", targetNode.getClientId(), extendedLink.getClientId()));
                }
            } else {
                LOG.debug("Unsupported combination of items (2 link centers)");
                return false;
            }
        }
        if (extendedLink == null || extendedLink.getLinkTypes().size() >= 2) return false;
        if (extendedLink.getLinkTypes().isEmpty()) {
            if (rules.getAllowNoLinkType() == Boolean.TRUE || rules.getDefaultLinkType() == null) return false;
            extendedLink.getLinkTypes().add((Object)rules.getDefaultLinkType());
            return false;
        } else {
            if (rules.getAllowedLinkTypes() == null || rules.getAllowedLinkTypes().contains(extendedLink.getLinkTypes().get(0)) || rules.getDefaultLinkType() == null) return false;
            extendedLink.getLinkTypes().setAll((Object[])new String[]{rules.getDefaultLinkType()});
        }
        return false;
    }

    @Nonnull
    private List<FXRspecNode> getNewLinkNodes(@Nonnull NewCanvasLink newCanvasLink) {
        FXRspecLink existingLink;
        ArrayList<FXRspecNode> nodes = new ArrayList<FXRspecNode>();
        if (newCanvasLink.getOrigin() instanceof RspecCanvasNode) {
            nodes.add(((RspecCanvasNode)newCanvasLink.getOrigin()).getRspecNode());
        } else if (newCanvasLink.getOrigin() instanceof RspecCanvasLink.LinkCenter) {
            existingLink = ((RspecCanvasLink.LinkCenter)newCanvasLink.getOrigin()).getRspecLink();
            nodes.addAll(existingLink.getInterfaces().stream().map(FXRspecInterface::getNode).collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
        if (newCanvasLink.getTarget() instanceof RspecCanvasNode) {
            nodes.add(((RspecCanvasNode)newCanvasLink.getTarget()).getRspecNode());
        } else if (newCanvasLink.getTarget() instanceof RspecCanvasLink.LinkCenter) {
            existingLink = ((RspecCanvasLink.LinkCenter)newCanvasLink.getTarget()).getRspecLink();
            nodes.addAll(existingLink.getInterfaces().stream().map(FXRspecInterface::getNode).collect(Collectors.toList()));
        } else {
            return Collections.emptyList();
        }
        return nodes;
    }

    @Nonnull
    private Resource.LinkInfoRules getLinkRules(@Nonnull NewCanvasLink newCanvasLink) {
        List<FXRspecNode> nodes = this.getNewLinkNodes(newCanvasLink);
        if (nodes.isEmpty()) {
            return new Resource.LinkInfoRules(Boolean.valueOf(false), Boolean.valueOf(false), Collections.singletonList("lan"), null);
        }
        return LinkInfoMatcher.findLinkInfoRules(this.config, nodes);
    }

    private boolean checkNewLinkRequest(@Nonnull NewCanvasLink newCanvasLink) {
        List<FXRspecNode> nodes = this.getNewLinkNodes(newCanvasLink);
        if (nodes.isEmpty()) {
            return false;
        }
        Resource.LinkInfoRules rules = LinkInfoMatcher.findLinkInfoRules(this.config, nodes);
        boolean isStitchedLink = this.isStitchedLink(newCanvasLink, rules.getDefaultLinkType());
        if (rules.getAllowLink() == Boolean.TRUE) {
            return true;
        }
        String testbedsString = nodes.stream().map(FXRspecNode::getComponentManagerId).map(cid -> cid == null ? "unknown testbed" : this.authorityFinder.findByUrn(cid, AuthorityFinder.Purpose.STITCHING).getName()).collect(Collectors.joining(" + "));
        String failReason = (isStitchedLink ? "stitched " : "") + "link not supported for " + testbedsString;
        ButtonType doNotAdd = new ButtonType("Don't Add Link", ButtonBar.ButtonData.NO);
        ButtonType addAnyWay = new ButtonType("Add Link Anyway", ButtonBar.ButtonData.YES);
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, failReason + " \nIt is best not to add this link.\n\nIf you know what you are doing you can add it anyway.", new ButtonType[]{doNotAdd, addAnyWay});
        alert.setHeaderText("Link not supported");
        alert.setTitle("Link not supported");
        alert.setResizable(true);
        alert.getDialogPane().setPrefSize(480.0, 200.0);
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == addAnyWay) {
            this.setStatus("Will add link despite the fact that it is not supported.");
            return true;
        }
        assert (!result.isPresent() || result.get() == doNotAdd);
        this.setStatus("Cannot add link: " + failReason);
        return false;
    }

    @Deprecated
    private boolean processNodeOfNewLinkRequest(RspecCanvasNode canvasNode, boolean isStitchedLink) {
        if (!this.testForTestbedLinkSupport(canvasNode.getRspecNode())) {
            String testbedName = canvasNode.getRspecNode().getComponentManagerId() == null ? "testbed" : this.authorityFinder.findByUrn(canvasNode.getRspecNode().getComponentManagerId(), AuthorityFinder.Purpose.STITCHING).getName();
            Alert alert = new Alert(Alert.AlertType.WARNING, String.format("'%s' does not support links.", testbedName), new ButtonType[0]);
            alert.setHeaderText("Cannot add link");
            alert.setTitle("Cannot add link");
            alert.show();
            this.setStatus(String.format("Cannot add link. '%s' does not support links.", testbedName));
            return false;
        }
        if (isStitchedLink && !this.supportsStitching(canvasNode)) {
            String testbedName = canvasNode.getRspecNode().getComponentManagerId() == null ? "testbed" : this.authorityFinder.findByUrn(canvasNode.getRspecNode().getComponentManagerId(), AuthorityFinder.Purpose.STITCHING).getName();
            ButtonType doNotAdd = new ButtonType("Don't Add Link", ButtonBar.ButtonData.NO);
            ButtonType addAnyWay = new ButtonType("Add Link Anyway", ButtonBar.ButtonData.YES);
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, String.format("'%s' does not support stitched links. It is best not to add this link. If you know what you are doing you can go further.", testbedName), new ButtonType[]{doNotAdd, addAnyWay});
            alert.setHeaderText("Cannot add link");
            alert.setTitle("Cannot add link");
            alert.setResizable(true);
            alert.getDialogPane().setPrefSize(480.0, 200.0);
            Optional result = alert.showAndWait();
            if (result.isPresent() && result.get() == addAnyWay) {
                this.setStatus(String.format("Will add link despite the fact that '%s' does not support stitched links.", testbedName));
                return true;
            }
            assert (!result.isPresent() || result.get() == doNotAdd);
            this.setStatus(String.format("Cannot add link. '%s' does not support stitched links.", testbedName));
            return false;
        }
        return true;
    }

    private boolean supportsStitching(RspecCanvasNode node) {
        if (node.getRspecNode().getComponentManagerId() == null) {
            return false;
        }
        Server server = this.authorityFinder.findByUrn(node.getRspecNode().getComponentManagerId(), AuthorityFinder.Purpose.STITCHING);
        assert (server != null);
        if (server == null) {
            return false;
        }
        return server.hasFlag(Server.Flag.featureStitching);
    }

    @Nullable
    public List<Server> getAddressPoolEnabledServers() {
        return this.testbedInfoSource.getServers().stream().filter(server -> server.hasFlag(Server.Flag.featureIPv4AddressPool)).collect(Collectors.toList());
    }

    @Override
    protected CanvasNode addCopyOfNodeToCanvas(CanvasNode originalCanvasNode) {
        if (!(originalCanvasNode instanceof RspecCanvasNode)) {
            return null;
        }
        RspecCanvasNode originalRspecCanvasNode = (RspecCanvasNode)originalCanvasNode;
        FXRspecNode newRspecNode = this.rspecFactory.copyNode((ModelRspec)this.model, (RspecNode)originalRspecCanvasNode.getRspecNode(), RspecNode.InterfaceCopyMethod.NO_COPY);
        this.modelRspecEditor.updateNodeClientId(newRspecNode, this.model.nextNodeName());
        newRspecNode.setEditorX(newRspecNode.getEditorX() + 15.0);
        newRspecNode.setEditorY(newRspecNode.getEditorY() + 15.0);
        this.model.getNodes().add((Object)newRspecNode);
        for (FXRspecInterface originalIface : originalRspecCanvasNode.getRspecNode().getInterfaces()) {
            if (originalIface.isLinkBound()) {
                LOG.info("Duplicating interface {} of {} to {} into new node {}", new Object[]{originalIface.getUniqueId(), originalRspecCanvasNode.getRspecNode().getUniqueId(), originalIface.getLink().getUniqueId(), newRspecNode.getUniqueId()});
                this.modelRspecEditor.addLink(originalIface.getLink(), newRspecNode);
                continue;
            }
            LOG.info("Duplicating unbound interface {} of {} into new node {}", new Object[]{originalIface.getUniqueId(), originalRspecCanvasNode.getRspecNode().getUniqueId(), newRspecNode.getUniqueId()});
            this.modelRspecEditor.addUnboundInterface(newRspecNode);
        }
        return this.binding.getRspecCanvasNode(newRspecNode);
    }

    @Override
    public boolean isLegalLink(NewCanvasLink newCanvasLink) {
        if (!newCanvasLink.isLinkComplete()) {
            LOG.trace("Requested link is not complete");
            return false;
        }
        if (newCanvasLink.getOrigin() instanceof RspecCanvasNode) {
            FXRspecNode originNode = ((RspecCanvasNode)newCanvasLink.getOrigin()).getRspecNode();
            if (newCanvasLink.getTarget() instanceof RspecCanvasNode) {
                FXRspecNode targetNode = ((RspecCanvasNode)newCanvasLink.getTarget()).getRspecNode();
                if (originNode == targetNode) {
                    LOG.trace("Origin and target-node cannot be identical.");
                    return false;
                }
                return true;
            }
            if (newCanvasLink.getTarget() instanceof RspecCanvasLink.LinkCenter) {
                FXRspecLink targetLink = ((RspecCanvasLink.LinkCenter)newCanvasLink.getTarget()).getRspecLink();
                if (targetLink.isStitched(this.testbedInfoSource)) {
                    LOG.trace("Cannot add node to a stitched link");
                    return false;
                }
                if (this.isStitchedLink(newCanvasLink)) {
                    LOG.trace("Cannot add node from different AM to existing link");
                    return false;
                }
                if (targetLink.getInterfaceForNode((RspecNode)originNode) != null) {
                    LOG.trace("Node already has an interface on the requested link.");
                    return false;
                }
                return true;
            }
            return true;
        }
        if (newCanvasLink.getOrigin() instanceof RspecCanvasLink.LinkCenter) {
            FXRspecLink originLink = ((RspecCanvasLink.LinkCenter)newCanvasLink.getOrigin()).getRspecLink();
            if (originLink.isStitched(this.testbedInfoSource)) {
                LOG.trace("Cannot add node to a stitched link");
                return false;
            }
            if (newCanvasLink.getTarget() instanceof RspecCanvasNode) {
                FXRspecNode targetNode = ((RspecCanvasNode)newCanvasLink.getTarget()).getRspecNode();
                if (this.isStitchedLink(newCanvasLink)) {
                    LOG.trace("Cannot add node from different AM to existing link");
                    return false;
                }
                if (originLink.getInterfaceForNode((RspecNode)targetNode) != null) {
                    LOG.trace("Node already has an interface on the requested link.");
                    return false;
                }
                return true;
            }
            if (newCanvasLink.getTarget() instanceof RspecCanvasLink.LinkCenter) {
                LOG.trace("Cannot link two links together!");
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean isStitchedLink(@Nonnull NewCanvasLink newCanvasLink) {
        return this.isStitchedLink(newCanvasLink, null);
    }

    public boolean isStitchedLink(@Nonnull NewCanvasLink newCanvasLink, @Nullable String defaultLinkType) {
        GeniUrn targetComponentManagerId;
        GeniUrn originComponentManagerId;
        if (!newCanvasLink.isLinkComplete()) {
            return false;
        }
        boolean newLink = true;
        if (newCanvasLink.getOrigin() instanceof RspecCanvasNode) {
            FXRspecNode originNode = ((RspecCanvasNode)newCanvasLink.getOrigin()).getRspecNode();
            if (originNode.getComponentManagerId() == null) {
                return false;
            }
            originComponentManagerId = originNode.getComponentManagerId();
        } else if (newCanvasLink.getOrigin() instanceof RspecCanvasLink.LinkCenter) {
            newLink = false;
            FXRspecLink originLink = ((RspecCanvasLink.LinkCenter)newCanvasLink.getOrigin()).getRspecLink();
            assert (originLink.getInterfaces().size() > 0);
            if (originLink.getInterfaces().isEmpty()) {
                return false;
            }
            FXRspecNode node = ((FXRspecInterface)originLink.getInterfaces().get(0)).getNode();
            if (node == null || node.getComponentManagerId() == null) {
                return false;
            }
            originComponentManagerId = node.getComponentManagerId();
            if (originLink.getLinkTypes().size() > 1 || originLink.getLinkTypes().size() == 1 && !((String)originLink.getLinkTypes().get(0)).equalsIgnoreCase("lan") && !((String)originLink.getLinkTypes().get(0)).equalsIgnoreCase("vlan")) {
                return false;
            }
        } else {
            return false;
        }
        if (newCanvasLink.getTarget() instanceof RspecCanvasNode) {
            FXRspecNode targetNode = ((RspecCanvasNode)newCanvasLink.getTarget()).getRspecNode();
            if (targetNode.getComponentManagerId() == null) {
                return false;
            }
            targetComponentManagerId = targetNode.getComponentManagerId();
        } else if (newCanvasLink.getTarget() instanceof RspecCanvasLink.LinkCenter) {
            newLink = false;
            FXRspecLink targetLink = ((RspecCanvasLink.LinkCenter)newCanvasLink.getTarget()).getRspecLink();
            assert (targetLink.getInterfaces().size() > 0);
            if (targetLink.getInterfaces().isEmpty()) {
                return false;
            }
            FXRspecNode node = ((FXRspecInterface)targetLink.getInterfaces().get(0)).getNode();
            if (node == null || node.getComponentManagerId() == null) {
                return false;
            }
            targetComponentManagerId = node.getComponentManagerId();
            if (targetLink.getLinkTypes().size() > 1 || targetLink.getLinkTypes().size() == 1 && !((String)targetLink.getLinkTypes().get(0)).equalsIgnoreCase("lan") && !((String)targetLink.getLinkTypes().get(0)).equalsIgnoreCase("vlan")) {
                return false;
            }
        } else {
            return false;
        }
        if (newLink && defaultLinkType != null && !defaultLinkType.equals("lan") && !defaultLinkType.equals("vlan")) {
            return false;
        }
        assert (originComponentManagerId != null);
        assert (targetComponentManagerId != null);
        Server originAuth = this.authorityFinder.findByUrn(originComponentManagerId, AuthorityFinder.Purpose.CREATE_SLIVER);
        Server targetAuth = this.authorityFinder.findByUrn(targetComponentManagerId, AuthorityFinder.Purpose.CREATE_SLIVER);
        if (originAuth == null || targetAuth == null) {
            if (originAuth == null) {
                LOG.warn("Could not find authority for " + String.valueOf(originComponentManagerId) + " -> falling back to comparing URNs");
            }
            if (targetAuth == null) {
                LOG.warn("Could not find authority for " + String.valueOf(targetComponentManagerId) + " -> falling back to comparing URNs");
            }
            return !Objects.equals(originComponentManagerId, targetComponentManagerId);
        }
        return !Objects.equals(originAuth.getDefaultComponentManagerAsGeniUrn(), targetAuth.getDefaultComponentManagerAsGeniUrn());
    }

    public ModelRspecEditor getEditor() {
        return this.modelRspecEditor;
    }

    public FXModelRspec getModel() {
        return this.model;
    }
}

