/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.editor.views;

import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilter;
import be.iminds.ilabt.jfed.experimenter_gui.editor.ToolBoxFilterBuilder;
import be.iminds.ilabt.jfed.experimenter_gui.editor.views.EditToolBoxFiltersDialogFactory;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;

public class ToolBoxFilterPane
extends VBox {
    private final Label filtersLabel;
    private final MenuButton editFiltersButton;
    private final FlowPane filterFlowPanel;
    private final EditToolBoxFiltersDialogFactory editToolBoxFiltersDialogFactory;
    private ObjectProperty<ToolBoxFilter> filter = new SimpleObjectProperty((Object)this, "filter", (Object)new ToolBoxFilter());
    private final Map<FilterPart, Node> filterPartToNodeMap = new HashMap<FilterPart, Node>();

    public ToolBoxFilterPane(EditToolBoxFiltersDialogFactory editToolBoxFiltersDialogFactory) {
        this.editToolBoxFiltersDialogFactory = editToolBoxFiltersDialogFactory;
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("ExperimenterEditor.css").toExternalForm());
        this.getStyleClass().add((Object)"toolbox-content");
        HBox header = new HBox();
        this.filtersLabel = new Label("");
        this.filtersLabel.getStyleClass().add((Object)"toolbox-filter-label");
        Pane expandingPane = new Pane();
        HBox.setHgrow((Node)expandingPane, (Priority)Priority.ALWAYS);
        MenuItem addTestbedFilterMI = new MenuItem("Add Testbed Filter...");
        MenuItem addTestbedFromMapFilterMI = new MenuItem("Add Testbed Filter using map...", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.MAP_MARKER));
        MenuItem addFederationFilterMI = new MenuItem("Add Federation Filter...");
        MenuItem addOrganisationFilterMI = new MenuItem("Add Organisation Filter...");
        MenuItem addCategoryFilterMI = new MenuItem("Add Category Filter...");
        MenuItem clearFilterMI = new MenuItem("Clear all Filters");
        this.editFiltersButton = new MenuButton("+", null, new MenuItem[]{addTestbedFilterMI, addTestbedFromMapFilterMI, addFederationFilterMI, addOrganisationFilterMI, addCategoryFilterMI, new SeparatorMenuItem(), clearFilterMI});
        this.editFiltersButton.getStyleClass().remove((Object)"menu-button");
        this.editFiltersButton.getStyleClass().add((Object)"button");
        this.editFiltersButton.setPopupSide(Side.RIGHT);
        this.editFiltersButton.getStyleClass().add((Object)"toolbox-filter-edit");
        addTestbedFilterMI.setOnAction(e -> this.setFilter(editToolBoxFiltersDialogFactory.showEditTestbedsDialog(this.getScene().getWindow(), (ToolBoxFilter)this.filter.get())));
        addTestbedFromMapFilterMI.setOnAction(e -> this.setFilter(editToolBoxFiltersDialogFactory.showAddTestbedFromMapDialog(this.getScene().getWindow(), (ToolBoxFilter)this.filter.get())));
        addFederationFilterMI.setOnAction(e -> this.setFilter(editToolBoxFiltersDialogFactory.showEditFederationDialog(this.getScene().getWindow(), (ToolBoxFilter)this.filter.get())));
        addOrganisationFilterMI.setOnAction(e -> this.setFilter(editToolBoxFiltersDialogFactory.showEditOrganisationDialog(this.getScene().getWindow(), (ToolBoxFilter)this.filter.get())));
        addCategoryFilterMI.setOnAction(e -> this.setFilter(editToolBoxFiltersDialogFactory.showEditCategoryDialog(this.getScene().getWindow(), (ToolBoxFilter)this.filter.get())));
        clearFilterMI.setOnAction(e -> this.setFilter(new ToolBoxFilter()));
        header.getChildren().addAll((Object[])new Node[]{this.filtersLabel, expandingPane, this.editFiltersButton});
        this.filterFlowPanel = new FlowPane();
        this.filterFlowPanel.setHgap(3.0);
        this.filterFlowPanel.setVgap(3.0);
        this.filterFlowPanel.setPrefWrapLength(200.0);
        this.filterFlowPanel.setPrefWidth(210.0);
        this.filterFlowPanel.setMaxWidth(210.0);
        this.setSpacing(5.0);
        this.getChildren().addAll((Object[])new Node[]{header, this.filterFlowPanel});
        this.filter.addListener((observable, oldValue, newValue) -> this.updateFilters((ToolBoxFilter)newValue));
        this.updateFilters((ToolBoxFilter)this.filter.get());
    }

    public final void setFilter(ToolBoxFilter value) {
        this.filterProperty().set((Object)value);
    }

    public final ToolBoxFilter getFilter() {
        return (ToolBoxFilter)this.filter.get();
    }

    public ObjectProperty<ToolBoxFilter> filterProperty() {
        return this.filter;
    }

    public void clearFilters() {
        this.filterFlowPanel.getChildren().removeAll(this.filterPartToNodeMap.values());
    }

    public void updateFilters(@Nullable ToolBoxFilter filter) {
        this.clearFilters();
        if (filter != null) {
            if (filter.isEmpty()) {
                this.filtersLabel.setText("No Filters");
            } else {
                this.filtersLabel.setText("Active Filters:");
            }
            this.filterFlowPanel.getChildren().addAll((Collection)ToolBoxFilterPane.filterToParts(filter).stream().map(this::createFilterPartButton).collect(Collectors.toList()));
        }
    }

    private Node createFilterPartButton(@Nonnull FilterPart filterPart) {
        Button res = new Button((switch (filterPart.type.ordinal()) {
            case 0 -> "";
            case 1 -> "org: ";
            case 2 -> "fed: ";
            case 3 -> "cat: ";
            default -> throw new IllegalArgumentException("filterPart.type=" + String.valueOf((Object)filterPart.type) + " is not supported");
        }) + filterPart.getVal());
        res.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES, (Color)Color.DARKGRAY));
        res.getStyleClass().add((Object)"toolbox-filter-filter");
        res.setOnAction(e -> this.removeFilterPart(filterPart));
        FlowPanelBugWorkaroundPane rres = new FlowPanelBugWorkaroundPane(180.0, new Node[]{res});
        this.filterPartToNodeMap.put(filterPart, (Node)rres);
        return rres;
    }

    private void removeFilterPart(@Nonnull FilterPart filterPart) {
        assert (this.filter.get() != null);
        ToolBoxFilterBuilder newFilter = new ToolBoxFilterBuilder((ToolBoxFilter)this.filter.get());
        switch (filterPart.type.ordinal()) {
            case 0: {
                newFilter.removeTestbedId(filterPart.val);
                break;
            }
            case 1: {
                newFilter.removeOrganisationId(filterPart.val);
                break;
            }
            case 2: {
                newFilter.removeFederationId(filterPart.val);
                break;
            }
            case 3: {
                newFilter.removeCategoryName(filterPart.val);
                break;
            }
            default: {
                throw new IllegalArgumentException("filterPart.type=" + String.valueOf((Object)filterPart.type) + " is not supported");
            }
        }
        this.setFilter(newFilter.create());
    }

    private static List<FilterPart> filterToParts(ToolBoxFilter filter) {
        ArrayList<FilterPart> res = new ArrayList<FilterPart>();
        filter.getTestbedIds().stream().map(name -> new FilterPart(FilterPartType.TESTBED, (String)name)).forEach(res::add);
        filter.getCategoryNames().stream().map(name -> new FilterPart(FilterPartType.CATEGORY, (String)name)).forEach(res::add);
        filter.getOrganisationIds().stream().map(name -> new FilterPart(FilterPartType.ORGANISATION, (String)name)).forEach(res::add);
        filter.getFederationIds().stream().map(name -> new FilterPart(FilterPartType.FEDERATION, (String)name)).forEach(res::add);
        return res;
    }

    private static class FilterPart {
        private final FilterPartType type;
        private final String val;

        public FilterPart(FilterPartType type, String val) {
            this.type = type;
            this.val = val;
        }

        public FilterPartType getType() {
            return this.type;
        }

        public String getVal() {
            return this.val;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterPart that = (FilterPart)o;
            return this.type == that.type && Objects.equals(this.val, that.val);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.val});
        }
    }

    private static enum FilterPartType {
        TESTBED,
        ORGANISATION,
        FEDERATION,
        CATEGORY;

    }

    public static class FlowPanelBugWorkaroundPane
    extends Pane {
        public FlowPanelBugWorkaroundPane() {
        }

        public FlowPanelBugWorkaroundPane(Node ... children) {
            super(children);
        }

        public FlowPanelBugWorkaroundPane(double maxWidth, Node ... children) {
            super(children);
            this.setMaxWidth(maxWidth);
            for (Node child : children) {
                if (!(child instanceof Region)) continue;
                ((Region)child).setMaxWidth(maxWidth);
            }
        }

        protected double computePrefWidth(double height) {
            double orig = super.computePrefWidth(height);
            if (orig > this.getMaxWidth()) {
                return this.getMaxWidth();
            }
            return orig;
        }
    }
}

