/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.events;

import be.iminds.ilabt.jfed.espec.bundle.BundleFetcher;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OpenESpecEvent {
    @Nonnull
    private final ESpecSource eSpecSource;
    @Nullable
    private final File file;
    @Nullable
    private final URL url;
    @Nullable
    private final String gitSpec;
    @Nullable
    private final ESpecBundle directESpecBundle;
    @Nullable
    private final ExperimentController experimentController;

    public OpenESpecEvent(@Nullable ExperimentController experimentController, @Nonnull URL url) {
        this.experimentController = experimentController;
        this.file = null;
        this.eSpecSource = ESpecSource.URL;
        this.url = url;
        this.gitSpec = null;
        this.directESpecBundle = null;
    }

    public OpenESpecEvent(@Nullable ExperimentController experimentController, @Nonnull File file) {
        this.experimentController = experimentController;
        this.file = file;
        this.eSpecSource = file.isDirectory() ? ESpecSource.DIR : ESpecSource.ARCHIVE;
        this.url = null;
        this.gitSpec = null;
        this.directESpecBundle = null;
    }

    public OpenESpecEvent(@Nullable ExperimentController experimentController, @Nonnull String any) throws MalformedURLException {
        this.experimentController = experimentController;
        this.directESpecBundle = null;
        if (any.startsWith("http")) {
            this.file = null;
            this.eSpecSource = ESpecSource.URL;
            this.url = new URL(any);
            this.gitSpec = null;
        } else if (any.startsWith("git ") || any.startsWith("github ")) {
            this.file = null;
            this.eSpecSource = ESpecSource.GIT;
            this.url = null;
            this.gitSpec = any;
        } else {
            this.file = new File(any);
            this.eSpecSource = this.file.isDirectory() ? ESpecSource.DIR : ESpecSource.ARCHIVE;
            this.url = null;
            this.gitSpec = null;
        }
    }

    public OpenESpecEvent(@Nullable ExperimentController experimentController, @Nonnull ESpecBundle eSpecBundle) throws MalformedURLException {
        this.experimentController = experimentController;
        this.file = null;
        this.eSpecSource = ESpecSource.ARCHIVE;
        this.url = null;
        this.gitSpec = null;
        this.directESpecBundle = eSpecBundle;
    }

    @Nonnull
    public ESpecBundle getEspecBundle(JFedPreferences jFedPreferences, GeniUserProvider geniUserProvider) throws InterruptedException, ESpecBundle.ESpecBundleInitException {
        if (this.directESpecBundle != null) {
            return this.directESpecBundle;
        }
        switch (this.eSpecSource.ordinal()) {
            case 0: {
                if (this.file == null) {
                    throw new NullPointerException("openESpecEvent.getFile() is not supposed to be null when eSpecSource=" + String.valueOf((Object)this.eSpecSource));
                }
                return BundleFetcher.fetchDir((File)this.file);
            }
            case 2: {
                if (this.file == null) {
                    throw new NullPointerException("openESpecEvent.getFile() is not supposed to be null when eSpecSource=" + String.valueOf((Object)this.eSpecSource));
                }
                return BundleFetcher.fetchArchiveFile((File)this.file);
            }
            case 1: {
                if (this.url == null) {
                    throw new NullPointerException("openESpecEvent.getUrl() is not supposed to be null when eSpecSource=" + String.valueOf((Object)this.eSpecSource));
                }
                return BundleFetcher.fetchArchiveUrl((URL)this.url);
            }
            case 3: {
                if (this.gitSpec == null) {
                    throw new NullPointerException("gitSpec is not supposed to be null when eSpecSource=" + String.valueOf((Object)this.eSpecSource));
                }
                return BundleFetcher.fetchGitRepoDir((String)this.gitSpec, (GitAuthPreferences)jFedPreferences.getGitAuthPreferences(geniUserProvider.getLoggedInGeniUser()));
            }
        }
        throw new RuntimeException("ESpecSource " + String.valueOf((Object)this.eSpecSource) + " is not supported");
    }

    @Nullable
    public ExperimentController getExperimentController() {
        return this.experimentController;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenESpecEvent)) {
            return false;
        }
        OpenESpecEvent that = (OpenESpecEvent)o;
        return this.eSpecSource == that.eSpecSource && Objects.equals(this.file, that.file) && Objects.equals(this.url, that.url) && Objects.equals(this.gitSpec, that.gitSpec);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eSpecSource, this.file, this.url, this.gitSpec});
    }

    public String toString() {
        return "OpenESpecEvent{eSpecSource=" + String.valueOf((Object)this.eSpecSource) + ", file=" + String.valueOf(this.file) + ", url=" + String.valueOf(this.url) + ", gitSpec='" + this.gitSpec + "'}";
    }

    public static enum ESpecSource {
        DIR,
        URL,
        ARCHIVE,
        GIT;

    }
}

