/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ext_requests;

import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.JFedEnvironment;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.ParameterHandler;
import be.iminds.ilabt.jfed.lib.ApplicationParametersModule;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EnvironmentParameterHandler
implements ParameterHandler<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentParameterHandler.class);
    private final JFedEnvironment environment;
    private final ConnectivityDetector connectivityDetector;
    private final ApplicationParametersModule.ApplicationParameters applicationParameters;

    @Inject
    public EnvironmentParameterHandler(JFedEnvironment environment, ConnectivityDetector connectivityDetector, ApplicationParametersModule.ApplicationParameters applicationParameters) {
        this.environment = environment;
        this.connectivityDetector = connectivityDetector;
        this.applicationParameters = applicationParameters;
    }

    @Override
    public Void handleParameters() {
        Map params = this.applicationParameters.getParameters();
        LOG.debug("Handling environment parameters: " + String.valueOf(params));
        if (params.containsKey("slice_duration")) {
            try {
                this.environment.setDefaultSliceDuration(Integer.parseInt((String)params.get("slice_duration")));
            }
            catch (NumberFormatException ex) {
                LOG.warn("Could not parse given default slice duration '{}'!", params.get("slice_duration"), (Object)ex);
            }
        }
        if (params.containsKey("login-url")) {
            this.environment.setLoginUrl((String)params.get("login-url"));
        }
        if (params.containsKey("config")) {
            this.environment.setCustomConfigurationFile((String)params.get("config"));
            LOG.debug("Using custom config file: " + (String)params.get("config"));
        }
        return null;
    }
}

