/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ext_requests;

import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecFromUrlEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.OpenTutorialFromUrlEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.RecoverSliceEvent;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.ParameterHandler;
import be.iminds.ilabt.jfed.lib.ApplicationParametersModule;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExternalUserRequestHandler
implements ParameterHandler<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalUserRequestHandler.class);
    private final EventBus eventBus;
    private final ApplicationParametersModule.ApplicationParameters applicationParameters;
    private Queue<Object> eventsQueue = new LinkedList<Object>();

    @Inject
    public ExternalUserRequestHandler(EventBus eventBus, ApplicationParametersModule.ApplicationParameters applicationParameters) {
        this.eventBus = eventBus;
        this.applicationParameters = applicationParameters;
    }

    public synchronized void activate() {
        LOG.info("Activating ExternalUserRequestHandler: posting {} events", (Object)this.eventsQueue.size());
        this.eventsQueue.forEach(arg_0 -> ((EventBus)this.eventBus).post(arg_0));
        this.eventsQueue = null;
    }

    public boolean isActive() {
        return this.eventsQueue == null;
    }

    @Override
    public synchronized Void handleParameters() {
        if (!this.isActive()) {
            this.eventsQueue.addAll(this.processParameters(this.applicationParameters.getParameters()));
        } else {
            this.processParameters(this.applicationParameters.getParameters()).forEach(arg_0 -> ((EventBus)this.eventBus).post(arg_0));
        }
        return null;
    }

    private List<Object> processParameters(Map<String, String> params) {
        ArrayList<Object> events = new ArrayList<Object>();
        if (params.containsKey("rspec")) {
            LOG.info("Detected rspec parameter '{}'", (Object)params.get("rspec"));
            events.add(new OpenRequestRspecFromUrlEvent(params.get("rspec")));
        }
        if (params.containsKey("slice_urn")) {
            LOG.info("Detected slice-urn parameter '{}'", (Object)params.get("slice_urn"));
            events.add(new RecoverSliceEvent(params.get("slice_urn")));
        }
        if (params.containsKey("tut")) {
            LOG.info("Detected tutorial parameter '{}'", (Object)params.get("tut"));
            events.add(new OpenTutorialFromUrlEvent(params.get("tut")));
        }
        return events;
    }
}

