/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ext_requests;

import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.ParameterHandler;
import be.iminds.ilabt.jfed.experimenter_gui.login.UserLoginDirector;
import be.iminds.ilabt.jfed.lib.ApplicationParametersModule;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfoFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstLoginParametersHandler
implements ParameterHandler<UserLoginInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(FirstLoginParametersHandler.class);
    private static final String SCHEME_FILE = "file";
    private final UserLoginInfoFactory userLoginInfoFactory;
    private final Provider<Stage> parentStageProvider;
    private final ApplicationParametersModule.ApplicationParameters applicationParameters;

    @Inject
    public FirstLoginParametersHandler(UserLoginInfoFactory userLoginInfoFactory, @Named(value="parentStage") Provider<Stage> parentStageProvider, ApplicationParametersModule.ApplicationParameters applicationParameters) {
        this.userLoginInfoFactory = userLoginInfoFactory;
        this.parentStageProvider = parentStageProvider;
        this.applicationParameters = applicationParameters;
    }

    @Override
    public UserLoginInfo handleParameters() {
        Map params = this.applicationParameters.getParameters();
        LOG.debug("Handling FirstLoginParameters");
        if (params.containsKey("login-certificate")) {
            String loginCertificateLocation = (String)params.get("login-certificate");
            LOG.info("Found login-certificate in parameters. URI={}", (Object)loginCertificateLocation);
            try {
                URI uri = new URI(loginCertificateLocation);
                UserLoginInfo result = this.tryLoginWithUri(uri);
                if (result != null) {
                    return result;
                }
            }
            catch (URISyntaxException ex) {
                LOG.error("Could not parse provided login certificate location", (Throwable)ex);
            }
        }
        if (params.containsKey("login-certificate-string")) {
            String loginCertificateString = (String)params.get("login-certificate-string");
            LOG.info("Found login-certificate string in parameters. size={}", (Object)loginCertificateString.length());
            try {
                byte[] decodedLoginCertificate = DatatypeConverter.parseBase64Binary((String)loginCertificateString);
                String decodedLoginCertificateString = new String(decodedLoginCertificate);
                LOG.trace("Base64-decoded login certificate (size={})", (Object)decodedLoginCertificateString.length());
                UserLoginInfo result = this.tryLoginWithString(decodedLoginCertificateString);
                if (result != null) {
                    return result;
                }
            }
            catch (IllegalArgumentException ex) {
                LOG.warn("Could not Base64-decode login-certificate-string", (Throwable)ex);
            }
        }
        if (params.containsKey("login-hash")) {
            File loginCertFile = UserLoginDirector.getLoginCertificateFile((String)params.get("login-hash"));
            if (loginCertFile.exists()) {
                LOG.info("Found cached certificate with hash {}", params.get("login-hash"));
                UserLoginInfo result = this.tryLoginWithUri(loginCertFile.toURI());
                if (result != null) {
                    return result;
                }
            } else {
                LOG.info("Could not find cached login certificate with hash {}", params.get("login-hash"));
            }
        }
        return null;
    }

    private UserLoginInfo tryLoginWithUri(URI uri) {
        if (Objects.equals(uri.getScheme(), SCHEME_FILE)) {
            File loginCertificateFile = new File(uri);
            try {
                return this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(loginCertificateFile);
            }
            catch (IOException e) {
                LOG.error("Error while loading userLoginCertificate from file {}", (Object)loginCertificateFile.getAbsolutePath());
                return null;
            }
        }
        try {
            return this.userLoginInfoFactory.createKeyCertUrlUserLoginInfo(uri.toURL());
        }
        catch (IOException e) {
            LOG.error("Error while loading userLoginCertificate from uri {}", (Object)uri.toString());
            return null;
        }
    }

    private UserLoginInfo tryLoginWithString(String loginString) {
        return this.userLoginInfoFactory.createManualUserLoginInfo(loginString);
    }
}

