/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ext_requests;

import be.iminds.ilabt.jfed.experimenter_gui.events.OpenRequestRspecFromUrlEvent;
import be.iminds.ilabt.jfed.experimenter_gui.events.RecoverSliceEvent;
import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.ParameterHandler;
import be.iminds.ilabt.jfed.lib.ApplicationParametersModule;
import com.google.common.eventbus.EventBus;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralParameterHandler
implements ParameterHandler<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralParameterHandler.class);
    private final EventBus eventBus;
    private final ApplicationParametersModule.ApplicationParameters applicationParameters;

    @Inject
    public GeneralParameterHandler(EventBus eventBus, ApplicationParametersModule.ApplicationParameters applicationParameters) {
        this.eventBus = eventBus;
        this.applicationParameters = applicationParameters;
    }

    @Override
    public Void handleParameters() {
        Map parameters = this.applicationParameters.getParameters();
        if (parameters.containsKey("slice_urn")) {
            String sliceUrnParam = (String)parameters.get("slice_urn");
            if (!(sliceUrnParam = sliceUrnParam.trim()).isEmpty()) {
                this.eventBus.post((Object)new RecoverSliceEvent(sliceUrnParam));
            } else {
                LOG.warn("Got an empty slice-urn");
            }
        }
        if (parameters.containsKey("rspec")) {
            String rspecLocation = (String)parameters.get("rspec");
            if (!(rspecLocation = rspecLocation.trim()).isEmpty()) {
                this.eventBus.post((Object)new OpenRequestRspecFromUrlEvent(rspecLocation));
            } else {
                LOG.warn("Got an empty rspec location");
            }
        }
        return null;
    }
}

