/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.ext_requests;

import be.iminds.ilabt.jfed.experimenter_gui.ext_requests.ParameterHandler;
import be.iminds.ilabt.jfed.lib.ApplicationParametersModule;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.lowlevel.user.ManualUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfoFactory;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginValidationParameterHandler
implements ParameterHandler<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(LoginValidationParameterHandler.class);
    private final GeniUserProvider geniUserProvider;
    private final UserLoginInfoFactory userLoginInfoFactory;
    private final ApplicationParametersModule.ApplicationParameters applicationParameters;

    @Inject
    public LoginValidationParameterHandler(GeniUserProvider geniUserProvider, UserLoginInfoFactory userLoginInfoFactory, ApplicationParametersModule.ApplicationParameters applicationParameters) {
        this.geniUserProvider = geniUserProvider;
        this.userLoginInfoFactory = userLoginInfoFactory;
        this.applicationParameters = applicationParameters;
    }

    @Override
    public Boolean handleParameters() {
        Map parameters = this.applicationParameters.getParameters();
        String loginCertificate = null;
        if (parameters.containsKey("login-certificate-string")) {
            String loginCertificateString = (String)parameters.get("login-certificate-string");
            LOG.info("Found login-certificate string in parameters. size={}", (Object)loginCertificateString.length());
            try {
                byte[] decodedLoginCertificate = DatatypeConverter.parseBase64Binary((String)loginCertificateString);
                loginCertificate = new String(decodedLoginCertificate);
            }
            catch (IllegalArgumentException ex) {
                LOG.warn("Could not Base64-decode login-certificate-string. Ignoring!", (Throwable)ex);
            }
        }
        if (parameters.containsKey("login-certificate")) {
            try {
                URL loginCertificateLocation = new URL((String)parameters.get("login-certificate"));
                loginCertificate = IOUtils.urlToString((URL)loginCertificateLocation, (Charset)Charset.defaultCharset());
            }
            catch (MalformedURLException ex) {
                LOG.error("Could not parse provided login certificate location", (Throwable)ex);
            }
            catch (IOException ex) {
                LOG.error("Could not fetch the login certificate", (Throwable)ex);
            }
        }
        if (loginCertificate != null) {
            GeniUrn newUserUrn = this.deriveUserUrnFromCertificate(loginCertificate);
            if (this.geniUserProvider.isUserLoggedIn() && !Objects.equals(this.geniUserProvider.getLoggedInGeniUser().getUserUrn(), newUserUrn)) {
                LOG.error("Got an URI with different login credentials ({}) than the user currently logged in ({})", (Object)newUserUrn, (Object)this.geniUserProvider.getLoggedInGeniUser().getUserUrn());
                return false;
            }
            LOG.info("Got an URI with same login credentials as currently logged in user ({})", (Object)newUserUrn);
            return true;
        }
        LOG.debug("Got an URI without login information.");
        return true;
    }

    private GeniUrn deriveUserUrnFromCertificate(String certificate) {
        ManualUserLoginInfo userLoginInfo = this.userLoginInfoFactory.createManualUserLoginInfo(certificate);
        return userLoginInfo.getUserUrn();
    }
}

