/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.login;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.SafeConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.SslHostAndPortTest;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoginConnectivityTest {
    private static final Logger LOG = LoggerFactory.getLogger(LoginConnectivityTest.class);
    private final Server userAuthority;
    private final ProxyPreferencesManager proxyPrefMan;
    private final GeniUserProvider geniUserProvider;
    private final TestbedInfoSource testbedInfoSource;
    private final JFedHLPreferences jFedPreferences;

    public LoginConnectivityTest(Server userAuthority, ProxyPreferencesManager proxyPrefMan, GeniUserProvider geniUserProvider, TestbedInfoSource testbedInfoSource, JFedHLPreferences jFedPreferences) {
        this.userAuthority = userAuthority;
        this.proxyPrefMan = proxyPrefMan;
        this.geniUserProvider = geniUserProvider;
        this.testbedInfoSource = testbedInfoSource;
        this.jFedPreferences = jFedPreferences;
    }

    protected abstract void busyMessage(String var1);

    protected abstract void okMessage(String var1);

    protected abstract void errorMessage(String var1);

    protected abstract void connectivityTestFinished(boolean var1, boolean var2);

    protected abstract Stage getDialogStage();

    public void start() {
        Thread cttThread = new Thread(() -> {
            try {
                boolean continueLogin;
                boolean proxyAvailable = this.userAuthority != null && this.userAuthority.getTestbed() != null && this.userAuthority.getTestbed().getProxies() != null && !this.userAuthority.getTestbed().getProxies().isEmpty();
                boolean proxyActivated = this.proxyPrefMan.isProxyEnabledForJfed();
                if (!proxyAvailable && proxyActivated) {
                    FutureTask<Boolean> alertTask = new FutureTask<Boolean>(() -> {
                        Alert noProxyAlert = new Alert(Alert.AlertType.WARNING);
                        noProxyAlert.initOwner((Window)this.getDialogStage());
                        noProxyAlert.setContentText(String.format("jFed does not know a proxy for your user authority (%s)\nHowever, the proxy is activated in the jFed settings\n\nDo you want to deactivate the proxy in the settings and continue?", this.userAuthority != null ? this.userAuthority.getName() : "null"));
                        noProxyAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        noProxyAlert.setTitle("Deactivate Proxy?");
                        noProxyAlert.setHeaderText("Deactivate Proxy?");
                        noProxyAlert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL});
                        noProxyAlert.setResizable(true);
                        return noProxyAlert.showAndWait().filter(r -> r == ButtonType.YES).isPresent();
                    });
                    Platform.runLater(alertTask);
                    if (alertTask.get().booleanValue()) {
                        LOG.info("Deactivating proxy");
                        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, "NEVER");
                        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, "NEVER");
                        this.proxyPrefMan.updateProxySettings();
                    } else {
                        this.connectivityTestFinished(false, true);
                        return;
                    }
                }
                if (proxyActivated) {
                    boolean userAmWithoutProxyOk;
                    this.busyMessage("Proxy activated. Checking proxy ports...");
                    assert (proxyAvailable);
                    boolean proxyOk = this.blockingTestProxy();
                    if (proxyOk) {
                        boolean userAmWithProxyOk = true;
                        userAmWithoutProxyOk = false;
                    } else {
                        this.busyMessage("Proxy activated. No reachable proxy ports... Checking connectivity without proxy...");
                        userAmWithoutProxyOk = this.blockingTestConnectivity(false);
                        boolean userAmWithProxyOk = false;
                    }
                    if (proxyOk) {
                        this.okMessage("Successfully connected using proxy.");
                        this.connectivityTestFinished(true, false);
                        return;
                    }
                    if (userAmWithoutProxyOk) {
                        FutureTask<Boolean> proxyUnreachableAlertTask = new FutureTask<Boolean>(() -> {
                            Alert proxyUnreachableAlert = new Alert(Alert.AlertType.WARNING);
                            proxyUnreachableAlert.initOwner((Window)this.getDialogStage());
                            proxyUnreachableAlert.setContentText("jFed could not contact the server using the proxy, but was able to contact it without proxy.\nDo you want to deactivate the proxy and continue?");
                            proxyUnreachableAlert.setTitle("Proxy unreachable");
                            proxyUnreachableAlert.setHeaderText("Proxy unreachable");
                            proxyUnreachableAlert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL});
                            proxyUnreachableAlert.setResizable(true);
                            return proxyUnreachableAlert.showAndWait().filter(r -> r == ButtonType.YES).isPresent();
                        });
                        Platform.runLater(proxyUnreachableAlertTask);
                        boolean deactivateAndContinue = proxyUnreachableAlertTask.get();
                        if (deactivateAndContinue) {
                            LOG.info("Deactivating proxy");
                            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, "NEVER");
                            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, "NEVER");
                            this.proxyPrefMan.updateProxySettings();
                        }
                        this.connectivityTestFinished(true, !deactivateAndContinue);
                        return;
                    }
                } else {
                    boolean userAmWithProxyOk;
                    boolean proxyOk;
                    if (proxyAvailable) {
                        this.busyMessage("Proxy not activated. Testing connectivity...");
                    } else {
                        this.busyMessage("Testing connectivity...");
                    }
                    boolean userAmWithoutProxyOk = this.blockingTestConnectivity(false);
                    if (!userAmWithoutProxyOk) {
                        if (proxyAvailable) {
                            this.busyMessage("No connectivity. Checking proxy ports...");
                            proxyOk = this.blockingTestProxy();
                            if (proxyOk) {
                                this.busyMessage("No connectivity. Reachable proxy ports. Testing connectivity using proxy...");
                                userAmWithProxyOk = this.blockingTestConnectivity(true);
                            } else {
                                userAmWithProxyOk = false;
                            }
                        } else {
                            proxyOk = false;
                            userAmWithProxyOk = false;
                        }
                    } else {
                        proxyOk = false;
                        userAmWithProxyOk = false;
                    }
                    if (userAmWithoutProxyOk) {
                        this.okMessage("Successfully connected.");
                        this.connectivityTestFinished(true, false);
                        return;
                    }
                    if (proxyOk && userAmWithProxyOk) {
                        FutureTask<Boolean> activateProxyAlertTask = new FutureTask<Boolean>(() -> {
                            Alert enableProxyAlert = new Alert(Alert.AlertType.CONFIRMATION);
                            enableProxyAlert.initOwner((Window)this.getDialogStage());
                            enableProxyAlert.setContentText("jFed could not contact the server without the proxy, but was able to contact it with proxy.");
                            enableProxyAlert.setTitle("Activate Proxy?");
                            enableProxyAlert.setHeaderText("Activate Proxy?");
                            enableProxyAlert.getButtonTypes().setAll((Object[])new ButtonType[]{new ButtonType("Activate and Login", ButtonBar.ButtonData.YES), new ButtonType("Cancel Login", ButtonBar.ButtonData.CANCEL_CLOSE)});
                            enableProxyAlert.setResizable(true);
                            return enableProxyAlert.showAndWait().filter(r -> r.getButtonData().equals((Object)ButtonBar.ButtonData.YES)).isPresent();
                        });
                        Platform.runLater(activateProxyAlertTask);
                        boolean activateAndContinue = activateProxyAlertTask.get();
                        if (activateAndContinue) {
                            LOG.info("Activating proxy");
                            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, "ALWAYS");
                            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, "ALWAYS");
                            this.proxyPrefMan.updateProxySettings();
                        }
                        this.connectivityTestFinished(true, !activateAndContinue);
                        return;
                    }
                }
                this.errorMessage("Connectivity Problem");
                if (proxyAvailable) {
                    FutureTask<Boolean> continueWithoutProxyAlertTask = new FutureTask<Boolean>(() -> {
                        Alert noConnectivityAlert = new Alert(Alert.AlertType.ERROR);
                        noConnectivityAlert.initOwner((Window)this.getDialogStage());
                        noConnectivityAlert.setContentText("jFed could not contact the server with or without using the proxy.\n" + (proxyActivated ? "Note: The jFed proxy is activated in your settings and will stay activated." : "Note: The jFed proxy is deactivated in your settings and will stay deactivated.") + "\n\nDo you want to continue anyway? (Most likely, nothing will work)");
                        noConnectivityAlert.setTitle("Connectivity Problem");
                        noConnectivityAlert.setHeaderText("Connectivity Problem");
                        noConnectivityAlert.getButtonTypes().setAll((Object[])new ButtonType[]{new ButtonType("Continue", ButtonBar.ButtonData.YES), new ButtonType("Cancel Login", ButtonBar.ButtonData.CANCEL_CLOSE)});
                        noConnectivityAlert.setResizable(true);
                        return noConnectivityAlert.showAndWait().filter(r -> r.getButtonData().equals((Object)ButtonBar.ButtonData.YES)).isPresent();
                    });
                    Platform.runLater(continueWithoutProxyAlertTask);
                    continueLogin = continueWithoutProxyAlertTask.get();
                } else {
                    FutureTask<Boolean> continueWithoutConnectivityAlertTask = new FutureTask<Boolean>(() -> {
                        Alert noConnectivityAndProxyAlert = new Alert(Alert.AlertType.ERROR);
                        noConnectivityAndProxyAlert.initOwner((Window)this.getDialogStage());
                        noConnectivityAndProxyAlert.setContentText(String.format("jFed could not contact the server.\nNote: jFed knows no proxy for your user authority (%s), so no proxy was tried.\n\nDo you want to continue anyway? (Most likely, nothing will work)", this.userAuthority != null ? this.userAuthority.getName() : "null"));
                        noConnectivityAndProxyAlert.setTitle("Connectivity Problem");
                        noConnectivityAndProxyAlert.setHeaderText("Connectivity Problem");
                        noConnectivityAndProxyAlert.setResizable(true);
                        noConnectivityAndProxyAlert.getButtonTypes().setAll((Object[])new ButtonType[]{new ButtonType("Continue", ButtonBar.ButtonData.YES), new ButtonType("Cancel Login", ButtonBar.ButtonData.CANCEL_CLOSE)});
                        return noConnectivityAndProxyAlert.showAndWait().filter(r -> r.getButtonData().equals((Object)ButtonBar.ButtonData.YES)).isPresent();
                    });
                    Platform.runLater(continueWithoutConnectivityAlertTask);
                    continueLogin = continueWithoutConnectivityAlertTask.get();
                }
                this.connectivityTestFinished(false, !continueLogin);
            }
            catch (AssertionError | Exception e) {
                LOG.error("Exception while testing connectivity", (Throwable)e);
                this.errorMessage("Exception while testing connectivity: " + ((Throwable)e).getMessage());
                this.connectivityTestFinished(false, true);
            }
        });
        cttThread.setName("ConnectivityTestThread");
        cttThread.setDaemon(true);
        cttThread.start();
    }

    private boolean proxyEnabledInPreferences() {
        return this.proxyPrefMan.isProxyEnabledForJfed();
    }

    private boolean blockingTestProxy() {
        this.busyMessage("Testing connectivity to proxy...");
        ProxyPreferencesManager.TryProxyTask tryProxyTask = this.proxyPrefMan.getTryProxyTask(this.userAuthority);
        Thread thread = new Thread((Runnable)tryProxyTask);
        thread.setName("ProxyTestThread");
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join(60000L);
        }
        catch (InterruptedException e) {
            LOG.error("Thread " + thread.getName() + " was interrupted.", (Throwable)e);
        }
        if (thread.isAlive()) {
            this.errorMessage("Proxy Test Task takes too long. Assuming failure.");
            LOG.error("Proxy Test Task takes too long. Assuming failure. " + tryProxyTask.getMessage(), tryProxyTask.getException());
            return false;
        }
        if (!tryProxyTask.isFinished()) {
            this.errorMessage("Proxy Test Task Failed.");
            LOG.error("Proxy Test Task Failed. " + tryProxyTask.getMessage(), tryProxyTask.getException());
            return false;
        }
        boolean res = tryProxyTask.isSuccess();
        this.proxyPrefMan.updateProxySettings();
        return res;
    }

    private boolean blockingTestConnectivity(boolean useProxy) {
        JFedConnection.SshProxyInfo proxyInfo;
        if (this.userAuthority.getServices() == null || this.userAuthority.getServices().isEmpty()) {
            LOG.warn("Could not find URL for AM to test connectivity");
            return false;
        }
        URL url = ApiInfo.findUrl((Server)this.userAuthority, (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2));
        if (url == null) {
            url = ApiInfo.findUrl((Server)this.userAuthority, (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3));
        }
        if (url == null) {
            url = ApiInfo.findUrl((Server)this.userAuthority, (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 4));
        }
        if (url == null) {
            url = ApiInfo.findUrl((Server)this.userAuthority, (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 1));
        }
        if (url == null) {
            try {
                url = new URL(((Service)this.userAuthority.getServices().get(0)).getUrl());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("BasicTestbedInfoSource should have prevented this exception from being possible", e);
            }
        }
        LOG.debug("Trying to contact '{}' for connectivity test.", (Object)url.toExternalForm());
        if (useProxy) {
            GeniUser currentUser;
            GeniUser geniUser = currentUser = this.geniUserProvider.getLoggedInGeniUser();
            proxyInfo = this.proxyPrefMan.chooseUserProxy(this.userAuthority.getTestbed().getProxies(), currentUser, (SshKeyInfo)SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser));
            if (proxyInfo == null) {
                LOG.warn("useProxy=true but proxyInfo=null");
            }
        } else {
            proxyInfo = null;
        }
        SslHostAndPortTest sslHostAndPortTest = new SslHostAndPortTest(url, null, null, proxyInfo, this.testbedInfoSource);
        SafeConnectivityTest safeSslHostAndPortTest = new SafeConnectivityTest((ConnectivityTest)sslHostAndPortTest, 22000L);
        Optional testResult = safeSslHostAndPortTest.call();
        if (!testResult.isPresent() || ((ConnectivityTest.ConnectivityTestResult)testResult.get()).getStatus() != ConnectivityTest.Status.SUCCEEDED) {
            LOG.warn("Could not establish SSL-connection to {} with proxyInfo {}", (Object)url, (Object)proxyInfo);
            return false;
        }
        LOG.info("Successfully connected to the AM in connectivity test. useProxy=" + useProxy);
        return true;
    }
}

