/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.login;

import be.iminds.ilabt.jfed.base_gui.util.JFedCommonDialogs;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedExperimenterGuiConfigProvider;
import be.iminds.ilabt.jfed.experimenter_gui.config.UserInfoProvider;
import be.iminds.ilabt.jfed.experimenter_gui.connectivity_tester.ConnectivityTesterDialog;
import be.iminds.ilabt.jfed.experimenter_gui.login.LoginConnectivityTest;
import be.iminds.ilabt.jfed.experimenter_gui.login.SystemProxyTestThread;
import be.iminds.ilabt.jfed.experimenter_gui.login.UserLoginDirector;
import be.iminds.ilabt.jfed.experimenter_gui.ui.status.TaskStatusIndicator;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.JFedExperimenterGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PpkHelper;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.lowlevel.user.KeyCertFileUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.KeyCertUrlUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.ManualUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidPasswordException;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.DefaultUtil;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.controlsfx.dialog.ExceptionDialog;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUserLoginController {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleUserLoginController.class);
    private static final String CUSTOM_INPUT = "<CUSTOM INPUT>";
    private static final Duration EXPIRATION_WARNING_DURATION = Duration.ofDays(30L);
    protected static final String CACHED_LOGIN = "<CACHED LOGIN>";
    @FXML
    private Label usernameLabel;
    @FXML
    private Label authorityLabel;
    @FXML
    private Label expireLabel;
    @FXML
    private TextField fileInput;
    @FXML
    private Button fileBrowseButton;
    @FXML
    private PasswordField passwordField;
    @FXML
    private Label messageLabel;
    @FXML
    private Button advancedButton;
    @FXML
    private Button resetButton;
    @FXML
    private HBox bottomBar;
    @FXML
    private Button loginButton;
    @FXML
    private TaskStatusIndicator statusIndicator;
    @FXML
    private VBox noInternetVBox;
    @FXML
    private CheckBox forceInternetCheckbox;
    @FXML
    private TilePane previousloginPane;
    @FXML
    private TilePane loginMethodsPane;
    @FXML
    private VBox localLoginPane;
    @FXML
    private Button cachedLoginButton;
    @FXML
    private Button localLoginButton;
    @FXML
    private Button changeAccountButton;
    private final UserLoginInfoFactory userLoginInfoFactory;
    private final Provider<ConnectivityTesterDialog> connectivityTesterDialogProvider;
    private final ProxyPreferencesManager proxyPreferencesManager;
    private final TestbedInfoSource testbedInfoSource;
    private final JFedHLPreferences jFedPreferences;
    private final ConnectivityDetector connectivityDetector;
    private final JFedExperimenterGuiConfigProvider configProvider;
    private final UserInfoProvider userInfoProvider;
    private final ObjectProperty<UserLoginInfo> userLoginInfo = new SimpleObjectProperty();
    private Result result;
    private String currentLocalLoaded = null;
    private boolean localLoginShown = false;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    @Inject
    public SimpleUserLoginController(UserLoginInfoFactory userLoginInfoFactory, Provider<ConnectivityTesterDialog> connectivityTesterDialogProvider, ProxyPreferencesManager proxyPreferencesManager, TestbedInfoSource testbedInfoSource, JFedHLPreferences jFedPreferences, ConnectivityDetector connectivityDetector, JFedExperimenterGuiConfigProvider configProvider, UserInfoProvider userInfoProvider) {
        this.userLoginInfoFactory = userLoginInfoFactory;
        this.connectivityTesterDialogProvider = connectivityTesterDialogProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
        this.testbedInfoSource = testbedInfoSource;
        this.jFedPreferences = jFedPreferences;
        this.connectivityDetector = connectivityDetector;
        this.configProvider = configProvider;
        this.userInfoProvider = userInfoProvider;
    }

    @FXML
    public void initialize() {
        this.userLoginInfo.addListener(observable -> this.modelToGui());
        this.userLoginInfo.addListener(observable -> {
            if (this.userLoginInfo.get() != null && ((UserLoginInfo)this.userLoginInfo.get()).getUserUrn() != null) {
                this.configProvider.prefetchConfig(this.userInfoProvider.createUserInfo(((UserLoginInfo)this.userLoginInfo.get()).getUserUrn(), new String[0]));
            }
        });
        this.noInternetVBox.managedProperty().bind((ObservableValue)this.noInternetVBox.visibleProperty());
        this.noInternetVBox.setVisible(this.connectivityDetector.isNoInternet());
        this.forceInternetCheckbox.setSelected(false);
        this.cachedLoginButton.managedProperty().bind((ObservableValue)this.cachedLoginButton.visibleProperty());
        this.statusIndicator.visibleProperty().bind((ObservableValue)this.statusIndicator.statusProperty().isNotEqualTo((Object)TaskStatusIndicator.Status.INACTIVE));
        this.statusIndicator.managedProperty().bind((ObservableValue)this.statusIndicator.visibleProperty());
        new SystemProxyTestThread().start();
        this.initLoginMethodsPane();
        this.modelToGui();
    }

    private void setMessage(String message, MessageType type) {
        LOG.debug("Login Dialog Message: " + String.valueOf((Object)type) + " " + message);
        this.messageLabel.setText(message);
        for (MessageType t : MessageType.values()) {
            this.messageLabel.getStyleClass().remove((Object)t.getStyleName());
        }
        this.messageLabel.getStyleClass().add((Object)type.getStyleName());
    }

    private void setExpireLabelAndNotification(Date certExpire) {
        if (certExpire == null) {
            this.expireLabel.setText("-");
            this.expireLabel.setGraphic(null);
            return;
        }
        String dateString = DATE_FORMAT.format(certExpire);
        this.expireLabel.setText(dateString);
        Duration durationToExpiration = Duration.between(Instant.now(), certExpire.toInstant());
        if (durationToExpiration.isNegative()) {
            Glyph errorGlyph = GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES_CIRCLE, (Color)Color.RED);
            Tooltip.install((Node)errorGlyph, (Tooltip)new Tooltip("Your certificate has expired! You can renew it at the website of your authority."));
            this.expireLabel.setGraphic((Node)errorGlyph);
        } else if (durationToExpiration.compareTo(EXPIRATION_WARNING_DURATION) < 0) {
            Glyph warningGlyph = GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.WARNING, (Color)Color.YELLOW);
            Tooltip.install((Node)warningGlyph, (Tooltip)new Tooltip(String.format("Your certificate will expire in %d days! You can renew it at the website of your authority.", ChronoUnit.DAYS.between(Instant.now(), certExpire.toInstant()))));
            this.expireLabel.setGraphic((Node)warningGlyph);
        } else {
            Glyph checkGlyph = GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CHECK, (Color)Color.GREEN);
            Tooltip.install((Node)checkGlyph, (Tooltip)new Tooltip("The expiry date of your certificate is sufficiently far in the future."));
            this.expireLabel.setGraphic((Node)checkGlyph);
        }
    }

    private void clear() {
        this.fileInput.setText("");
        this.usernameLabel.setText("-");
        this.authorityLabel.setText("-");
        this.expireLabel.setText("-");
        this.setMessage("Please select your user certificate", MessageType.INFO);
    }

    @FXML
    public void unlockAndLogin() {
        LOG.debug("unlockAndLogin()");
        String password = this.passwordField.getText();
        UserLoginInfo currentUserInfo = (UserLoginInfo)this.userLoginInfo.get();
        try {
            GeniUser loggedInUser = currentUserInfo.login(password.toCharArray());
            this.result = new LoggedInResult(currentUserInfo, loggedInUser);
            LOG.debug("Successfully logged in user {}", (Object)loggedInUser.getUserUrnString());
            this.setMessage("Password OK!\nLogging in...", MessageType.INFO);
            if (!this.passwordField.getText().isEmpty()) {
                PpkHelper.makePpkIfNeeded((GeniUser)loggedInUser, (String)password);
            }
            this.setMessage("Password OK!\nChecking connection with server...", MessageType.INFO);
            this.statusIndicator.setStatus(TaskStatusIndicator.Status.BUSY);
            this.startConnectivityTest(loggedInUser);
        }
        catch (InvalidPasswordException e) {
            LOG.error("Invalid password for user {}", (Object)currentUserInfo.getUserUrn(), (Object)e);
            this.setMessage("Password isn't correct.\nPlease enter your password again.", MessageType.ERROR);
        }
        catch (InvalidLoginException e) {
            LOG.error("Invalid login for user {}", (Object)currentUserInfo.getUserUrn(), (Object)e);
            ExceptionDialog dialog = new ExceptionDialog((Throwable)e);
            dialog.setTitle("Login failed");
            dialog.setHeaderText("Login failed");
            dialog.setContentText("jFed detected a problem with your login certificate:\n\n   " + e.getMessage());
            dialog.showAndWait();
        }
    }

    private void startConnectivityTest(final GeniUser loggedInUser) {
        GeniUserProvider geniUserProvider = new GeniUserProvider(){

            @Nonnull
            public GeniUser getLoggedInGeniUser() {
                return loggedInUser;
            }

            public boolean isUserLoggedIn() {
                return true;
            }
        };
        LoginConnectivityTest loginConnectivityTest = new LoginConnectivityTest(loggedInUser.getUserAuthorityServer(), this.proxyPreferencesManager, geniUserProvider, this.testbedInfoSource, this.jFedPreferences){

            @Override
            protected void busyMessage(String message) {
                Platform.runLater(() -> {
                    SimpleUserLoginController.this.setMessage(message, MessageType.INFO);
                    SimpleUserLoginController.this.statusIndicator.setStatus(TaskStatusIndicator.Status.BUSY);
                });
            }

            @Override
            protected void okMessage(String message) {
                Platform.runLater(() -> {
                    SimpleUserLoginController.this.setMessage(message, MessageType.INFO);
                    SimpleUserLoginController.this.statusIndicator.setStatus(TaskStatusIndicator.Status.SUCCESS);
                });
            }

            @Override
            protected void errorMessage(String message) {
                Platform.runLater(() -> {
                    SimpleUserLoginController.this.setMessage(message, MessageType.ERROR);
                    SimpleUserLoginController.this.statusIndicator.setStatus(TaskStatusIndicator.Status.FAILED);
                });
            }

            @Override
            protected void connectivityTestFinished(boolean success, boolean abortLogin) {
                Platform.runLater(() -> {
                    if (!abortLogin) {
                        if (success) {
                            SimpleUserLoginController.this.setMessage("Connectivity OK, logging in.", MessageType.INFO);
                        } else {
                            SimpleUserLoginController.this.setMessage("Connectivity test failed. But logging in anyway!", MessageType.WARNING);
                        }
                        SimpleUserLoginController.this.statusIndicator.setStatus(TaskStatusIndicator.Status.SUCCESS);
                        SimpleUserLoginController.this.closeLoginAndProceed();
                    } else {
                        if (success) {
                            SimpleUserLoginController.this.setMessage("Connectivity OK, but user aborted login.", MessageType.WARNING);
                        } else {
                            SimpleUserLoginController.this.setMessage("Connectivity test failed. Login Aborted.", MessageType.ERROR);
                        }
                        SimpleUserLoginController.this.statusIndicator.setStatus(TaskStatusIndicator.Status.FAILED);
                    }
                });
            }

            @Override
            protected Stage getDialogStage() {
                return (Stage)SimpleUserLoginController.this.usernameLabel.getScene().getWindow();
            }
        };
        loginConnectivityTest.start();
    }

    @FXML
    private void openCertificateFileChooser() {
        File file;
        File dir;
        FileChooser fc = new FileChooser();
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST) && (dir = new File(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST))).exists()) {
            fc.setInitialDirectory(dir);
        }
        if ((file = fc.showOpenDialog(null)) == null) {
            return;
        }
        this.loadPemFile(file);
    }

    private void loadPemFile(@Nonnull File file) {
        try {
            KeyCertFileUserLoginInfo newUserLoginInfo = this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(file);
            this.userLoginInfo.set((Object)newUserLoginInfo);
        }
        catch (IOException e) {
            LOG.error("Error while loading key-certificate-pair from file {}", (Object)file, (Object)e);
            JFDialogs.create().owner(this.fileBrowseButton.getScene().getWindow()).message("The provided login certificate could not be properly processed. Please check if the file format is supported, or download the certificate again from your authority.").masthead("Invalid login certificate").title("Invalid login certificate").showException((Throwable)e);
            this.clear();
            this.userLoginInfo.setValue(null);
        }
    }

    private void loadPemUrl(@Nonnull URL url) {
        try {
            KeyCertUrlUserLoginInfo newUserLoginInfo = this.userLoginInfoFactory.createKeyCertUrlUserLoginInfo(url);
            this.userLoginInfo.set((Object)newUserLoginInfo);
        }
        catch (IOException e) {
            LOG.error("Error while loading key-certificate-pair from URL", (Throwable)e);
            JFDialogs.create().owner(this.fileBrowseButton.getScene().getWindow()).message("An error occurred when using the provided URL to fetch the login-information").masthead("Invalid URL").title("Invalid URL").showException((Throwable)e);
            this.userLoginInfo.set(null);
        }
    }

    private void modelToGui() {
        this.passwordField.setText("");
        UserLoginInfo userLoginInfo = (UserLoginInfo)this.userLoginInfo.get();
        GeniUrn cachedLoginUrn = null;
        if (userLoginInfo != null) {
            if (userLoginInfo instanceof KeyCertFileUserLoginInfo) {
                KeyCertFileUserLoginInfo keyCertFileUserLoginInfo = (KeyCertFileUserLoginInfo)userLoginInfo;
                if (!UserLoginDirector.isCachedLogin(keyCertFileUserLoginInfo.getFile())) {
                    this.fileInput.setText(keyCertFileUserLoginInfo.getFile().getAbsolutePath());
                    this.fileInput.setDisable(false);
                } else {
                    this.fileInput.setText(CACHED_LOGIN);
                    this.fileInput.setDisable(true);
                    cachedLoginUrn = userLoginInfo.getUserUrn();
                }
            } else if (userLoginInfo instanceof KeyCertUrlUserLoginInfo) {
                KeyCertUrlUserLoginInfo keyCertUrlUserLoginInfo = (KeyCertUrlUserLoginInfo)userLoginInfo;
                this.fileInput.setText(keyCertUrlUserLoginInfo.getUrl().toExternalForm());
                this.fileInput.setDisable(false);
            } else if (userLoginInfo instanceof ManualUserLoginInfo) {
                this.fileInput.setText(CUSTOM_INPUT);
                this.fileInput.setDisable(true);
            }
            if (userLoginInfo.getUserUrn() != null) {
                this.usernameLabel.setText(userLoginInfo.getUserUrn().getEncodedResourceName());
            } else {
                this.usernameLabel.setText("<Not available>");
            }
            if (userLoginInfo.getUserAuthorityServer() != null) {
                this.authorityLabel.setText(userLoginInfo.getUserAuthorityServer().getName());
            } else {
                this.authorityLabel.setText("<Not available>");
            }
            this.setExpireLabelAndNotification(userLoginInfo.getExpirationDate());
            this.passwordField.setDisable(userLoginInfo.isUnlocked());
            if (!userLoginInfo.isUnlocked()) {
                this.setMessage("Enter the password associated with the certificate", MessageType.INFO);
                Platform.runLater(() -> ((PasswordField)this.passwordField).requestFocus());
            } else {
                this.setMessage("No password required: You can login", MessageType.INFO);
                Platform.runLater(() -> ((Button)this.loginButton).requestFocus());
            }
        } else {
            this.fileInput.setText("");
            this.usernameLabel.setText("");
            this.authorityLabel.setText("");
            this.expireLabel.setText("");
        }
        if (cachedLoginUrn != null) {
            this.cachedLoginButton.setText(String.format("Continue as '%s'", cachedLoginUrn.getResourceName()));
            this.cachedLoginButton.setTooltip(new Tooltip(String.format("Continue as '%s'", cachedLoginUrn)));
            this.showPreviousLoginPane();
        } else if (this.localLoginShown) {
            this.showLocalLoginMethod();
        } else {
            this.showLoginMethodsPane();
        }
    }

    @FXML
    public void showAdvancedLogin() {
        this.result = new ShowAdvancedResult();
        this.close();
    }

    @FXML
    private void resetJFedAction(ActionEvent actionEvent) {
        JFedCommonDialogs.requestEraseJFedConfiguration((Window)this.resetButton.getScene().getWindow());
    }

    private void closeLoginAndProceed() {
        if (this.noInternetVBox.isVisible()) {
            assert (this.connectivityDetector.isNoInternet());
            if (this.forceInternetCheckbox.isSelected()) {
                LOG.debug("User has chosen to force jFed to keep checking internet connectivity");
                this.connectivityDetector.forceNoInternet(false);
            }
        }
        this.passwordField.setText("");
        this.close();
    }

    private void showConnectivityFailed(String shortMessage, String fullMessage) {
        this.statusIndicator.setStatus(TaskStatusIndicator.Status.FAILED);
        this.setMessage(shortMessage, MessageType.ERROR);
        JFDialogs.create().owner(this.loginButton.getScene().getWindow()).message(fullMessage).masthead("Could not contact the server").showError();
    }

    @FXML
    private void showConnectivityTesterAction() {
        ((ConnectivityTesterDialog)this.connectivityTesterDialogProvider.get()).showDialog();
    }

    @FXML
    private void onFileInputAction() {
        if (Objects.equals(this.fileInput.getText(), CUSTOM_INPUT)) {
            return;
        }
        if (Objects.equals(this.currentLocalLoaded, this.fileInput.getText())) {
            return;
        }
        File file = new File(this.fileInput.getText());
        if (file.exists()) {
            this.loadPemFile(file);
            this.currentLocalLoaded = this.fileInput.getText();
        } else {
            try {
                URL url = new URL(this.fileInput.getText());
                this.loadPemUrl(url);
                this.currentLocalLoaded = this.fileInput.getText();
            }
            catch (MalformedURLException e) {
                LOG.debug("Given input is not a file, nor an URL");
            }
        }
    }

    public Result getResult() {
        return this.result;
    }

    public UserLoginInfo getUserLoginInfo() {
        return (UserLoginInfo)this.userLoginInfo.get();
    }

    public void setUserLoginInfo(UserLoginInfo userLoginInfo) {
        this.userLoginInfo.set((Object)userLoginInfo);
    }

    public void showLogin(String url, LoginSite.UrlType urlType) {
        this.result = new URLResult(url, urlType);
        this.close();
    }

    private void close() {
        ((Stage)this.loginButton.getScene().getWindow()).close();
    }

    public void initLoginMethodsPane() {
        JFedExperimenterGuiConfig config = this.configProvider.get();
        ArrayList<LoginSite> loginSites = DefaultUtil.nullToEmpty((List)config.getLoginSites());
        if (loginSites.isEmpty() && !Objects.equals(config.getFlags().get("no_empty_loginsites_fallback"), Boolean.TRUE)) {
            loginSites = new ArrayList<LoginSite>();
            loginSites.add(new LoginSite(Integer.valueOf(101), "Login via Fed4FIRE", "https://portal.fed4fire.eu/generic_login", LoginSite.UrlType.GET_PEM, "fed4fire"));
            loginSites.add(new LoginSite(Integer.valueOf(101), "Login via imec", "https://portal.fed4fire.eu/generic_login", LoginSite.UrlType.GET_PEM, "imec"));
            loginSites.add(new LoginSite(Integer.valueOf(104), "Login via authority.ilabt.iminds.be", "https://authority.ilabt.iminds.be/getsslcert_jfed.php3", LoginSite.UrlType.OLD_AUTH, "fed4fire_legacy"));
            loginSites.add(new LoginSite(Integer.valueOf(106), "Login via GENI", "https://portal.geni.net/secure/kmcert.php", LoginSite.UrlType.GENI_PORTAL, "geni"));
            loginSites.add(new LoginSite(Integer.valueOf(107), "Login via Slice-SC", "https://portal.fed4fire.eu/generic_login", LoginSite.UrlType.GET_PEM, "slices-sc"));
        }
        Node lastButton = (Node)this.loginMethodsPane.getChildren().remove(this.loginMethodsPane.getChildren().size() - 1);
        for (final LoginSite loginSite : loginSites) {
            Button loginSiteButton = new Button();
            loginSiteButton.setText(loginSite.getButtonText());
            loginSiteButton.setId("loginSite" + loginSite.getId());
            loginSiteButton.getStyleClass().add((Object)"login-method-button");
            loginSiteButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    SimpleUserLoginController.this.showLogin(loginSite.getUrl(), loginSite.getUrlType());
                }
            });
            if (loginSite.getImageId() != null) {
                ImageView buttonImage = new ImageView();
                buttonImage.setFitHeight(50.0);
                buttonImage.setFitWidth(50.0);
                buttonImage.setPreserveRatio(true);
                String imageName = loginSite.getImageId() + ".png";
                URL imageUrl = SimpleUserLoginController.class.getResource(imageName);
                if (imageUrl != null) {
                    buttonImage.setImage(new Image(imageUrl.toExternalForm()));
                    loginSiteButton.setGraphic((Node)buttonImage);
                } else {
                    LOG.error("Login button image not found: \"" + imageName + "\" for button with ID " + loginSite.getImageId() + " and text \"" + loginSite.getButtonText() + "\"");
                }
            }
            this.loginMethodsPane.getChildren().add((Object)loginSiteButton);
        }
        this.loginMethodsPane.getChildren().add((Object)lastButton);
    }

    public void showPreviousLoginPane() {
        this.previousloginPane.setVisible(true);
        this.loginMethodsPane.setVisible(false);
        this.localLoginPane.setVisible(false);
    }

    public void useCachedLogin() {
        UserLoginInfo userLoginInfo = (UserLoginInfo)this.userLoginInfo.get();
        if (userLoginInfo != null && userLoginInfo.isUnlocked()) {
            this.unlockAndLogin();
        } else {
            this.showLocalLoginMethod();
        }
    }

    public void showLocalLoginMethod() {
        this.previousloginPane.setVisible(false);
        this.loginMethodsPane.setVisible(false);
        this.localLoginPane.setVisible(true);
        this.localLoginShown = true;
    }

    public void showLoginMethodsPane() {
        this.previousloginPane.setVisible(false);
        this.loginMethodsPane.setVisible(true);
        this.localLoginPane.setVisible(false);
        this.localLoginShown = false;
    }

    public static boolean isSupportedLoginMethod(@Nonnull UserLoginInfo userLoginInfo) {
        return userLoginInfo instanceof KeyCertFileUserLoginInfo || userLoginInfo instanceof KeyCertUrlUserLoginInfo || userLoginInfo instanceof ManualUserLoginInfo;
    }

    private static enum MessageType {
        INFO("label-info"),
        WARNING("label-warning"),
        ERROR("label-error");

        private final String styleName;

        private MessageType(String styleName) {
            this.styleName = styleName;
        }

        private String getStyleName() {
            return this.styleName;
        }
    }

    public static class LoggedInResult
    implements Result {
        private final UserLoginInfo userLoginInfo;
        private final GeniUser loggedInUser;

        public LoggedInResult(UserLoginInfo userLoginInfo, GeniUser loggedInUser) {
            this.userLoginInfo = userLoginInfo;
            this.loggedInUser = loggedInUser;
        }

        public UserLoginInfo getUserLoginInfo() {
            return this.userLoginInfo;
        }

        public GeniUser getLoggedInUser() {
            return this.loggedInUser;
        }
    }

    public static interface Result {
    }

    public static class ShowAdvancedResult
    implements Result {
    }

    public static class URLResult
    implements Result {
        @Nonnull
        private final String url;
        @Nullable
        private final LoginSite.UrlType loginSiteUrlType;

        public URLResult(@Nonnull String url, @Nullable LoginSite.UrlType loginSiteUrlType) {
            this.url = url;
            this.loginSiteUrlType = loginSiteUrlType;
        }

        @Nonnull
        public String getUrl() {
            return this.url;
        }

        @Nullable
        public LoginSite.UrlType getLoginSiteUrlType() {
            return this.loginSiteUrlType;
        }
    }
}

