/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.login;

import be.iminds.ilabt.jfed.experimenter_gui.debug.LogViewer;
import be.iminds.ilabt.jfed.experimenter_gui.login.SimpleUserLoginController;
import be.iminds.ilabt.jfed.experimenter_gui.login.UserLoginDirector;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.Stage;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUserLoginDialog {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleUserLoginDialog.class);
    private final Stage stage;
    private final SimpleUserLoginController controller;
    private final GuiceFXMLUtil guiceFXMLUtil;
    private final Provider<LogViewer> logViewerProvider;

    @Inject
    public SimpleUserLoginDialog(GuiceFXMLUtil guiceFXMLUtil, Provider<LogViewer> logViewerProvider) {
        this.guiceFXMLUtil = guiceFXMLUtil;
        this.logViewerProvider = logViewerProvider;
        GuiceFXMLUtil.Result result = guiceFXMLUtil.createFromFXML(SimpleUserLoginController.class);
        this.controller = (SimpleUserLoginController)result.getController();
        this.stage = new Stage();
        this.stage.setTitle("jFed login");
        this.stage.setResizable(true);
        StageUtils.setJFedStageIcons((Stage)this.stage);
        Scene scene = new Scene(result.getRoot());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F10, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), () -> ((LogViewer)logViewerProvider.get()).show());
        this.stage.setScene(scene);
    }

    @Nullable
    public SimpleUserLoginController.Result showAndWait(@Nullable UserLoginInfo initialUserLoginInfo) {
        this.controller.setUserLoginInfo(initialUserLoginInfo);
        this.stage.showAndWait();
        return this.controller.getResult();
    }

    @Nullable
    public UserLoginDirector.UserLoginResult showLocalLoginAndWait(UserLoginInfo providedUserLoginInfo) {
        this.controller.setUserLoginInfo(providedUserLoginInfo);
        if (providedUserLoginInfo != null && !SimpleUserLoginController.isSupportedLoginMethod(providedUserLoginInfo)) {
            LOG.warn("UserLoginDialog does not support models of type {}", (Object)providedUserLoginInfo.getUserLoginTypeName());
            this.controller.setUserLoginInfo(null);
        }
        if (this.controller.getUserLoginInfo() != null) {
            this.controller.showLocalLoginMethod();
        }
        this.stage.showAndWait();
        if (this.controller.getResult() instanceof SimpleUserLoginController.LoggedInResult) {
            SimpleUserLoginController.LoggedInResult result = (SimpleUserLoginController.LoggedInResult)this.controller.getResult();
            return new UserLoginDirector.UserLoginResult(result.getUserLoginInfo(), result.getLoggedInUser());
        }
        return null;
    }
}

