/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.login;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.SafeConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.URLConnectionTest;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemProxyTestThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(SystemProxyTestThread.class);
    private static final URL HTTP_TEST_URL;
    private static final URL HTTPS_TEST_URL;

    public SystemProxyTestThread() {
        this.setDaemon(true);
        this.setName("SystemProxyTest");
    }

    @Override
    public void run() {
        Properties systemProperties = System.getProperties();
        if (systemProperties.getProperty("http.proxyHost") == null && systemProperties.getProperty("http.proxyPort") == null && systemProperties.getProperty("https.proxyHost") == null && systemProperties.getProperty("https.proxyPort") == null) {
            LOG.debug("No system proxy settings to test.");
            return;
        }
        LOG.debug("Found the following system proxy settings: HTTP: {}:{}, HTTPS: {}:{}", new Object[]{systemProperties.getProperty("http.proxyHost"), systemProperties.getProperty("http.proxyPort"), systemProperties.getProperty("https.proxyHost"), systemProperties.getProperty("https.proxyPort")});
        SafeConnectivityTest safeHttpTest = new SafeConnectivityTest((ConnectivityTest)new URLConnectionTest(HTTP_TEST_URL, "Http URL Test", ""), 10000L);
        Optional httpTestResult = safeHttpTest.call();
        LOG.info("HttpURLTest result: {}", (Object)httpTestResult);
        if (!httpTestResult.isPresent() || ((ConnectivityTest.ConnectivityTestResult)httpTestResult.get()).getStatus() != ConnectivityTest.Status.SUCCEEDED) {
            Platform.runLater(() -> {
                Alert httpProxyAlert = new Alert(Alert.AlertType.ERROR);
                httpProxyAlert.setContentText("The HTTP proxy settings on your system are invalid. Please correct them to prevent connectivity issues.");
                httpProxyAlert.setTitle("Invalid system proxy settings");
                httpProxyAlert.setHeaderText("Invalid system proxy settings");
                httpProxyAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                httpProxyAlert.setResizable(true);
                httpProxyAlert.show();
            });
        }
        SafeConnectivityTest safeHttpsTest = new SafeConnectivityTest((ConnectivityTest)new URLConnectionTest(HTTPS_TEST_URL, "Https URL Test", ""), 10000L);
        Optional httpsTestResult = safeHttpsTest.call();
        LOG.info("HttpsURLTest result: {}", (Object)httpsTestResult);
        if (!httpsTestResult.isPresent() || ((ConnectivityTest.ConnectivityTestResult)httpsTestResult.get()).getStatus() != ConnectivityTest.Status.SUCCEEDED) {
            Platform.runLater(() -> {
                Alert httpsProxyAlert = new Alert(Alert.AlertType.ERROR);
                httpsProxyAlert.setContentText("The HTTPS proxy settings on your system are invalid. Please correct them to prevent connectivity issues.");
                httpsProxyAlert.setTitle("Invalid system proxy settings");
                httpsProxyAlert.setHeaderText("Invalid system proxy settings");
                httpsProxyAlert.setResizable(true);
                httpsProxyAlert.show();
            });
        }
    }

    static {
        URL httpUrl = null;
        URL httpsUrl = null;
        try {
            httpUrl = new URL("http://jfed.iminds.be");
            httpsUrl = new URL("https://flsmonitor.fed4fire.eu");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        HTTP_TEST_URL = httpUrl;
        HTTPS_TEST_URL = httpsUrl;
    }
}

