/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.login;

import be.iminds.ilabt.jfed.experimenter_gui.util.PersistentCookieStore;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.controlsfx.dialog.ExceptionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLLoginController {
    private static final Logger LOG = LoggerFactory.getLogger(URLLoginController.class);
    public static final String GENI_DOWNLOAD_URL = "https://portal.geni.net/secure/kmcert.php";
    public static final String IMEC_PORTAL_DOWNLOAD_URL = "https://portal.fed4fire.eu/generic_login";
    public static final String FED4FIRE_DOWNLOAD_URL = "https://authority.ilabt.iminds.be/getsslcert_jfed.php3";
    protected static final URI GENI_URI = URI.create("https://portal.geni.net/");
    @FXML
    private WebView loginWebView;
    @FXML
    private HBox loadingHBox;
    @FXML
    private ProgressBar loadingProgressBar;
    @FXML
    private Label loadingLabel;
    private final JFedHLPreferences preferences;
    private CookieManager manager;
    private Stage stage = null;
    private String result = null;
    private String initialUrl;
    private LoginSite.UrlType loginSiteUrlType;

    @Inject
    URLLoginController(JFedHLPreferences preferences) {
        this.preferences = preferences;
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                LOG.debug("Skipping verification of {} in session {} with ciphers {} (valid: {})", new Object[]{hostname, session.getPeerHost(), session.getCipherSuite(), session.isValid()});
                return session.isValid();
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    private LoginSite.UrlType getFallbackLoginSiteUrlType(@Nonnull String initialUrl) {
        if (initialUrl.startsWith("https://portal.geni.net/")) {
            return LoginSite.UrlType.GENI_PORTAL;
        }
        if (initialUrl.startsWith("https://authority.ilabt.iminds.be")) {
            return LoginSite.UrlType.OLD_AUTH;
        }
        return LoginSite.UrlType.GET_PEM;
    }

    public void loadUrl(@Nonnull String initialUrl) {
        this.loadUrl(initialUrl, null);
    }

    public void loadUrl(@Nonnull String initialUrl, @Nullable LoginSite.UrlType loginSiteUrlType) {
        this.initialUrl = initialUrl;
        this.loginSiteUrlType = loginSiteUrlType == null ? this.getFallbackLoginSiteUrlType(initialUrl) : loginSiteUrlType;
        String host = null;
        try {
            host = new URL(initialUrl).getHost();
            LOG.debug("Ignoring cookies for {}", (Object)host);
        }
        catch (MalformedURLException e) {
            LOG.error("Could not determine host of initialUrl", (Throwable)e);
        }
        this.manager = new CookieManager(new PersistentCookieStore(JFedUtils.createPreferencesFile((String)"login.cookies"), host != null ? Collections.singletonList(host) : null), null);
        CookieHandler.setDefault(this.manager);
        this.loginWebView.getEngine().load(initialUrl);
    }

    @FXML
    public void initialize() {
        this.loadingProgressBar.progressProperty().bind((ObservableValue)this.loginWebView.getEngine().getLoadWorker().progressProperty());
        this.loadingHBox.visibleProperty().bind((ObservableValue)this.loginWebView.getEngine().getLoadWorker().runningProperty());
        if (this.preferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_GENI_LOGIN_COOKIE)) {
            try {
                String cookie = this.preferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_GENI_LOGIN_COOKIE);
                CookieHandler.getDefault().put(GENI_URI, Collections.singletonMap("Set-Cookie", Collections.singletonList(cookie)));
            }
            catch (IOException e) {
                LOG.error("Error while setting Geni cookie", (Throwable)e);
            }
        }
        this.loginWebView.getEngine().setConfirmHandler(param -> new Alert(Alert.AlertType.CONFIRMATION, param, new ButtonType[0]).showAndWait().filter(buttonType -> buttonType == ButtonType.YES).isPresent());
        this.loginWebView.getEngine().setOnAlert(text -> new Alert(Alert.AlertType.WARNING, text.toString(), new ButtonType[0]).show());
        this.loginWebView.getEngine().setOnError(error -> {
            if (error.getMessage().contains("User data directory")) {
                return;
            }
            LOG.info("Received ERROR from webview: {}", (Object)error.getMessage(), (Object)error.getException());
            ExceptionDialog proxyAlert = new ExceptionDialog(error.getException());
            proxyAlert.setHeaderText("Error while retrieving login web page");
            proxyAlert.setContentText("jFed could not load the login web page. Please check whether your browser proxy settings are valid, and try again.");
            proxyAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            proxyAlert.showAndWait();
        });
        this.loginWebView.getEngine().getLoadWorker().exceptionProperty().addListener(observable1 -> {
            Throwable exception = this.loginWebView.getEngine().getLoadWorker().getException();
            LOG.warn("Login webview has error: {}", (Object)exception.getMessage(), (Object)exception);
            ExceptionDialog proxyAlert = new ExceptionDialog(exception);
            proxyAlert.setHeaderText("Error while retrieving login web page");
            proxyAlert.setContentText("jFed could not load the login web page.\n\nProbably you have a proxy server enabled in any of your browsers, which blocks some of the ports needed. Can you try to turn off the proxy server and try again?");
            proxyAlert.showAndWait();
        });
        this.loadingLabel.textProperty().bind((ObservableValue)this.loginWebView.getEngine().getLoadWorker().messageProperty());
        this.loginWebView.getEngine().documentProperty().addListener((observable, oldValue, newValue) -> {
            String text;
            if (newValue != null && (text = (String)this.loginWebView.getEngine().executeScript("document.documentElement.outerText")) != null && text.startsWith("-----BEGIN")) {
                this.processCertificate(text);
            }
        });
        this.loginWebView.getEngine().locationProperty().addListener((observable, oldValue, newValue) -> {
            if (Objects.equals(newValue, this.initialUrl) && this.loginSiteUrlType == LoginSite.UrlType.GENI_PORTAL) {
                String geniCert = this.downloadCertFromURL(this.initialUrl, "POST");
                if (geniCert != null) {
                    this.processCertificate(geniCert);
                } else {
                    LOG.warn("Downloading GENI certificate failed");
                }
            }
            if (Objects.equals(newValue, this.initialUrl) && this.loginSiteUrlType == LoginSite.UrlType.GET_PEM) {
                String imecCert = this.downloadCertFromURL(this.initialUrl, "GET");
                if (imecCert != null) {
                    this.processCertificate(imecCert);
                } else {
                    LOG.warn("Downloading PEM with GET failed");
                }
            }
        });
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    @Nullable
    private String downloadCertFromURL(String url, String http_method_name) {
        try {
            CloseableHttpResponse response;
            DefaultHttpClient client = new DefaultHttpClient();
            client.setCookieStore((CookieStore)this.createApacheCookieStore());
            HttpGet downloadReq = null;
            if (http_method_name.equalsIgnoreCase("post")) {
                HttpPost downloadPost = new HttpPost(url);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                nvps.add(new BasicNameValuePair("download", "y"));
                downloadPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
                downloadReq = downloadPost;
            }
            if (http_method_name.equalsIgnoreCase("get")) {
                downloadReq = new HttpGet(url);
            }
            if ((response = client.execute(downloadReq)).getStatusLine().getStatusCode() != 200) {
                return null;
            }
            if (response.getEntity().getContentLength() == 0L) {
                return null;
            }
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            LOG.error("Error while downloading GENI certificate", (Throwable)e);
            return null;
        }
    }

    @Nonnull
    private BasicCookieStore createApacheCookieStore() {
        BasicCookieStore cookieStore = new BasicCookieStore();
        for (HttpCookie httpCookie : this.manager.getCookieStore().getCookies()) {
            BasicClientCookie cookie = new BasicClientCookie(httpCookie.getName(), httpCookie.getValue());
            cookie.setDomain(httpCookie.getDomain());
            cookie.setPath(httpCookie.getPath());
            cookie.setComment(httpCookie.getComment());
            cookie.setSecure(httpCookie.getSecure());
            cookie.setVersion(httpCookie.getVersion());
            cookieStore.addCookie((Cookie)cookie);
        }
        return cookieStore;
    }

    private void processCertificate(String certificate) {
        this.result = certificate;
        this.manager.getCookieStore().get(GENI_URI).stream().filter(cookie -> Objects.equals(cookie.getName(), "_saml_idp")).findFirst().ifPresent(cookie -> this.preferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_GENI_LOGIN_COOKIE, cookie.toString()));
        this.stage.close();
    }

    public String getResult() {
        return this.result;
    }
}

