/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.login;

import be.iminds.ilabt.jfed.experimenter_gui.debug.LogViewer;
import be.iminds.ilabt.jfed.experimenter_gui.login.URLLoginController;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.util.StageUtils;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.Stage;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;

public class URLLoginDialog {
    private final Stage stage;
    private final URLLoginController urlLoginController;
    private final GuiceFXMLUtil guiceFXMLUtil;
    private final Provider<LogViewer> logviewerProvider;

    @Inject
    public URLLoginDialog(GuiceFXMLUtil guiceFXMLUtil, Provider<LogViewer> logviewerProvider) {
        this.guiceFXMLUtil = guiceFXMLUtil;
        this.logviewerProvider = logviewerProvider;
        GuiceFXMLUtil.Result result = guiceFXMLUtil.createFromFXML(URLLoginController.class);
        this.urlLoginController = (URLLoginController)result.getController();
        this.stage = new Stage();
        this.stage.setTitle("jFed login: fetch certificate");
        StageUtils.setJFedStageIcons((Stage)this.stage);
        this.urlLoginController.setStage(this.stage);
        Scene scene = new Scene(result.getRoot());
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F10, new KeyCombination.Modifier[]{KeyCodeCombination.CONTROL_DOWN}), () -> ((LogViewer)this.logviewerProvider.get()).show());
        this.stage.setScene(scene);
    }

    public String showDialog(String initialUrl, @Nullable LoginSite.UrlType loginSiteUrlType) {
        this.urlLoginController.loadUrl(initialUrl, loginSiteUrlType);
        this.stage.showAndWait();
        return this.urlLoginController.getResult();
    }
}

