/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.login;

import be.iminds.ilabt.jfed.experimenter_gui.login.SimpleUserLoginController;
import be.iminds.ilabt.jfed.experimenter_gui.login.SimpleUserLoginDialog;
import be.iminds.ilabt.jfed.experimenter_gui.login.URLLoginDialog;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ConfirmingPasswordInputDialog;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LoginSite;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.KeyCertFileUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfoManager;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.ui.javafx.userlogin.AdvancedUserLoginDialog;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.PEMUtil;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserLoginDirector {
    public static final String LOGIN_CERTS_DIR = "login-certs";
    private static final Logger LOG = LoggerFactory.getLogger(UserLoginDirector.class);
    private final String autoLoginUrl;
    private UserLoginInfo autoUserLoginInfo;
    private UserLoginInfo initialUserLoginInfo;
    private final UserLoginInfoFactory userLoginInfoFactory;
    private final UserLoginInfoManager userLoginInfoManager;
    private final Provider<URLLoginDialog> urlLoginDialogProvider;
    private final Provider<SimpleUserLoginDialog> simpleUserLoginDialogProvider;
    private final Provider<AdvancedUserLoginDialog> advancedUserLoginDialogProvider;

    public UserLoginDirector(@Nullable String autoLoginUrl, @Nullable UserLoginInfo autoUserLoginInfo, UserLoginInfoFactory userLoginInfoFactory, UserLoginInfoManager userLoginInfoManager, Provider<URLLoginDialog> urlLoginDialogProvider, Provider<SimpleUserLoginDialog> simpleUserLoginDialogProvider, Provider<AdvancedUserLoginDialog> advancedUserLoginDialogProvider) {
        this.autoLoginUrl = autoLoginUrl;
        this.userLoginInfoFactory = userLoginInfoFactory;
        this.userLoginInfoManager = userLoginInfoManager;
        this.urlLoginDialogProvider = urlLoginDialogProvider;
        this.simpleUserLoginDialogProvider = simpleUserLoginDialogProvider;
        this.advancedUserLoginDialogProvider = advancedUserLoginDialogProvider;
        this.autoUserLoginInfo = autoUserLoginInfo;
        this.initialUserLoginInfo = autoUserLoginInfo;
    }

    public static File createFileForLoginCertificate(String certificate) {
        String certmd5 = DigestUtils.md5Hex((String)certificate);
        File certDir = UserLoginDirector.getLoginCertificateCacheDir();
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        return UserLoginDirector.getLoginCertificateFile(certmd5);
    }

    public static boolean saveCertificate(File certFile, String certificate) {
        try (BufferedWriter writer = Files.newWriter((File)certFile, (Charset)StandardCharsets.UTF_8);){
            writer.write(certificate);
        }
        catch (IOException e) {
            LOG.error("Could not write certificate to file {}", (Object)certFile, (Object)e);
            return false;
        }
        try {
            IOUtils.assureUserOnlyPerms((File)certFile, (boolean)true, (boolean)false, (boolean)false);
        }
        catch (IOException e) {
            LOG.error("Could not change certificate file permissions {} (will ignore)", (Object)certFile, (Object)e);
            return true;
        }
        return true;
    }

    @Nonnull
    private static File getLoginCertificateCacheDir() {
        return new File(JFedUtils.getUserDataDirectoryFile(), LOGIN_CERTS_DIR);
    }

    public static File getLoginCertificateFile(String certMd5) {
        return new File(UserLoginDirector.getLoginCertificateCacheDir(), certMd5 + ".pem");
    }

    public static boolean isCachedLogin(File file) {
        return file != null && Objects.equals(file.getParentFile(), UserLoginDirector.getLoginCertificateCacheDir());
    }

    @Nullable
    public UserLoginResult showAndWait() {
        UserLoginResult result = this.doLogin();
        if (result != null && result.getLoggedInUser() != null) {
            this.userLoginInfoManager.save(result.getUserLoginInfo());
        }
        return result;
    }

    @Nullable
    private UserLoginResult doLogin() {
        UserLoginResult result;
        if (this.autoUserLoginInfo != null) {
            if (this.autoUserLoginInfo.isUnlocked()) {
                try {
                    return new UserLoginResult(this.autoUserLoginInfo, this.autoUserLoginInfo.login(null));
                }
                catch (InvalidLoginException e) {
                    LOG.error("Unable to login with provided UserLoginInfo, while it was unlocked!", (Throwable)e);
                }
            } else {
                this.initialUserLoginInfo = this.autoUserLoginInfo;
            }
        }
        if (this.initialUserLoginInfo == null) {
            try {
                this.initialUserLoginInfo = this.userLoginInfoManager.load();
            }
            catch (InvalidLoginException e) {
                LOG.error("Could not load the old UserLoginInfo from UserLoginInfoManager", (Throwable)e);
                this.initialUserLoginInfo = this.userLoginInfoManager.defaults();
            }
        }
        if (this.autoLoginUrl != null && (result = this.showAndProcessURLLogin(this.autoLoginUrl, null)) != null && result.getLoggedInUser() != null) {
            return result;
        }
        result = this.showSimpleUserLoginDialog();
        return result;
    }

    private UserLoginResult showAndProcessURLLogin(String loginUrl, @Nullable LoginSite.UrlType loginSiteUrlType) {
        LOG.info("Got login url '{}'. Showing dialog.", (Object)loginUrl);
        UserLoginInfo userLoginInfo = this.showURLLogin(loginUrl, loginSiteUrlType);
        if (userLoginInfo != null && userLoginInfo.isValid()) {
            if (userLoginInfo.isUnlocked()) {
                LOG.info("Got an unlocked certificate for {} from URLLogin", (Object)userLoginInfo.getUserUrn());
                GeniUser loggedInGeniUser = null;
                try {
                    loggedInGeniUser = userLoginInfo.login(null);
                    UserLoginResult result = new UserLoginResult(userLoginInfo, loggedInGeniUser);
                    result = this.askUnprotectedCertificateSave(result);
                    return result;
                }
                catch (InvalidLoginException e) {
                    LOG.error("Unable to login with downloaded UserLoginInfo, while it was unlocked!", (Throwable)e);
                    throw new RuntimeException("Unable to login with downloaded UserLoginInfo, while it was unlocked!", e);
                }
            }
            LOG.info("Got a locked certificate for {} from URLLogin", (Object)userLoginInfo.getUserUrn());
            File certFile = UserLoginDirector.createFileForLoginCertificate(userLoginInfo.getCertificateContent());
            UserLoginDirector.saveCertificate(certFile, userLoginInfo.getCertificateContent());
            try {
                userLoginInfo = this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(certFile);
            }
            catch (IOException ex) {
                LOG.error("Error while opening newly saved userLoginInfo", (Throwable)ex);
            }
            return this.showLocalLoginDialog(userLoginInfo);
        }
        LOG.info("Did not get a login certicate from URLLogin");
        return null;
    }

    private UserLoginInfo showURLLogin(String loginUrl, @Nullable LoginSite.UrlType loginSiteUrlType) {
        URLLoginDialog urlLoginDialog = (URLLoginDialog)this.urlLoginDialogProvider.get();
        String certificateString = urlLoginDialog.showDialog(loginUrl, loginSiteUrlType);
        if (certificateString != null) {
            LOG.info("User successfully fetched certificate via {}", (Object)loginUrl);
            return this.userLoginInfoFactory.createManualUserLoginInfo(certificateString);
        }
        LOG.warn("User did not successfully fetch certificate via {}", (Object)loginUrl);
        return null;
    }

    private UserLoginResult askUnprotectedCertificateSave(UserLoginResult userLoginResult) {
        Alert choiceDialog = new Alert(Alert.AlertType.CONFIRMATION);
        choiceDialog.setTitle("The downloaded certificate is unprotected");
        choiceDialog.setHeaderText("The downloaded certificate is unprotected");
        choiceDialog.setContentText("If you want to use this certificate in future sessions, we recommend that you save it encrypted locally.");
        choiceDialog.setResizable(true);
        ButtonType dontSaveButtonType = new ButtonType("Don't Save");
        ButtonType saveEncryptedButtonType = new ButtonType("Save Encrypted");
        ButtonType saveUnencryptedButtonType = new ButtonType("Save Unencrypted");
        choiceDialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{dontSaveButtonType, saveEncryptedButtonType, saveUnencryptedButtonType});
        Optional answer = choiceDialog.showAndWait();
        if (answer.isPresent() && answer.get() != dontSaveButtonType) {
            char[] password = null;
            if (answer.get() == saveEncryptedButtonType) {
                ConfirmingPasswordInputDialog cpid = new ConfirmingPasswordInputDialog();
                cpid.setHeaderText("Securing login certificate");
                cpid.setContentText("Please provide a password to encrypt your login certificate.");
                Optional passwordAnswer = cpid.showAndWait();
                if (passwordAnswer.isPresent()) {
                    password = ((String)passwordAnswer.get()).toCharArray();
                } else {
                    return userLoginResult;
                }
            }
            char[] privateKey = new char[]{};
            try {
                PEMUtil.PEM pem = PEMUtil.fromPrivateKey((PrivateKey)userLoginResult.getLoggedInUser().getPrivateKey());
                if (password != null) {
                    pem = pem.encrypt(password);
                }
                privateKey = pem.toString().toCharArray();
            }
            catch (PEMUtil.PEMDecodingException e) {
                throw new RuntimeException(e);
            }
            StringBuilder newCertificate = new StringBuilder();
            newCertificate.append(privateKey);
            String certificateChain = KeyUtil.x509certificateChainToPem((Collection)userLoginResult.getLoggedInUser().getClientCertificateChain());
            newCertificate.append(certificateChain);
            File certFile = UserLoginDirector.createFileForLoginCertificate(userLoginResult.getUserLoginInfo().getCertificateContent());
            UserLoginDirector.saveCertificate(certFile, newCertificate.toString());
            try {
                KeyCertFileUserLoginInfo protectedUserLoginInfo = this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(certFile);
                GeniUser loggedInUser = protectedUserLoginInfo.login(password);
                return new UserLoginResult((UserLoginInfo)protectedUserLoginInfo, loggedInUser);
            }
            catch (IOException e) {
                LOG.error("Error while saving UserLoginInfo to file {}", (Object)certFile.getAbsolutePath());
                return userLoginResult;
            }
            catch (InvalidLoginException e) {
                LOG.error("Error while decrypting UserLoginInfo {}. This should NOT happen!", (Object)certFile.getAbsolutePath());
                return userLoginResult;
            }
        }
        return userLoginResult;
    }

    private UserLoginResult showSimpleUserLoginDialog() {
        SimpleUserLoginDialog simpleUserLoginDialog = (SimpleUserLoginDialog)this.simpleUserLoginDialogProvider.get();
        SimpleUserLoginController.Result result = simpleUserLoginDialog.showAndWait(this.initialUserLoginInfo);
        if (result != null) {
            if (result instanceof SimpleUserLoginController.URLResult) {
                SimpleUserLoginController.URLResult urlResult = (SimpleUserLoginController.URLResult)result;
                return this.showAndProcessURLLogin(urlResult.getUrl(), urlResult.getLoginSiteUrlType());
            }
            if (result instanceof SimpleUserLoginController.ShowAdvancedResult) {
                return this.showAdvancedUserLoginDialog();
            }
            if (result instanceof SimpleUserLoginController.LoggedInResult) {
                SimpleUserLoginController.LoggedInResult loggedInResult = (SimpleUserLoginController.LoggedInResult)result;
                return new UserLoginResult(loggedInResult.getUserLoginInfo(), loggedInResult.getLoggedInUser());
            }
            throw new RuntimeException("Unexpected type of SimpleUserLoginController.Result: " + result.getClass().getSimpleName());
        }
        return null;
    }

    private UserLoginResult showLocalLoginDialog(UserLoginInfo userLoginInfo) {
        SimpleUserLoginDialog simpleUserLoginDialog = (SimpleUserLoginDialog)this.simpleUserLoginDialogProvider.get();
        return simpleUserLoginDialog.showLocalLoginAndWait(userLoginInfo);
    }

    private UserLoginResult showAdvancedUserLoginDialog() {
        AdvancedUserLoginDialog advancedUserLoginDialog = (AdvancedUserLoginDialog)this.advancedUserLoginDialogProvider.get();
        GeniUser loggedInUser = advancedUserLoginDialog.showUserLogin(null);
        if (loggedInUser != null) {
            return new UserLoginResult(advancedUserLoginDialog.getUserLoginInfo(), loggedInUser);
        }
        return null;
    }

    public static class UserLoginResult {
        private final UserLoginInfo userLoginInfo;
        private final GeniUser loggedInUser;

        public UserLoginResult(UserLoginInfo userLoginInfo, GeniUser loggedInUser) {
            this.userLoginInfo = userLoginInfo;
            this.loggedInUser = loggedInUser;
        }

        public UserLoginInfo getUserLoginInfo() {
            return this.userLoginInfo;
        }

        public GeniUser getLoggedInUser() {
            return this.loggedInUser;
        }
    }
}

