/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.PreferencesSubPane;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.SubSectionLibrary;
import be.iminds.ilabt.jfed.gui_preferences.JFedPreferencesApplier;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainPreferencesPane {
    private static final Logger LOG = LoggerFactory.getLogger(MainPreferencesPane.class);
    @FXML
    private StackPane subSectionStackPane;
    @FXML
    private ListView<Label> subSectionListView;
    @FXML
    protected Button saveButton;
    @FXML
    protected Button cancelButton;
    @FXML
    protected Button resetButton;
    @FXML
    protected CheckBox advancedCheckBox;
    private final List<PreferencesSubPane> preferencesSubPanes = new ArrayList<PreferencesSubPane>();
    private final Map<Label, ScrollPane> preferencesSubPanesContainersByLabel = new HashMap<Label, ScrollPane>();
    private final Map<Class<? extends PreferencesSubPane>, Label> labelBySubSectionPane = new HashMap<Class<? extends PreferencesSubPane>, Label>();
    private final ObservableList<Label> allSubPanes = FXCollections.observableArrayList();
    private final ObservableList<Label> basicSubPanes = FXCollections.observableArrayList();
    private final SubSectionLibrary subSectionLibrary;
    private final JFedPreferencesApplier jFedPreferencesApplier;

    @Inject
    MainPreferencesPane(SubSectionLibrary subSectionLibrary, JFedPreferencesApplier jFedPreferencesApplier) {
        this.subSectionLibrary = subSectionLibrary;
        this.jFedPreferencesApplier = jFedPreferencesApplier;
    }

    private ScrollPane wrapInScrollPane(PreferencesSubPane node) {
        assert (node != null);
        ScrollPane container = new ScrollPane(node.getRoot());
        container.setFitToHeight(true);
        container.setFitToWidth(true);
        return container;
    }

    @FXML
    private void initialize() {
        List<PreferencesSubPane> subPanes = this.subSectionLibrary.filterByOs(OSDetector.findOS()).get();
        LOG.debug("Got the following subpanes: {}", subPanes);
        for (PreferencesSubPane subPane : subPanes) {
            LOG.debug("Initializing subPane {}", (Object)(subPane != null ? subPane.getClass().getName() : "NULL !!!"));
            ScrollPane subPaneContainer = this.wrapInScrollPane(subPane);
            this.subSectionStackPane.getChildren().add((Object)subPaneContainer);
            this.allSubPanes.add((Object)subPane.getListLabel());
            if (!subPane.isAdvanced()) {
                this.basicSubPanes.add((Object)subPane.getListLabel());
            }
            this.preferencesSubPanesContainersByLabel.put(subPane.getListLabel(), subPaneContainer);
            this.preferencesSubPanes.add(subPane);
            this.labelBySubSectionPane.put(subPane.getClass(), subPane.getListLabel());
            subPaneContainer.managedProperty().bind((ObservableValue)subPaneContainer.visibleProperty());
            subPaneContainer.setVisible(false);
        }
        this.subSectionListView.setItems(this.basicSubPanes);
        this.advancedCheckBox.setSelected(true);
        this.subSectionListView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.subSectionListView.getSelectionModel().selectedItemProperty().addListener((observableValue, oldSelection, newSelection) -> {
            if (oldSelection != null) {
                if (this.preferencesSubPanesContainersByLabel.containsKey(oldSelection)) {
                    this.preferencesSubPanesContainersByLabel.get(oldSelection).setVisible(false);
                } else {
                    LOG.warn("preferencesSubPanesByLabel did not contain oldSelection label " + String.valueOf(oldSelection) + " with text=" + oldSelection.getText());
                }
            }
            if (newSelection != null) {
                if (this.preferencesSubPanesContainersByLabel.containsKey(newSelection)) {
                    this.preferencesSubPanesContainersByLabel.get(newSelection).setVisible(true);
                } else {
                    LOG.warn("preferencesSubPanesByLabel did not contain newSelection label " + String.valueOf(newSelection) + " with text=" + newSelection.getText());
                }
            }
        });
        this.subSectionListView.getSelectionModel().selectFirst();
        this.advancedCheckBox.selectedProperty().addListener((observableValue, oldValue, newValue) -> this.setShowAdvanced((boolean)newValue));
        this.setShowAdvanced(this.advancedCheckBox.isSelected());
    }

    @SafeVarargs
    public final void setVisibileSubPane(Class<? extends PreferencesSubPane> ... subPaneClasses) {
        Class<? extends PreferencesSubPane> subPaneClass;
        Label subSectionLabel = null;
        Class<? extends PreferencesSubPane>[] classArray = subPaneClasses;
        int n = classArray.length;
        for (int i = 0; i < n && (subSectionLabel = this.labelBySubSectionPane.get(subPaneClass = classArray[i])) == null; ++i) {
        }
        if (subSectionLabel == null) {
            LOG.warn("Could not find subpane of class {}", Arrays.asList(subPaneClasses));
            return;
        }
        this.subSectionListView.getSelectionModel().select(subSectionLabel);
    }

    public void setShowAdvanced(boolean showAdvanced) {
        Label selected = (Label)this.subSectionListView.getSelectionModel().getSelectedItem();
        ObservableList<Label> newList = showAdvanced ? this.allSubPanes : this.basicSubPanes;
        this.subSectionListView.setItems(newList);
        if (selected != null && newList.contains((Object)selected)) {
            this.subSectionListView.getSelectionModel().select((Object)selected);
        } else {
            this.subSectionListView.getSelectionModel().selectFirst();
        }
    }

    @FXML
    protected void onSaveButtonAction() {
        for (PreferencesSubPane subPane : this.preferencesSubPanes) {
            boolean ok = subPane.check();
            if (ok) continue;
            this.subSectionListView.getSelectionModel().select((Object)subPane.getListLabel());
            return;
        }
        this.preferencesSubPanes.forEach(PreferencesSubPane::save);
        this.jFedPreferencesApplier.applyPreferences();
        this.onCancelButtonAction();
    }

    @FXML
    protected void onCancelButtonAction() {
        Stage stage = (Stage)this.cancelButton.getScene().getWindow();
        stage.close();
    }
}

