/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.PreferencesSubPane;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javafx.fxml.FXMLLoader;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubSectionLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(SubSectionLibrary.class);
    private OSDetector.OS os;
    private static final String GENERAL_PANE_FXML = "subsections/GeneralPane.fxml";
    private static final String TERMINAL_COMMAND_PANE_FXML = "subsections/TerminalCommandPane.fxml";
    private static final String SSH_COMMAND_PANE_FXML = "subsections/SshCommandPane.fxml";
    private static final String PUTTY_PANE_FXML = "subsections/PuttyPane.fxml";
    private static final String SSH_AUTHENTICATION_PANE_FXML = "subsections/SshAuthenticationPane.fxml";
    private static final String PROXY_PANE_FXML = "subsections/ProxyPane.fxml";
    private static final String SCS_PANE_FXML = "subsections/ScsPane.fxml";
    private static final String LOGININFO_PANE_FXML = "subsections/LoginInfoPane.fxml";
    private static final String LOGIN_PANE_FXML = "subsections/LoginPane.fxml";
    private static final String TESTBEDS_PANE = "subsections/TestbedsPane.fxml";
    private static final String EDITOR_PANE = "subsections/EditorPane.fxml";
    private static final String LOGLEVEL_PANE = "subsections/LogLevelPane.fxml";
    private static final String RDP_PANE_FXML = "subsections/RDPPane.fxml";
    private static final String GIT_PANE_FXML = "subsections/GitAuthenticationPane.fxml";
    private final Provider<FXMLLoader> loaderProvider;

    @Inject
    SubSectionLibrary(Provider<FXMLLoader> loaderProvider) {
        this.loaderProvider = loaderProvider;
    }

    public SubSectionLibrary filterByOs(OSDetector.OS os) {
        this.os = os;
        return this;
    }

    public List<PreferencesSubPane> get() {
        ArrayList<PreferencesSubPane> res = new ArrayList<PreferencesSubPane>();
        res.add(this.initializePane(GENERAL_PANE_FXML));
        res.add(this.initializePane(SSH_AUTHENTICATION_PANE_FXML));
        if (this.os != null && OSDetector.getUnixLikeOsFilter().includedOs(this.os)) {
            res.add(this.initializePane(TERMINAL_COMMAND_PANE_FXML));
            res.add(this.initializePane(SSH_COMMAND_PANE_FXML));
        }
        if (this.os != null && this.os == OSDetector.OS.WIN) {
            res.add(this.initializePane(PUTTY_PANE_FXML));
        }
        res.add(this.initializePane(PROXY_PANE_FXML));
        res.add(this.initializePane(SCS_PANE_FXML));
        res.add(this.initializePane(LOGIN_PANE_FXML));
        res.add(this.initializePane(TESTBEDS_PANE));
        res.add(this.initializePane(EDITOR_PANE));
        res.add(this.initializePane(LOGLEVEL_PANE));
        res.add(this.initializePane(RDP_PANE_FXML));
        res.add(this.initializePane(GIT_PANE_FXML));
        ListIterator it = res.listIterator();
        while (it.hasNext()) {
            PreferencesSubPane psp = (PreferencesSubPane)it.next();
            if (psp != null) continue;
            LOG.error("A Preference sub panel failed to load!");
            assert (false);
            it.remove();
        }
        return res;
    }

    private PreferencesSubPane initializePane(String fxml) {
        FXMLLoader loader = (FXMLLoader)this.loaderProvider.get();
        try {
            loader.setLocation(this.getClass().getResource(fxml));
            loader.load();
            PreferencesSubPane result = (PreferencesSubPane)loader.getController();
            assert (result != null);
            if (result == null) {
                LOG.error("Failed to load panel \"" + fxml + "\"");
                return null;
            }
            return result;
        }
        catch (IOException e) {
            LOG.error("Could not initialize preferences pane \"" + fxml + "\"", (Throwable)e);
            assert (false);
            return null;
        }
    }
}

