/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedExperimenterGuiConfigProvider;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.TextFieldWithStatus;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(EditorPane.class);
    @FXML
    private TextFieldWithStatus guiConfigsXmlUrlTextField;
    @FXML
    private HBox guiConfigsXmlUrlTextBox;
    @FXML
    private HBox guiConfigsXmlLocalFileBox;
    @FXML
    private TextFieldWithStatus guiConfigsXmlLocalFileTextField;
    @FXML
    private Button guiConfigsXmlLocalFileBrowseButton;
    @FXML
    private RadioButton defaultGuiConfigsXml;
    @FXML
    private RadioButton onlineGuiConfigXml;
    @FXML
    private RadioButton localGuiConfigXml;
    @FXML
    private RadioButton builtinGuiConfigXml;
    @FXML
    private BorderPane root;
    @FXML
    private Label extraGuiConfigsLabel;
    @FXML
    private Label extraGuiConfigsFlagsLabel;
    @FXML
    private TextField extraGuiConfigsFlagsField;
    private final JFedHLPreferences jFedPreferences;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    EditorPane(JFedHLPreferences jFedPreferences) {
        super("Icon Catalog & Gui Fine-tuning", true);
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    private void initialize() {
        this.guiConfigsXmlLocalFileBox.managedProperty().bind((ObservableValue)this.guiConfigsXmlLocalFileBox.visibleProperty());
        this.guiConfigsXmlLocalFileBox.visibleProperty().bind((ObservableValue)this.localGuiConfigXml.selectedProperty());
        this.guiConfigsXmlUrlTextBox.managedProperty().bind((ObservableValue)this.guiConfigsXmlUrlTextBox.visibleProperty());
        this.guiConfigsXmlUrlTextBox.visibleProperty().bind((ObservableValue)this.onlineGuiConfigXml.selectedProperty());
        this.guiConfigsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.ERROR);
        this.guiConfigsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
        this.guiConfigsXmlLocalFileTextField.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.guiConfigsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.NONE);
            } else {
                this.testGuiConfigsXmlLocalFile();
            }
        });
        this.guiConfigsXmlUrlTextField.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.guiConfigsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.NONE);
            } else {
                this.testGuiConfigsXmlUrl();
            }
        });
        String guiConfigsSourcePref = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_SOURCE);
        if (guiConfigsSourcePref.equalsIgnoreCase("AUTO") || guiConfigsSourcePref.equalsIgnoreCase("DEFAULT")) {
            this.defaultGuiConfigsXml.setSelected(true);
        } else if (guiConfigsSourcePref.equalsIgnoreCase("BUILTIN")) {
            this.builtinGuiConfigXml.setSelected(true);
        } else if (guiConfigsSourcePref.startsWith("file:")) {
            this.localGuiConfigXml.setSelected(true);
            this.guiConfigsXmlLocalFileTextField.setText(guiConfigsSourcePref.substring(5));
            this.testGuiConfigsXmlLocalFile();
        } else {
            this.onlineGuiConfigXml.setSelected(true);
            this.guiConfigsXmlUrlTextField.setText(guiConfigsSourcePref);
            this.testGuiConfigsXmlUrl();
        }
        this.extraGuiConfigsFlagsField.setText(this.jFedPreferences.getStringList((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_EXTRA_FLAGS).stream().collect(Collectors.joining(",")));
        this.updateExtraGuiConfigsLabels();
    }

    private void updateExtraGuiConfigsLabels() {
        List extraFiles = JFedExperimenterGuiConfigProvider.getExtraGuiConfigFiles();
        List overwriteFiles = JFedExperimenterGuiConfigProvider.getOverwriteGuiConfigFiles();
        this.extraGuiConfigsLabel.setText("The files below will be scanned for additional GUI editor config information:" + (extraFiles.isEmpty() ? "" : "\n  -  ") + extraFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining("\n   - ")) + (overwriteFiles.isEmpty() ? "" : "\n  - (*) ") + overwriteFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining("\n   - (*) ")) + (overwriteFiles.isEmpty() ? "" : "\n\nThe files marked with a (*) will overwrite information from other sources, the other files will never do this."));
        this.extraGuiConfigsLabel.setVisible(!extraFiles.isEmpty() || !overwriteFiles.isEmpty());
    }

    @FXML
    private void onGuiConfigsXmlLocalFileBrowseButtonAction(ActionEvent actionEvent) {
        FileChooser dc = new FileChooser();
        dc.setTitle("Select the local Gui Editor Config Information File");
        File selectedFile = dc.showOpenDialog(this.guiConfigsXmlLocalFileTextField.getScene().getWindow());
        if (selectedFile != null) {
            this.guiConfigsXmlLocalFileTextField.setText(selectedFile.getAbsolutePath());
            this.testGuiConfigsXmlLocalFile();
        }
    }

    private boolean testGuiConfigsXmlUrl() {
        URL url;
        try {
            url = new URL(this.guiConfigsXmlUrlTextField.getText());
        }
        catch (MalformedURLException e) {
            this.guiConfigsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            this.guiConfigsXmlUrlTextField.setStatusDetailString("Not a valid URL");
            return false;
        }
        try {
            String content = IOUtils.streamToString((InputStream)url.openStream(), (String)"UTF-8");
            if (this.testGuiConfigsXmlContent(content)) {
                this.guiConfigsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.OK);
                this.guiConfigsXmlUrlTextField.setStatusDetailString("");
            } else {
                this.guiConfigsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.ERROR);
                this.guiConfigsXmlUrlTextField.setStatusDetailString("Content at URL is invalid");
                LOG.warn("Invalid content in remote gui config \"" + String.valueOf(url) + "\"");
            }
            return true;
        }
        catch (IOException e) {
            this.guiConfigsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            this.guiConfigsXmlUrlTextField.setStatusDetailString("IOException opening file: " + e.getMessage());
            LOG.warn("Failed to open user remote gui config \"" + String.valueOf(url) + "\"", (Throwable)e);
            return false;
        }
    }

    private boolean testGuiConfigsXmlLocalFile() {
        File file = new File(this.guiConfigsXmlLocalFileTextField.getText());
        if (!file.exists()) {
            this.guiConfigsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            this.guiConfigsXmlLocalFileTextField.setStatusDetailString("File does not exist");
            LOG.warn("local gui config \"" + file.getAbsolutePath() + "\" does not exist");
            return false;
        }
        try {
            String content = IOUtils.fileToString((File)file);
            if (this.testGuiConfigsXmlContent(content)) {
                this.guiConfigsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.OK);
                this.guiConfigsXmlLocalFileTextField.setStatusDetailString("");
            } else {
                this.guiConfigsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
                this.guiConfigsXmlLocalFileTextField.setStatusDetailString("Invalid content in file");
                LOG.warn("Invalid content in user local gui config \"" + file.getAbsolutePath() + "\"");
            }
            return true;
        }
        catch (IOException e) {
            this.guiConfigsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            this.guiConfigsXmlLocalFileTextField.setStatusDetailString("IOException opening file: " + e.getMessage());
            LOG.warn("Failed to open user local gui config \"" + file.getAbsolutePath() + "\"", (Throwable)e);
            return false;
        }
    }

    private boolean testGuiConfigsXmlContent(String content) {
        return content.contains("<authorities");
    }

    @Override
    public boolean check() {
        if (this.localGuiConfigXml.isSelected() && this.guiConfigsXmlLocalFileTextField.getStatus() != TextFieldWithStatus.Status.OK) {
            JFDialogs.create().owner((Node)this.root).message("Please provide a valid Gui Editor Config Information File before saving.").showError();
            return false;
        }
        if (this.onlineGuiConfigXml.isSelected() && this.guiConfigsXmlUrlTextField.getStatus() != TextFieldWithStatus.Status.OK) {
            JFDialogs.create().owner((Node)this.root).message("Please provide a valid Gui Editor Config Information URL before saving.").showError();
            return false;
        }
        assert (this.extraGuiConfigsFlagsField.getText() != null);
        if (this.extraGuiConfigsFlagsField.getText().trim().matches(".*[^,] [^,].*")) {
            JFDialogs.create().owner((Node)this.root).message("Extra fields should not contain spaces. It should be a comma seperated list.").showError();
            return false;
        }
        return true;
    }

    @Override
    public boolean save() {
        List extraFlags;
        if (!this.check()) {
            return false;
        }
        if (this.defaultGuiConfigsXml.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_SOURCE, "AUTO");
        }
        if (this.builtinGuiConfigXml.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_SOURCE, "BUILTIN");
        }
        if (this.localGuiConfigXml.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_SOURCE, "file:" + this.guiConfigsXmlLocalFileTextField.getText());
        }
        if (this.onlineGuiConfigXml.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_SOURCE, this.guiConfigsXmlUrlTextField.getText());
        }
        if (!(extraFlags = Arrays.asList(this.extraGuiConfigsFlagsField.getText().trim().split(",")).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList())).isEmpty()) {
            this.jFedPreferences.setStringList((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_EXTRA_FLAGS, extraFlags);
        } else {
            this.jFedPreferences.clear((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GUICONFIG_EXTRA_FLAGS);
        }
        return true;
    }
}

