/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.NumericTextField;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralPane.class);
    @FXML
    private CheckBox expirationWarningCheckBox;
    @FXML
    private NumericTextField expirationWarningTime;
    @FXML
    private CheckBox recoverExpirationWarningCheckBox;
    @FXML
    private NumericTextField recoverExpirationWarningTime;
    @FXML
    private BorderPane root;
    private final JFedHLPreferences jFedPreferences;

    @Inject
    protected GeneralPane(JFedHLPreferences jFedPreferences) {
        super("General", false);
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    private void initialize() {
        this.expirationWarningTime.disableProperty().bind((ObservableValue)this.expirationWarningCheckBox.selectedProperty().not());
        this.expirationWarningCheckBox.setSelected(this.jFedPreferences.isExpirationWarningEnabled());
        this.expirationWarningTime.setText(String.format("%02d", this.jFedPreferences.getExpirationWarningTime()));
        this.recoverExpirationWarningTime.disableProperty().bind((ObservableValue)this.recoverExpirationWarningCheckBox.selectedProperty().not());
        this.recoverExpirationWarningCheckBox.setSelected(this.jFedPreferences.isRecoverExpirationWarningEnabled());
        this.recoverExpirationWarningTime.setText(String.format("%02d", this.jFedPreferences.getRecoverExpirationWarningTime()));
    }

    @Override
    public boolean check() {
        int value;
        if (this.expirationWarningCheckBox.isSelected()) {
            try {
                value = Integer.parseInt(this.expirationWarningTime.getText());
                if (value < 1) {
                    JFDialogs.create().owner((Node)this.root).message("Expiration warning time must be 1 or more minutes").showError();
                }
            }
            catch (NumberFormatException ex) {
                JFDialogs.create().owner((Node)this.root).message("Please enter a valid number.").showError();
                return false;
            }
        }
        if (this.recoverExpirationWarningCheckBox.isSelected()) {
            try {
                value = Integer.parseInt(this.recoverExpirationWarningTime.getText());
                if (value < 1) {
                    JFDialogs.create().owner((Node)this.root).message("Recover expiration warning time must be 1 or more minutes").showError();
                }
            }
            catch (NumberFormatException ex) {
                JFDialogs.create().owner((Node)this.root).message("Please enter a valid number.").showError();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean save() {
        this.jFedPreferences.setExpirationWarningEnabled(this.expirationWarningCheckBox.isSelected());
        try {
            this.jFedPreferences.setExpirationWarningTime(Integer.parseInt(this.expirationWarningTime.getText()));
        }
        catch (NumberFormatException ex) {
            LOG.warn("Ignoring expiration time setting because the given time is invalid", (Throwable)ex);
        }
        this.jFedPreferences.setRecoverExpirationWarningEnabled(this.recoverExpirationWarningCheckBox.isSelected());
        try {
            this.jFedPreferences.setRecoverExpirationWarningTime(Integer.parseInt(this.recoverExpirationWarningTime.getText()));
        }
        catch (NumberFormatException ex) {
            LOG.warn("Ignoring recover expiration time setting because the given time is invalid", (Throwable)ex);
        }
        return true;
    }

    @Override
    public Node getRoot() {
        return this.root;
    }
}

