/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.TextFieldWithStatus;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.PEMUtil;
import java.io.File;
import java.io.IOException;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitAuthenticationPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(GitAuthenticationPane.class);
    protected final GeniUserProvider geniUserProvider;
    protected final JFedHLPreferences jFedPreferences;
    @FXML
    protected RadioButton noneMethodRadioButton;
    @FXML
    protected RadioButton loginMethodRadioButton;
    @FXML
    protected RadioButton customSshMethodRadioButton;
    @FXML
    protected RadioButton userpassMethodRadioButton;
    @FXML
    protected RadioButton complexMethodRadioButton;
    @FXML
    protected Label privateKeyLabel;
    @FXML
    protected TextFieldWithStatus fileTextField;
    @FXML
    protected Button browseButton;
    @FXML
    private BorderPane root;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    GitAuthenticationPane(GeniUserProvider geniUserProvider, JFedHLPreferences jFedPreferences) {
        super("Git Authentication", false);
        this.geniUserProvider = geniUserProvider;
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    protected void initialize() {
        File privateKeyFile = this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GIT_AUTH_KEYFILE);
        if (privateKeyFile != null) {
            this.fileTextField.setText(privateKeyFile.getAbsolutePath());
        } else {
            this.fileTextField.setText("");
        }
        String method = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GIT_AUTH_METHOD);
        if (method == null) {
            method = "NONE";
        }
        switch (method) {
            default: {
                this.noneMethodRadioButton.setSelected(true);
                break;
            }
            case "SSH_LOGIN": {
                this.loginMethodRadioButton.setSelected(true);
                break;
            }
            case "SSH_CUSTOM": {
                this.customSshMethodRadioButton.setSelected(true);
                break;
            }
            case "USER_PASS": {
                this.userpassMethodRadioButton.setSelected(true);
            }
        }
    }

    @FXML
    protected void onBrowsePrivateKeyButtonAction(ActionEvent actionEvent) {
        FileChooser fc = new FileChooser();
        fc.setTitle("Select your Private SSH Key");
        File selectedFile = fc.showOpenDialog(this.fileTextField.getScene().getWindow());
        if (selectedFile != null) {
            this.fileTextField.setText(selectedFile.getAbsolutePath());
            this.testPrivateKey();
        }
    }

    protected boolean testPrivateKey() {
        if (this.fileTextField.getText().length() == 0) {
            this.fileTextField.setStatus(TextFieldWithStatus.Status.NONE);
            return false;
        }
        try {
            if (this.testPrivateKeyFile(new File(this.fileTextField.getText()))) {
                this.fileTextField.setStatus(TextFieldWithStatus.Status.OK);
                return true;
            }
            JFDialogs.create().owner((Node)this.root).message(" Please select a valid private key for git authentication.").masthead("The provided key is not valid.").title("Invalid key").showWarning();
            this.fileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            return false;
        }
        catch (IOException ex) {
            JFDialogs.create().owner((Node)this.root).message("An error occured while processing the key file").masthead("Error").title("Error").showException((Throwable)ex);
            this.fileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            return false;
        }
    }

    protected boolean testPrivateKeyFile(File file) throws IOException {
        if (file.exists() && file.isFile()) {
            String fileContents = IOUtils.fileToString((File)file);
            boolean res = PEMUtil.hasValidPrivateKeyPEM((String)fileContents);
            if (!res) {
                LOG.debug("testPrivateKeyFile false because file no valid private key PEM.");
            }
            return res;
        }
        LOG.debug("testPrivateKeyFile false because file " + String.valueOf(file) + " does not exist.");
        return false;
    }

    @Override
    public boolean check() {
        return !this.customSshMethodRadioButton.isSelected() || this.testPrivateKey();
    }

    @Override
    public boolean save() {
        if (this.customSshMethodRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GIT_AUTH_METHOD, "SSH_CUSTOM");
            File privKeyFile = new File(this.fileTextField.getText());
            this.jFedPreferences.setFile((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GIT_AUTH_KEYFILE, privKeyFile);
            return true;
        }
        this.jFedPreferences.clear((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GIT_AUTH_KEYFILE);
        if (this.noneMethodRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GIT_AUTH_METHOD, "NONE");
            return true;
        }
        if (this.loginMethodRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GIT_AUTH_METHOD, "SSH_LOGIN");
            return true;
        }
        if (this.userpassMethodRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_GIT_AUTH_METHOD, "NONE");
            return true;
        }
        return false;
    }
}

