/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.logging.BugReportAppender;
import be.iminds.ilabt.jfed.logging.JFedLoggerManager;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLevelPane
extends AbstractPreferencesSubPane
implements BugReportAppender.LoggingEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(LogLevelPane.class);
    private final JFedLoggerManager jFedLoggerManager;
    @FXML
    protected GridPane grid;
    @FXML
    protected CheckBox overwriteCheckBox;
    @FXML
    protected RadioButton rootDebugRadioButton;
    @FXML
    protected RadioButton rootInfoRadioButton;
    @FXML
    protected RadioButton rootWarnRadioButton;
    @FXML
    protected RadioButton rootErrorRadioButton;
    @FXML
    protected RadioButton exttermDebugRadioButton;
    @FXML
    protected RadioButton exttermInfoRadioButton;
    @FXML
    protected RadioButton exttermWarnRadioButton;
    @FXML
    protected RadioButton exttermErrorRadioButton;
    @FXML
    protected CheckBox cpuCheckBox;
    @FXML
    protected ListView bugreportLogList;
    protected final ObservableList<ILoggingEvent> logLines = FXCollections.observableList(new LinkedList());
    @FXML
    private BorderPane root;
    private final SfaConnectionPool sfaConnectionPool;
    private final JFedHLPreferences jFedPreferences;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    LogLevelPane(JFedLoggerManager jFedLoggerManager, SfaConnectionPool sfaConnectionPool, JFedHLPreferences jFedPreferences) {
        super("Logging", true);
        this.jFedLoggerManager = jFedLoggerManager;
        this.sfaConnectionPool = sfaConnectionPool;
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    private void initialize() {
        String currentSetExttermLogLevel;
        for (Node n : this.grid.getChildren()) {
            if (n != this.overwriteCheckBox) {
                n.disableProperty().bind((ObservableValue)this.overwriteCheckBox.selectedProperty().not());
            }
            n.managedProperty().bind((ObservableValue)n.visibleProperty());
        }
        this.overwriteCheckBox.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_OVERWRITE, false));
        String currentSetRootLogLevel = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_ROOT_LEVEL);
        if (currentSetRootLogLevel == null) {
            currentSetRootLogLevel = "DEBUG";
        }
        if (currentSetRootLogLevel.equalsIgnoreCase("DEBUG")) {
            this.rootDebugRadioButton.setSelected(true);
        }
        if (currentSetRootLogLevel.equalsIgnoreCase("INFO")) {
            this.rootInfoRadioButton.setSelected(true);
        }
        if (currentSetRootLogLevel.equalsIgnoreCase("WARN")) {
            this.rootWarnRadioButton.setSelected(true);
        }
        if (currentSetRootLogLevel.equalsIgnoreCase("ERROR")) {
            this.rootErrorRadioButton.setSelected(true);
        }
        if ((currentSetExttermLogLevel = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_EXTTERM_LEVEL)) == null) {
            currentSetExttermLogLevel = "DEBUG";
        }
        if (currentSetExttermLogLevel.equalsIgnoreCase("DEBUG")) {
            this.exttermDebugRadioButton.setSelected(true);
        }
        if (currentSetExttermLogLevel.equalsIgnoreCase("INFO")) {
            this.exttermInfoRadioButton.setSelected(true);
        }
        if (currentSetExttermLogLevel.equalsIgnoreCase("WARN")) {
            this.exttermWarnRadioButton.setSelected(true);
        }
        if (currentSetExttermLogLevel.equalsIgnoreCase("ERROR")) {
            this.exttermErrorRadioButton.setSelected(true);
        }
        this.cpuCheckBox.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_DEBUG_CPU).booleanValue());
        this.bugreportLogList.setCellFactory(TextFieldListCell.forListView((StringConverter)new StringConverter<ILoggingEvent>(){

            public String toString(ILoggingEvent e) {
                return e.getFormattedMessage();
            }

            public ILoggingEvent fromString(String string) {
                throw new RuntimeException("not used");
            }
        }));
        BugReportAppender bugReportAppender = this.jFedLoggerManager.getBugReportMemoryAppender();
        if (bugReportAppender != null) {
            List currentLogLines = bugReportAppender.getListCopy();
            this.logLines.addAll((Collection)currentLogLines);
            LOG.debug("GUI is showing the BugReportAppender log lines. size=" + currentLogLines.size());
            bugReportAppender.addListeners((BugReportAppender.LoggingEventListener)this);
        } else {
            LOG.warn("GUI could not get BUGREPORT appender.");
        }
        this.bugreportLogList.setItems(this.logLines);
    }

    public void onLoggingEvent(ILoggingEvent e) {
        Platform.runLater(() -> {
            this.logLines.add((Object)e);
            int maxSize = 512;
            if (maxSize >= 0) {
                while (this.logLines.size() > maxSize) {
                    this.logLines.remove(0);
                }
            }
        });
    }

    @FXML
    protected void testLogging() {
        this.save();
        this.jFedLoggerManager.testLogging();
    }

    private String getLogLevel(Logger logger) {
        if (logger.isTraceEnabled()) {
            return "TRACE";
        }
        if (logger.isDebugEnabled()) {
            return "DEBUG";
        }
        if (logger.isInfoEnabled()) {
            return "INFO";
        }
        if (logger.isWarnEnabled()) {
            return "WARN";
        }
        if (logger.isErrorEnabled()) {
            return "ERROR";
        }
        return "NONE";
    }

    private String getGuiRootLogLevel() {
        if (this.rootDebugRadioButton.isSelected()) {
            return "DEBUG";
        }
        if (this.rootInfoRadioButton.isSelected()) {
            return "INFO";
        }
        if (this.rootWarnRadioButton.isSelected()) {
            return "WARN";
        }
        if (this.rootErrorRadioButton.isSelected()) {
            return "ERROR";
        }
        LOG.warn("No log level selected by user, using default: DEBUG");
        return "DEBUG";
    }

    private String getGuiExttermLogLevel() {
        if (this.exttermDebugRadioButton.isSelected()) {
            return "DEBUG";
        }
        if (this.exttermInfoRadioButton.isSelected()) {
            return "INFO";
        }
        if (this.exttermWarnRadioButton.isSelected()) {
            return "WARN";
        }
        if (this.exttermErrorRadioButton.isSelected()) {
            return "ERROR";
        }
        LOG.warn("No log level selected by user, using default: DEBUG");
        return "DEBUG";
    }

    @Override
    public boolean check() {
        return true;
    }

    @Override
    public boolean save() {
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_DEBUG_CPU, this.cpuCheckBox.isSelected());
        this.sfaConnectionPool.setDebugCpuUsage(this.cpuCheckBox.isSelected());
        boolean overwrite = this.overwriteCheckBox.isSelected();
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_OVERWRITE, overwrite);
        if (overwrite) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_ROOT_LEVEL, this.getGuiRootLogLevel());
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_EXTTERM_LEVEL, this.getGuiExttermLogLevel());
        }
        this.jFedLoggerManager.updateLoggers();
        return true;
    }
}

