/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.util.ExpandableHelp;
import be.iminds.ilabt.jfed.util.lib.JFedPasswordManager;
import be.iminds.ilabt.jfed.util.library.LoginInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.inject.Inject;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginInfoPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(LoginInfoPane.class);
    private final GeniUserProvider geniUserProvider;
    private final TestbedInfoSource testbedInfoSource;
    private final JFedHLPreferences jFedPreferences;
    private final JFedPasswordManager passwordManager;
    ObservableList<LoginInfo> loginInfos;
    @FXML
    protected TableView<LoginInfo> tableView;
    @FXML
    protected TableColumn<LoginInfo, String> passColumn;
    @FXML
    protected TableColumn<LoginInfo, Boolean> removeButtonColumn;
    @FXML
    private BorderPane root;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    LoginInfoPane(GeniUserProvider geniUserProvider, TestbedInfoSource testbedInfoSource, JFedHLPreferences jFedPreferences) {
        super("Additional Accounts", false);
        this.geniUserProvider = geniUserProvider;
        this.testbedInfoSource = testbedInfoSource;
        this.jFedPreferences = jFedPreferences;
        this.passwordManager = new JFedPasswordManager();
        try {
            this.passwordManager.load((JFedPreferences)jFedPreferences, geniUserProvider.getLoggedInGeniUser());
        }
        catch (AssertionError | Exception t) {
            LOG.error("Unexpected Exception recovering passwords", (Throwable)t);
        }
    }

    @FXML
    private void initialize() {
        this.loginInfos = FXCollections.observableArrayList((Collection)this.passwordManager.getLogins());
        this.tableView.setItems(this.loginInfos);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        assert (this.passColumn != null);
        this.passColumn.setCellValueFactory(features -> {
            String pass = ((LoginInfo)features.getValue()).getPassword();
            if (pass == null || pass.isEmpty()) {
                return new ReadOnlyStringWrapper("");
            }
            Object hiddenPass = "";
            for (int i = 0; i < pass.length(); ++i) {
                hiddenPass = (String)hiddenPass + "x";
            }
            return new ReadOnlyStringWrapper((String)hiddenPass);
        });
        assert (this.removeButtonColumn != null);
        this.removeButtonColumn.setCellValueFactory(p -> new SimpleObjectProperty((Object)(p.getValue() != null ? 1 : 0)));
        this.removeButtonColumn.setCellFactory((Callback)new Callback<TableColumn<LoginInfo, Boolean>, TableCell<LoginInfo, Boolean>>(){

            public TableCell<LoginInfo, Boolean> call(TableColumn<LoginInfo, Boolean> btnCol) {
                return new TableCell<LoginInfo, Boolean>(){
                    final Button button = new Button();
                    {
                        this.button.setGraphic((Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES, (Color)Color.RED));
                        this.button.setText("");
                        this.button.setTooltip(new Tooltip("Remove Account Info"));
                    }

                    public void updateItem(Boolean login, boolean empty) {
                        super.updateItem((Object)login, empty);
                        if (login != null) {
                            this.setGraphic((Node)this.button);
                            this.button.setOnAction(event -> {
                                LoginInfoPane.this.passwordManager.removeLogin((LoginInfo)this.getTableRow().getItem());
                                Platform.runLater(() -> {
                                    try {
                                        LoginInfoPane.this.passwordManager.save((JFedPreferences)LoginInfoPane.this.jFedPreferences, LoginInfoPane.this.geniUserProvider.getLoggedInGeniUser());
                                        LoginInfoPane.this.loginInfos.setAll((Collection)LoginInfoPane.this.passwordManager.getLogins());
                                    }
                                    catch (IOException e) {
                                        LOG.error("Failed to remove password");
                                    }
                                });
                            });
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    @Override
    public boolean check() {
        return true;
    }

    @Override
    public boolean save() {
        return true;
    }

    public void removeAll(ActionEvent actionEvent) {
        this.passwordManager.clear();
        try {
            this.passwordManager.save((JFedPreferences)this.jFedPreferences, this.geniUserProvider.getLoggedInGeniUser());
            this.loginInfos.setAll((Collection)this.passwordManager.getLogins());
        }
        catch (IOException e) {
            LOG.error("Failed to save cleared passwords");
        }
    }

    public void addGts(ActionEvent actionEvent) {
        this.addAccount("GTS");
    }

    public void addAccount(String service) {
        LoginInfoPane.showAddAccountDialog(service, this.getRoot().getScene().getWindow(), this.passwordManager, (JFedPreferences)this.jFedPreferences, this.geniUserProvider.getLoggedInGeniUser());
        this.loginInfos.setAll((Collection)this.passwordManager.getLogins());
    }

    public static void showAddAccountDialog(String service, Window window, JFedPasswordManager passwordManager, JFedPreferences jFedPreferences, GeniUser user) {
        LoginInfo loginInfo = LoginInfoPane.showAddDialog(service, window);
        if (loginInfo == null) {
            return;
        }
        passwordManager.addLogin(loginInfo);
        try {
            passwordManager.save(jFedPreferences, user);
        }
        catch (IOException e) {
            LOG.error("Failed to save login for " + loginInfo.getService() + " user " + loginInfo.getUsername());
        }
    }

    private static LoginInfo showAddDialog(String service, Window window) {
        HBox hboxUserName = new HBox(10.0);
        hboxUserName.getChildren().add((Object)new ImageView(ExpandableHelp.class.getResource("images/user.png").toExternalForm()));
        TextField txUserName = new TextField();
        txUserName.setPromptText("User Name");
        hboxUserName.getChildren().add((Object)txUserName);
        HBox hboxPassword = new HBox(10.0);
        hboxPassword.getChildren().add((Object)new ImageView(ExpandableHelp.class.getResource("images/lock.png").toExternalForm()));
        PasswordField txPassword = new PasswordField();
        txPassword.setPromptText("Password");
        hboxPassword.getChildren().add((Object)txPassword);
        VBox content = new VBox(10.0);
        Label lbMessage = new Label("Please enter your " + service + " account information:");
        content.getChildren().add((Object)lbMessage);
        content.getChildren().add((Object)hboxUserName);
        content.getChildren().add((Object)hboxPassword);
        Dialog dlg = new Dialog();
        dlg.initOwner(window);
        dlg.setTitle(service + " Login");
        DialogPane dlgPane = new DialogPane();
        dlgPane.setContent((Node)content);
        dlgPane.setGraphic((Node)new ImageView(ExpandableHelp.class.getResource("images/login.png").toExternalForm()));
        ButtonType loginButtonType = new ButtonType("Login");
        ButtonType noAccountButtonType = new ButtonType("I don't have an account");
        dlgPane.getButtonTypes().setAll((Object[])new ButtonType[]{loginButtonType, noAccountButtonType});
        dlg.setDialogPane(dlgPane);
        Platform.runLater(() -> ((TextField)txUserName).requestFocus());
        Optional response = dlg.showAndWait();
        return response.isPresent() && response.get() == loginButtonType ? new LoginInfo(service, txUserName.getText(), txPassword.getText()) : null;
    }
}

