/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.experimenter_gui.ui.PasswordInputDialog;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(LoginPane.class);
    private static final String PKCS12_FILE_EXTENSION = ".p12";
    private static final String PEM_FILE_EXTENSION = ".pem";
    @FXML
    private Button pkcs12Button;
    @FXML
    private Button pemButton;
    @FXML
    private TextField urnTextField;
    @FXML
    private BorderPane root;
    private final GeniUserProvider geniUserProvider;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    LoginPane(GeniUserProvider geniUserProvider) {
        super("User Details", false);
        this.geniUserProvider = geniUserProvider;
    }

    @FXML
    private void initialize() {
        this.urnTextField.setText(this.geniUserProvider.getLoggedInGeniUser().getUserUrnString());
    }

    @FXML
    protected void onSavePKCS12Action() {
        assert (this.geniUserProvider.isUserLoggedIn());
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        GeniUrn userUrn = user.getUserUrn();
        String niceName = userUrn.getEncodedTopLevelAuthority() + "_" + userUrn.getEncodedResourceName();
        Path defaultPath = Paths.get(System.getProperty("user.home"), niceName + PKCS12_FILE_EXTENSION);
        FileChooser fc = new FileChooser();
        fc.setInitialFileName(defaultPath.toString());
        fc.setInitialDirectory(new File(System.getProperty("user.home")));
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PKCS #12 file (*.p12)", new String[]{"*.p12"}));
        fc.setTitle("Export your credentials as a PKCS #12 certificate");
        File pemFile = fc.showSaveDialog(this.getRoot().getScene().getWindow());
        if (pemFile == null) {
            LOG.debug("User cancelled file picker dialog while saving PKCS#12");
            return;
        }
        PasswordInputDialog pid = new PasswordInputDialog();
        pid.setHeaderText("Please enter a password to secure your PKCS#12-file:");
        pid.setTitle("Secure your PKCS#12-file");
        Optional password = pid.showAndWait();
        if (!password.isPresent()) {
            LOG.debug("User cancelled password dialog while saving PKCS#12");
            return;
        }
        if (((String)password.get()).trim().isEmpty()) {
            new Alert(Alert.AlertType.ERROR, "You must specify a password to secure your PKCS#12-file!", new ButtonType[0]).show();
            return;
        }
        if (this.savePKCS12File(pemFile, (String)password.get())) {
            new Alert(Alert.AlertType.INFORMATION, "Your PKCS#12 key was successfully saved to " + pemFile.getAbsolutePath(), new ButtonType[0]).show();
        } else {
            new Alert(Alert.AlertType.ERROR, "A problem occurred while saving your certificate. Please try again!", new ButtonType[0]).show();
        }
    }

    private boolean savePKCS12File(File pkcs12File, String passwordString) {
        assert (this.geniUserProvider.isUserLoggedIn());
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        GeniUrn userUrn = user.getUserUrn();
        String niceName = userUrn.getEncodedTopLevelAuthority() + "_" + userUrn.getEncodedResourceName();
        PrivateKey pk = user.getPrivateKey();
        List certs = user.getClientCertificateChain();
        Certificate[] chain = new Certificate[certs.size()];
        for (int i = 0; i < certs.size(); ++i) {
            chain[i] = (Certificate)certs.get(i);
        }
        char[] keyStorePass = passwordString.toCharArray();
        try {
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(null, null);
            keyStore.setKeyEntry(niceName, pk, keyStorePass, chain);
            byte[] pkcs12 = KeyUtil.keyStoreToPKCS12Bytes((KeyStore)keyStore, (String)passwordString, (String)passwordString);
            IOUtils.byteArrayToFile((File)pkcs12File, (byte[])pkcs12);
            LOG.info("Saved user login as PKCS12 to " + String.valueOf(pkcs12File) + "  (" + pkcs12.length + " bytes)");
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to convert and save PK12: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @FXML
    protected void onSavePEMAction() {
        assert (this.geniUserProvider.isUserLoggedIn());
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        GeniUrn userUrn = user.getUserUrn();
        String niceName = userUrn.getEncodedTopLevelAuthority() + "_" + userUrn.getEncodedResourceName();
        Path defaultPath = Paths.get(System.getProperty("user.home"), niceName + PEM_FILE_EXTENSION);
        FileChooser fc = new FileChooser();
        fc.setInitialFileName(defaultPath.toString());
        fc.setInitialDirectory(new File(System.getProperty("user.home")));
        fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PEM file (*.pem)", new String[]{"*.pem"}));
        fc.setTitle("Export your credentials as a PEM certificate");
        File pemFile = fc.showSaveDialog(this.getRoot().getScene().getWindow());
        if (pemFile == null) {
            LOG.debug("User cancelled file picker dialog while saving PEM");
            return;
        }
        PasswordInputDialog pid = new PasswordInputDialog();
        pid.setHeaderText("Please enter a password to secure your PEM-file:");
        pid.setTitle("Secure your PEM-file");
        Optional password = pid.showAndWait();
        if (!password.isPresent()) {
            LOG.debug("User cancelled password dialog while saving PEM");
            return;
        }
        if (((String)password.get()).trim().isEmpty()) {
            new Alert(Alert.AlertType.ERROR, "You must specify a password to secure your PEM-file!", new ButtonType[0]).show();
            return;
        }
        if (this.savePEMFile(pemFile, (String)password.get())) {
            new Alert(Alert.AlertType.INFORMATION, "Your PEM key was successfully saved to " + pemFile.getAbsolutePath(), new ButtonType[0]).show();
        } else {
            new Alert(Alert.AlertType.ERROR, "A problem occurred while saving your certificate. Please try again!", new ButtonType[0]).show();
        }
    }

    private boolean savePEMFile(File pemFile, String passwordString) {
        assert (this.geniUserProvider.isUserLoggedIn());
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        try {
            PrivateKey pk = user.getPrivateKey();
            List certs = user.getClientCertificateChain();
            char[] pemKey = KeyUtil.privateKeyToAnyPem((PrivateKey)pk, (char[])passwordString.toCharArray());
            String pemCerts = KeyUtil.x509certificateChainToPem((Collection)certs);
            String pem = new String(pemKey) + pemCerts;
            IOUtils.stringToFile((File)pemFile, (String)pem);
            LOG.info("Saved user login as pem to " + String.valueOf(pemFile) + "  (" + pem.length() + " chars)");
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to convert and save PEM: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean check() {
        return true;
    }

    @Override
    public boolean save() {
        return true;
    }
}

