/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.SslHostAndPortTest;
import be.iminds.ilabt.jfed.experimenter_gui.ExperimenterGUI;
import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.gui_preferences.DoubleProxyHandling;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyPane.class);
    @FXML
    protected RadioButton neverProxyForJFedRadioButton;
    @FXML
    protected RadioButton autoProxyForJFedRadioButton;
    @FXML
    protected RadioButton alwaysProxyForJFedRadioButton;
    @FXML
    protected RadioButton neverProxyForSshRadioButton;
    @FXML
    protected RadioButton autoProxyForSshRadioButton;
    @FXML
    protected RadioButton alwaysProxyForSshRadioButton;
    @FXML
    protected RadioButton askProxyOnConflictRadioButton;
    @FXML
    protected RadioButton testbedProxyOnConflictRadioButton;
    @FXML
    protected RadioButton jFedProxyOnConflictRadioButton;
    @FXML
    protected Button tryProxyButton;
    @FXML
    protected Label tryProxyResultLabel;
    @FXML
    protected ProgressIndicator proxyProgressBar;
    @FXML
    private BorderPane root;
    private final ExperimenterGUI experimenterGUI;
    private final GeniUserProvider geniUserProvider;
    private final ProxyPreferencesManager proxyPreferencesManager;
    private final TestbedInfoSource testbedInfoSource;
    private final JFedHLPreferences jFedPreferences;
    private Task<Boolean> tryProxyTask;
    private Thread sslHostAndPortTestThread;
    private SslHostAndPortTest sslHostAndPortTest;
    private ConnectivityTest.ConnectivityTestResult sslHostAndPortTestResult;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    ProxyPane(ExperimenterGUI experimenterGUI, GeniUserProvider geniUserProvider, ProxyPreferencesManager proxyPreferencesManager, TestbedInfoSource testbedInfoSource, JFedHLPreferences jFedPreferences) {
        super("Proxy", false);
        this.experimenterGUI = experimenterGUI;
        this.geniUserProvider = geniUserProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
        this.testbedInfoSource = testbedInfoSource;
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    private void initialize() {
        DoubleProxyHandling doubleProxyHandling;
        String useProxyForSsh;
        String useProxyForJFed = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED);
        if (useProxyForJFed.equalsIgnoreCase("NEVER")) {
            this.neverProxyForJFedRadioButton.setSelected(true);
        }
        if (useProxyForJFed.equalsIgnoreCase("AUTO")) {
            this.autoProxyForJFedRadioButton.setSelected(true);
        }
        if (useProxyForJFed.equalsIgnoreCase("ALWAYS")) {
            this.alwaysProxyForJFedRadioButton.setSelected(true);
        }
        if ((useProxyForSsh = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH)).equalsIgnoreCase("NEVER")) {
            this.neverProxyForSshRadioButton.setSelected(true);
        }
        if (useProxyForSsh.equalsIgnoreCase("AUTO")) {
            this.autoProxyForSshRadioButton.setSelected(true);
        }
        if (useProxyForSsh.equalsIgnoreCase("ALWAYS")) {
            this.alwaysProxyForSshRadioButton.setSelected(true);
        }
        if ((doubleProxyHandling = DoubleProxyHandling.fromConfigValue((String)this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_DOUBLE_PROXY_SOLUTION, "dialog"))) == DoubleProxyHandling.ASK) {
            this.askProxyOnConflictRadioButton.setSelected(true);
        }
        if (doubleProxyHandling == DoubleProxyHandling.IGNORE_AND_USE_TESTBED_PROXY) {
            this.testbedProxyOnConflictRadioButton.setSelected(true);
        }
        if (doubleProxyHandling == DoubleProxyHandling.IGNORE_AND_USE_JFED_PROXY) {
            this.jFedProxyOnConflictRadioButton.setSelected(true);
        }
    }

    private void convertPuttyKeysIfNeeded() {
        this.convertPuttyKeysIfNeeded(!this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH).equalsIgnoreCase("NEVER"));
    }

    private void convertPuttyKeysIfNeeded(boolean makeProxyKeys) {
        if (OSDetector.os == OSDetector.OS.WIN) {
            PuTTYFilesKeyInfo sshKeyInfo = this.jFedPreferences.getCustomSshKeyInfo();
            if (sshKeyInfo != null) {
                TmpFile puttyKeyFile = sshKeyInfo.getPuttyKeyFile();
                puttyKeyFile.store();
                assert (puttyKeyFile.getFile().exists());
                puttyKeyFile.delete();
            }
            if (makeProxyKeys) {
                GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
                sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser);
                TmpFile puttyKeyFile = sshKeyInfo.getPuttyKeyFile();
                puttyKeyFile.store();
                assert (puttyKeyFile.getFile().exists());
                puttyKeyFile.delete();
            }
        }
    }

    @FXML
    protected void onTryButtonAction() {
        assert (this.tryProxyTask == null);
        assert (this.geniUserProvider.isUserLoggedIn());
        this.tryProxyButton.setDisable(true);
        this.neverProxyForJFedRadioButton.requestFocus();
        this.proxyPreferencesManager.resetProxyReachabilityCache();
        this.tryProxyResultLabel.setText("Proxy port scan in progress...");
        this.proxyProgressBar.setProgress(0.0);
        this.proxyProgressBar.setVisible(true);
        final ProxyPreferencesManager.TryProxyTask realTryProxyTask = this.proxyPreferencesManager.getTryProxyTask(this.geniUserProvider.getLoggedInGeniUser());
        this.tryProxyTask = new Task<Boolean>(){

            protected Boolean call() throws Exception {
                return realTryProxyTask.call();
            }
        };
        this.proxyProgressBar.progressProperty().bind((ObservableValue)this.tryProxyTask.progressProperty());
        this.tryProxyResultLabel.textProperty().bind((ObservableValue)this.tryProxyTask.messageProperty());
        this.tryProxyTask.setOnSucceeded(workerStateEvent -> Platform.runLater(this::doProxyLoginTest));
        Thread t = new Thread((Runnable)this.tryProxyTask, "Try-Proxy");
        t.setDaemon(true);
        t.start();
        this.convertPuttyKeysIfNeeded(true);
    }

    private void doProxyLoginTest() {
        assert (Platform.isFxApplicationThread());
        assert (this.tryProxyTask != null);
        assert (this.sslHostAndPortTest == null);
        assert (this.sslHostAndPortTestThread == null);
        assert (this.sslHostAndPortTestResult == null);
        boolean portsAvailableHelper = false;
        try {
            portsAvailableHelper = (Boolean)this.tryProxyTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("An error occured while trying the proxies");
        }
        boolean portsAvailable = portsAvailableHelper;
        GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
        Server userAuthority = user.getUserAuthorityServer();
        GeniUser geniUser = user;
        JFedConnection.SshProxyInfo proxyInfo = this.proxyPreferencesManager.chooseUserProxy(userAuthority.getTestbed().getProxies(), user, (SshKeyInfo)SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser));
        if (portsAvailable) {
            URL url = ApiInfo.findUrl((Server)userAuthority, (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2));
            if (url == null) {
                url = ApiInfo.findUrl((Server)userAuthority, (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3));
            }
            if (url == null) {
                url = ApiInfo.findUrl((Server)userAuthority, (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 4));
            }
            if (url == null) {
                url = ApiInfo.findUrl((Server)userAuthority, (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 1));
            }
            if (url == null) {
                try {
                    url = new URL(((Service)userAuthority.getServices().get(0)).getUrl());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("BasicTestbedInfoSource should have prevented this exception from being possible", e);
                }
            }
            LOG.debug("Trying to contact '{}' for connectivity test.", (Object)url.toExternalForm());
            this.sslHostAndPortTest = new SslHostAndPortTest(url, null, null, (JFedConnection.ProxyInfo)proxyInfo, this.testbedInfoSource);
            this.sslHostAndPortTestThread = new Thread(() -> {
                block6: {
                    this.sslHostAndPortTestResult = null;
                    try {
                        Date stopTime;
                        Runnable run = () -> {
                            try {
                                this.sslHostAndPortTestResult = this.sslHostAndPortTest.call();
                            }
                            catch (AssertionError | Exception e) {
                                LOG.error("Exception in sslHostAndPortTest.call()", (Throwable)e);
                                this.sslHostAndPortTestResult = null;
                            }
                        };
                        Thread conTestThread = new Thread(run);
                        Date startTime = new Date();
                        conTestThread.start();
                        try {
                            conTestThread.join(22000L);
                            stopTime = new Date();
                        }
                        catch (InterruptedException e) {
                            LOG.warn("conTestThread.join(12*1000); was interrupted", (Throwable)e);
                            stopTime = new Date();
                        }
                        long duration_ms = stopTime.getTime() - startTime.getTime();
                        LOG.info("sslHostAndPortTest.call() took " + duration_ms + "ms. alive=" + conTestThread.isAlive() + " result=" + String.valueOf(this.sslHostAndPortTestResult));
                        if (conTestThread.isAlive()) {
                            LOG.warn("sslHostAndPortTest.call() did not end in time.");
                            conTestThread.interrupt();
                        }
                    }
                    catch (AssertionError | Exception ex) {
                        LOG.error("Exception trying to setup SSL connection through proxy SSH connection", (Throwable)ex);
                        if (this.sslHostAndPortTestResult != null) break block6;
                        this.sslHostAndPortTestResult = new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "sslHostAndPortTest.call(): " + ((Throwable)ex).getMessage(), (Throwable)ex);
                    }
                }
                if (this.sslHostAndPortTestResult == null) {
                    this.sslHostAndPortTestResult = new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "connectivity test failed for unknown reason");
                }
                LOG.info("Final proxy SSL over SSH test result: " + String.valueOf(this.sslHostAndPortTestResult));
                Platform.runLater(() -> this.processProxyLoginTestResults(portsAvailable, this.sslHostAndPortTestResult.getStatus() == ConnectivityTest.Status.SUCCEEDED));
            });
            this.proxyProgressBar.progressProperty().unbind();
            this.tryProxyResultLabel.textProperty().unbind();
            this.proxyProgressBar.setProgress(0.9);
            this.proxyProgressBar.setVisible(true);
            this.tryProxyResultLabel.setText("Proxy login test in progress...");
            this.sslHostAndPortTestThread.start();
        } else {
            this.proxyProgressBar.progressProperty().unbind();
            this.tryProxyResultLabel.textProperty().unbind();
            this.proxyProgressBar.setProgress(1.0);
            this.proxyProgressBar.setVisible(true);
            this.tryProxyResultLabel.setText("No proxies reachable.");
            this.processProxyLoginTestResults(portsAvailable, false);
        }
    }

    private void processProxyLoginTestResults(boolean portsAvailable, boolean loginWorks) {
        assert (Platform.isFxApplicationThread());
        this.tryProxyResultLabel.textProperty().unbind();
        if (portsAvailable) {
            this.autoProxyForSshRadioButton.setDisable(false);
            this.autoProxyForJFedRadioButton.setDisable(false);
            this.alwaysProxyForSshRadioButton.setDisable(false);
            this.alwaysProxyForJFedRadioButton.setDisable(false);
            Object proxies = "";
            String prevHostname = "";
            for (ProxyPreferencesManager.ProxyPort pi : this.proxyPreferencesManager.getReachableProxies()) {
                proxies = Objects.equals(pi.getHostname(), prevHostname) ? (String)proxies + "," + pi.getPort() : (String)proxies + " " + String.valueOf(pi);
                prevHostname = pi.getHostname();
            }
            if (loginWorks) {
                this.tryProxyResultLabel.setText("Proxy reachable:" + (String)proxies);
            } else {
                this.tryProxyResultLabel.setText("Proxy reachable:" + (String)proxies);
            }
        } else {
            this.autoProxyForSshRadioButton.setDisable(true);
            this.autoProxyForJFedRadioButton.setDisable(true);
            this.alwaysProxyForSshRadioButton.setDisable(true);
            this.alwaysProxyForJFedRadioButton.setDisable(true);
            this.tryProxyResultLabel.setText("No proxies reachable.");
        }
        this.tryProxyTask = null;
        this.sslHostAndPortTest = null;
        this.sslHostAndPortTestThread = null;
        this.sslHostAndPortTestResult = null;
        this.tryProxyButton.setDisable(false);
        this.proxyProgressBar.setProgress(1.0);
        this.proxyProgressBar.setVisible(false);
    }

    @Override
    public boolean check() {
        return true;
    }

    @Override
    public boolean save() {
        if (this.neverProxyForJFedRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, "NEVER");
        }
        if (this.autoProxyForJFedRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, "AUTO");
        }
        if (this.alwaysProxyForJFedRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_JFED, "ALWAYS");
        }
        if (this.neverProxyForSshRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, "NEVER");
        }
        if (this.autoProxyForSshRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, "AUTO");
        }
        if (this.alwaysProxyForSshRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, "ALWAYS");
        }
        if (this.askProxyOnConflictRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_DOUBLE_PROXY_SOLUTION, DoubleProxyHandling.ASK.getConfigValue());
        }
        if (this.testbedProxyOnConflictRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_DOUBLE_PROXY_SOLUTION, DoubleProxyHandling.IGNORE_AND_USE_TESTBED_PROXY.getConfigValue());
        }
        if (this.jFedProxyOnConflictRadioButton.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_DOUBLE_PROXY_SOLUTION, DoubleProxyHandling.IGNORE_AND_USE_JFED_PROXY.getConfigValue());
        }
        this.convertPuttyKeysIfNeeded();
        this.proxyPreferencesManager.updateProxySettings();
        this.experimenterGUI.updateConnectivityStatusLabel();
        return true;
    }
}

