/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.LabelWithStatus;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.TextFieldWithStatus;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.PageantHelper;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.SshKeyInfoUnlocker;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.io.File;
import java.util.HashSet;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PuttyPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(PuttyPane.class);
    private static final FileChooser.ExtensionFilter PPK_FILE_EXTENSION = new FileChooser.ExtensionFilter("PuTTY Private Key (*.ppk)", new String[]{"*.ppk"});
    @FXML
    private TextFieldWithStatus puttyDirTextField;
    @FXML
    private Button puttyDirBrowseButton;
    @FXML
    protected HBox puttyDirScanResult;
    @FXML
    protected LabelWithStatus puttyDirScanPuttyLabel;
    @FXML
    protected LabelWithStatus puttyDirScanPageantLabel;
    @FXML
    protected LabelWithStatus puttyDirScanPlinkLabel;
    @FXML
    protected CheckBox pageantCheckBox;
    @FXML
    protected CheckBox x11ForwardCheckBox;
    @FXML
    protected CheckBox agentForwardCheckBox;
    @FXML
    private BorderPane root;
    private final GeniUserProvider geniUserProvider;
    private final JFedHLPreferences jFedPreferences;
    private final PageantHelper pageantHelper;
    private final SshKeyInfoUnlocker sshKeyInfoUnlocker;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    PuttyPane(GeniUserProvider geniUserProvider, JFedHLPreferences jFedPreferences, PageantHelper pageantHelper, SshKeyInfoUnlocker sshKeyInfoUnlocker) {
        super("PuTTY", false);
        this.geniUserProvider = geniUserProvider;
        this.jFedPreferences = jFedPreferences;
        this.pageantHelper = pageantHelper;
        this.sshKeyInfoUnlocker = sshKeyInfoUnlocker;
    }

    @FXML
    private void initialize() {
        this.puttyDirTextField.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.puttyDirTextField.setStatus(TextFieldWithStatus.Status.NONE);
            } else {
                this.testPuttyDir();
            }
        });
        if (this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_DIRECTORY) != null) {
            this.puttyDirTextField.setText(this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_DIRECTORY).getPath());
        } else {
            String puttyDir = JFedHLPreferences.findPuTTYDirectory();
            if (puttyDir != null) {
                this.puttyDirTextField.setText(puttyDir);
            }
        }
        this.pageantCheckBox.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE, true));
        this.x11ForwardCheckBox.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_X11_FORWARD, true));
        this.agentForwardCheckBox.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_AGENT_FORWARD, true));
        this.testPuttyDir();
        Platform.runLater(() -> {
            if (this.puttyDirTextField.getText().length() == 0) {
                this.puttyDirBrowseButton.requestFocus();
            } else {
                this.puttyDirBrowseButton.requestFocus();
            }
        });
    }

    private void testPuttyDir() {
        boolean plinkOk;
        boolean pageantOk;
        boolean puttyOk;
        if (this.puttyDirTextField.getText().length() == 0) {
            this.puttyDirTextField.setStatus(TextFieldWithStatus.Status.NONE);
            return;
        }
        this.puttyDirTextField.setStatus(this.validatePuTTYDirectory(this.puttyDirTextField.getText()) ? TextFieldWithStatus.Status.OK : TextFieldWithStatus.Status.ERROR);
        this.puttyDirScanResult.setVisible(true);
        this.puttyDirScanResult.setManaged(true);
        File puttyDir = new File(this.puttyDirTextField.getText());
        if (!puttyDir.exists() || !puttyDir.isDirectory()) {
            puttyOk = false;
            pageantOk = false;
            plinkOk = false;
        } else {
            puttyOk = new File(puttyDir, "putty.exe").exists();
            pageantOk = new File(puttyDir, "pageant.exe").exists();
            plinkOk = new File(puttyDir, "plink.exe").exists();
        }
        if (puttyOk) {
            this.puttyDirScanPuttyLabel.setText("putty.exe is present: can open SSH terminals");
            this.puttyDirScanPuttyLabel.setStatus(LabelWithStatus.Status.OK);
        } else {
            this.puttyDirScanPuttyLabel.setText("putty.exe is missing: cannot open SSH terminals");
            this.puttyDirScanPuttyLabel.setStatus(LabelWithStatus.Status.ERROR);
        }
        if (pageantOk) {
            this.puttyDirScanPageantLabel.setText("pageant.exe is present");
            this.puttyDirScanPageantLabel.setStatus(LabelWithStatus.Status.OK);
        } else {
            this.puttyDirScanPageantLabel.setText("pageant.exe is missing");
            this.puttyDirScanPageantLabel.setStatus(LabelWithStatus.Status.ERROR);
        }
        if (plinkOk) {
            this.puttyDirScanPlinkLabel.setText("plink.exe is present: can use SSH proxy");
            this.puttyDirScanPlinkLabel.setStatus(LabelWithStatus.Status.OK);
        } else {
            this.puttyDirScanPlinkLabel.setText("plink.exe is missing: cannot use SSH proxy");
            this.puttyDirScanPlinkLabel.setStatus(LabelWithStatus.Status.ERROR);
        }
        this.pageantCheckBox.setDisable(!pageantOk);
        if (!pageantOk) {
            this.pageantCheckBox.setSelected(false);
        }
    }

    private boolean validatePuTTYDirectory(String dir) {
        return JFedHLPreferences.isValidPuttyDir((File)new File(dir));
    }

    @FXML
    private void onPuttyDirBrowseButtonAction(ActionEvent actionEvent) {
        DirectoryChooser dc = new DirectoryChooser();
        dc.setTitle("Select the PuTTY Installation Directory");
        File selectedDir = dc.showDialog(this.puttyDirTextField.getScene().getWindow());
        if (selectedDir != null) {
            this.puttyDirTextField.setText(selectedDir.getAbsolutePath());
            this.testPuttyDir();
        }
    }

    @Override
    public boolean check() {
        if (this.puttyDirTextField.getStatus() != TextFieldWithStatus.Status.OK) {
            JFDialogs.create().owner((Node)this.root).message("Please provide a valid PuTTY installation directory before saving. This directory needs to contain: putty.exe puttygen.exe and plink.exe").showError();
            return false;
        }
        return true;
    }

    @Override
    public boolean save() {
        if (this.puttyDirTextField.getStatus() != TextFieldWithStatus.Status.OK) {
            JFDialogs.create().owner((Node)this.root).message("Please provide a valid PuTTY installation directory before saving. This directory needs to contain: putty.exe puttygen.exe and plink.exe").showError();
            return false;
        }
        this.jFedPreferences.setFile((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_DIRECTORY, new File(this.puttyDirTextField.getText()));
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE, this.pageantCheckBox.isSelected());
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_X11_FORWARD, this.x11ForwardCheckBox.isSelected());
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_AGENT_FORWARD, this.agentForwardCheckBox.isSelected());
        if (this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE).booleanValue()) {
            GeniUser geniUser;
            HashSet<Object> keys = new HashSet<Object>();
            assert (this.geniUserProvider.isUserLoggedIn());
            PuTTYFilesKeyInfo sshKeyInfo = this.jFedPreferences.getCustomSshKeyInfo();
            if (sshKeyInfo == null) {
                geniUser = this.geniUserProvider.getLoggedInGeniUser();
                sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser);
            }
            keys.add(sshKeyInfo);
            if (!this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH).equalsIgnoreCase("NEVER")) {
                geniUser = this.geniUserProvider.getLoggedInGeniUser();
                keys.add(SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser));
            }
            this.pageantHelper.registerKeys(keys, this.sshKeyInfoUnlocker);
        }
        return true;
    }
}

