/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Service;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ui.javafx.choosers.ServerChooser;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;

public class ScsPane
extends AbstractPreferencesSubPane {
    private final GeniUserProvider geniUserProvider;
    private final TestbedInfoSource testbedInfoSource;
    private final JFedHLPreferences jFedPreferences;
    @FXML
    protected Label prefSCSLabel;
    @FXML
    protected RadioButton autoScsRadioButton;
    @FXML
    protected RadioButton authScsRadioButton;
    @FXML
    protected RadioButton urlScsRadioButton;
    @FXML
    protected ServerChooser scsAuthChooserController;
    @FXML
    protected Label scsUrlLabel;
    @FXML
    protected Label scsUrlChooseLabel;
    @FXML
    protected TextField scsUrlField;
    @FXML
    private BorderPane root;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    ScsPane(GeniUserProvider geniUserProvider, TestbedInfoSource testbedInfoSource, JFedHLPreferences jFedPreferences) {
        super("SCS", true);
        this.geniUserProvider = geniUserProvider;
        this.testbedInfoSource = testbedInfoSource;
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    private void initialize() {
        this.scsAuthChooserController.showEditListButtonProperty().setValue(Boolean.valueOf(false));
        this.scsAuthChooserController.getRoot().managedProperty().bind((ObservableValue)this.scsAuthChooserController.getRoot().visibleProperty());
        this.scsUrlLabel.managedProperty().bind((ObservableValue)this.scsUrlLabel.visibleProperty());
        this.scsUrlChooseLabel.managedProperty().bind((ObservableValue)this.scsUrlChooseLabel.visibleProperty());
        this.scsUrlField.managedProperty().bind((ObservableValue)this.scsUrlField.visibleProperty());
        this.scsUrlChooseLabel.visibleProperty().bind((ObservableValue)this.scsUrlField.visibleProperty());
        this.scsAuthChooserController.getRoot().visibleProperty().bind((ObservableValue)this.authScsRadioButton.selectedProperty());
        this.scsUrlField.visibleProperty().bind((ObservableValue)this.urlScsRadioButton.selectedProperty());
        this.scsUrlLabel.visibleProperty().bind((ObservableValue)this.autoScsRadioButton.selectedProperty().or((ObservableBooleanValue)this.authScsRadioButton.selectedProperty()));
        this.scsAuthChooserController.setServerFilter(server -> ApiInfo.hasService((Server)server, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_SCS, (int)1));
        InvalidationListener updateUrl = observable -> {
            if (this.authScsRadioButton.isSelected()) {
                Server newSelectedServer = this.scsAuthChooserController.getSelectedServer();
                if (newSelectedServer == null) {
                    this.scsUrlLabel.setText("Error: no SCS selected.");
                    return;
                }
                URL scsUrl = ApiInfo.findUrl((Server)newSelectedServer, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_SCS, (int)1);
                if (scsUrl == null) {
                    this.scsUrlLabel.setText("Error: selected authority has no SCS URL");
                    return;
                }
                this.scsUrlLabel.setText("URL: " + String.valueOf(scsUrl));
                if (this.scsUrlField.getText().trim().isEmpty()) {
                    this.scsUrlField.setText(String.valueOf(scsUrl));
                }
            }
        };
        this.scsAuthChooserController.selectedAuthorityProperty().addListener(updateUrl);
        this.authScsRadioButton.selectedProperty().addListener(updateUrl);
        this.autoScsRadioButton.selectedProperty().addListener((observableValue, aBoolean, newIsSelected) -> {
            if (newIsSelected.booleanValue()) {
                GeniUrn scsUrn;
                Server userAuthServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
                Integer scsId = userAuthServer.getDefaultScsId();
                Service scsService = scsId == null ? null : this.testbedInfoSource.getServiceById(scsId);
                GeniUrn geniUrn = scsUrn = scsService == null ? null : scsService.getUrnAsGeniUrn();
                if (scsService == null) {
                    this.scsUrlLabel.setText("Error: user authority has an invalid SCS: id=" + scsId);
                } else {
                    URL scsUrl = null;
                    try {
                        scsUrl = new URL(scsService.getUrl());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("Should never get this error here: TestbedInfoSource should prevent this on init.", e);
                    }
                    if (scsUrl == null) {
                        this.scsUrlLabel.setText("Error: user authority has no SCS URL");
                    } else {
                        this.scsUrlLabel.setText("URL: " + String.valueOf(scsUrl));
                        if (this.scsUrlField.getText().trim().isEmpty()) {
                            this.scsUrlField.setText(String.valueOf(scsUrl));
                        }
                    }
                }
            }
        });
        this.urlScsRadioButton.selectedProperty().addListener((observableValue, aBoolean, newIsSelected) -> {
            if (newIsSelected.booleanValue() && this.scsUrlField.getText().trim().isEmpty()) {
                this.scsUrlField.setText("http://MYSCS:8081/geni/xmlrpc");
            }
        });
        this.autoScsRadioButton.setSelected(true);
        URL scsUrl = this.jFedPreferences.getScsUrl();
        GeniUrn scsUrn = this.jFedPreferences.getScsUrn();
        if (scsUrn != null) {
            this.authScsRadioButton.setSelected(true);
            Server selectedAuth = this.jFedPreferences.getScsAuthority(this.testbedInfoSource);
            if (selectedAuth != null) {
                this.scsAuthChooserController.select(selectedAuth);
            }
        } else if (scsUrl != null) {
            this.scsUrlField.setText(String.valueOf(scsUrl));
            this.urlScsRadioButton.setSelected(true);
        } else {
            this.autoScsRadioButton.setSelected(false);
            this.autoScsRadioButton.setSelected(true);
        }
    }

    @Override
    public boolean check() {
        if (this.urlScsRadioButton.isSelected()) {
            String urlTxt = this.scsUrlField.getText().trim();
            try {
                new URL(urlTxt);
            }
            catch (MalformedURLException e) {
                JFDialogs.create().owner((Node)this.root).message("The provided SCS URL is not a valid URL").showError();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean save() {
        if (this.autoScsRadioButton.isSelected()) {
            this.jFedPreferences.setScs((URL)null);
        }
        if (this.authScsRadioButton.isSelected()) {
            Server auth = this.scsAuthChooserController.getSelectedServer();
            this.jFedPreferences.setScs(auth);
        }
        if (this.urlScsRadioButton.isSelected()) {
            String urlTxt = this.scsUrlField.getText().trim();
            try {
                URL u = new URL(urlTxt);
                this.jFedPreferences.setScs(u);
            }
            catch (MalformedURLException e) {
                JFDialogs.create().owner((Node)this.root).message("The provided SCS URL is not a valid URL").showError();
                return false;
            }
        }
        return true;
    }
}

