/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.TextFieldWithStatus;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PuTTYPrivateKeyFile;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.PageantHelper;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.SshKeyInfoUnlocker;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.util.InformationLabel;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import be.iminds.ilabt.jfed.util.library.PEMUtil;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.util.HashSet;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.stage.FileChooser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshAuthenticationPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(SshAuthenticationPane.class);
    private final OSDetector.OS os;
    private final SimpleObjectProperty<SshAuthState> state = new SimpleObjectProperty((Object)SshAuthState.PRIV_UNSPECIFIED);
    private final SimpleStringProperty privateKeyFilename = new SimpleStringProperty();
    private final SimpleStringProperty publicKeyFilename = new SimpleStringProperty();
    private final SimpleStringProperty privateKeyContent = new SimpleStringProperty();
    private final SimpleStringProperty publicKeyContent = new SimpleStringProperty();
    private final BooleanProperty badPrivateKey = new SimpleBooleanProperty(false);
    private final BooleanProperty badPublicKey = new SimpleBooleanProperty(false);
    private final BooleanProperty requirePublicKeyfile = new SimpleBooleanProperty(false);
    private final BooleanProperty useCustomKey = new SimpleBooleanProperty(false);
    private final BooleanProperty useCertKey = new SimpleBooleanProperty(false);
    @FXML
    protected Node root;
    @FXML
    protected CheckBox useCertificateCheckBox;
    @FXML
    protected CheckBox useCustomKeyPairCheckBox;
    @FXML
    protected TextFieldWithStatus privKeyFileTextField;
    @FXML
    protected Button privKeyBrowseButton;
    @FXML
    protected Label warnNoLoginKeyLabel;
    @FXML
    protected Label customKeyPairLabel;
    @FXML
    protected Label privKeyLabel;
    @FXML
    protected TextFieldWithStatus pubKeyFileTextField;
    @FXML
    protected Button pubKeyBrowseButton;
    @FXML
    protected Label pubKeyLabel;
    @FXML
    protected InformationLabel pubKeyInPrivKeyInfo;
    @FXML
    protected Label publicKeyContentLabel;
    @FXML
    protected TextArea pubKeyContentTextArea;
    protected final GeniUserProvider geniUserProvider;
    protected final JFedHLPreferences jFedPreferences;
    @FXML
    protected Label warnMultiKeyLabel;
    @FXML
    protected Label keyTypeInfoLabel;
    private final PageantHelper pageantHelper;
    private final SshKeyInfoUnlocker sshKeyInfoUnlocker;
    @FXML
    protected CheckBox useOpenSshRsaKey;
    @FXML
    protected CheckBox useOpenSshECDSAKey;
    @FXML
    protected CheckBox useOpenSshECDSASKKey;
    @FXML
    protected CheckBox useOpenSshEd25519Key;
    @FXML
    protected CheckBox useOpenSshEd25519SKKey;

    @Inject
    SshAuthenticationPane(GeniUserProvider geniUserProvider, JFedHLPreferences jFedPreferences, PageantHelper pageantHelper, SshKeyInfoUnlocker sshKeyInfoUnlocker) {
        super("SSH Keys", false);
        this.pageantHelper = pageantHelper;
        this.sshKeyInfoUnlocker = sshKeyInfoUnlocker;
        this.geniUserProvider = geniUserProvider;
        this.jFedPreferences = jFedPreferences;
        this.os = OSDetector.findOS();
        this.load();
    }

    private void load() {
        this.useCertKey.set(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_USE_LOGIN_KEY).booleanValue());
        this.useCustomKey.set(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_USE_CUSTOM_KEY).booleanValue());
        if (this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_USE_CUSTOM_KEY) == Boolean.TRUE) {
            File privPuttyKeyFile = this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PUTTY_KEY_FILE);
            File privOpenSshKeyFile = this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PRIVATE_KEY_FILE);
            if (privPuttyKeyFile != null) {
                this.loadPrivKey(privPuttyKeyFile);
            } else if (privOpenSshKeyFile != null) {
                this.loadPrivKey(privOpenSshKeyFile);
            } else {
                this.loadPrivKey(null);
            }
        } else {
            this.loadPrivKey(null);
        }
        File publicKeyManual = this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PUBLIC_KEY_FILE);
        this.loadPubKey(publicKeyManual);
    }

    private void loadPrivKey(@Nullable File newPrivateKeyFile) {
        boolean setBad;
        block7: {
            if (newPrivateKeyFile != null) {
                String content = IOUtils.fileToStringOrNull((File)newPrivateKeyFile);
                this.privateKeyFilename.set(newPrivateKeyFile.getPath());
                this.privateKeyContent.set(content);
                try {
                    if (content != null && this.isPuttyPrivateKeyFile(newPrivateKeyFile, content)) {
                        this.state.set((Object)SshAuthState.PRIV_PUTTY);
                        this.loadPubKey(null);
                        setBad = false;
                        break block7;
                    }
                    if (content != null && this.isPEMPrivateKeyFile(newPrivateKeyFile, content)) {
                        this.state.set((Object)SshAuthState.PRIV_OPENSSH_PUB_INPRIV);
                        this.loadPubKey(this.publicKeyFilename.get() == null ? null : new File(this.publicKeyFilename.get()));
                        setBad = false;
                        break block7;
                    }
                    this.state.set((Object)SshAuthState.PRIV_BAD);
                    setBad = true;
                }
                catch (IOException e) {
                    this.state.set((Object)SshAuthState.PRIV_BAD);
                    setBad = true;
                    this.privateKeyFilename.set(null);
                }
            } else {
                setBad = true;
                this.state.set((Object)SshAuthState.PRIV_UNSPECIFIED);
                this.privateKeyFilename.set(null);
            }
        }
        this.badPrivateKey.set(setBad);
        if (setBad) {
            this.privateKeyContent.set(null);
            this.publicKeyContent.set(null);
            this.publicKeyFilename.set(null);
        }
        LOG.debug("Private key loaded. state={} privateKeyFilename={} badPrivateKey={}", new Object[]{this.state.get(), this.privateKeyFilename.get(), this.badPrivateKey.get()});
    }

    private void loadPubKey(@Nullable File newPublicKeyFile) {
        PEMUtil.PEM pem;
        File privKey;
        File file = privKey = this.privateKeyFilename.get() == null ? null : new File(this.privateKeyFilename.get());
        if (privKey == null || this.privateKeyContent.get() == null) {
            this.publicKeyFilename.set(null);
            this.publicKeyContent.set(null);
            this.badPublicKey.set(true);
            return;
        }
        try {
            pem = PEMUtil.extractPEM((String)this.privateKeyContent.get());
        }
        catch (PEMUtil.PEMDecodingException e) {
            LOG.error("Unexpected PEM decoding exception while extracting public key from private key file", (Throwable)e);
            this.badPrivateKey.set(true);
            this.badPublicKey.set(true);
            this.requirePublicKeyfile.set(true);
            this.publicKeyContent.set("<bug extracting public key from private key>");
            return;
        }
        if (this.state.get() != SshAuthState.PRIV_PUTTY) {
            if (pem.includesPubKey()) {
                this.state.set((Object)SshAuthState.PRIV_OPENSSH_PUB_INPRIV);
                this.publicKeyContent.set(this.getPublicKeyFromPEMPrivKey(privKey, this.privateKeyContent.get()));
                this.badPublicKey.set(false);
            } else if (this.privateKeyFilename.get() != null) {
                File autoPubkeyFile = new File(this.privateKeyFilename.get() + ".pub");
                if (autoPubkeyFile.isFile() && autoPubkeyFile.exists()) {
                    this.publicKeyFilename.set(autoPubkeyFile.getPath());
                    try {
                        this.publicKeyContent.set(IOUtils.fileToString((File)autoPubkeyFile));
                        this.badPublicKey.set(false);
                        this.state.set((Object)SshAuthState.PRIV_OPENSSH_PUB_EXTERNAL_AUTO);
                        this.requirePublicKeyfile.set(false);
                    }
                    catch (IOException e) {
                        this.publicKeyContent.set(null);
                        this.badPublicKey.set(true);
                        this.state.set((Object)SshAuthState.PRIV_OPENSSH_PUB_EXTERNAL_MANUAL);
                        this.requirePublicKeyfile.set(true);
                    }
                } else {
                    this.state.set((Object)SshAuthState.PRIV_OPENSSH_PUB_EXTERNAL_MANUAL);
                    this.requirePublicKeyfile.set(true);
                }
            } else {
                this.state.set((Object)SshAuthState.PRIV_OPENSSH_PUB_EXTERNAL_MANUAL);
                this.requirePublicKeyfile.set(true);
            }
            if (this.requirePublicKeyfile.get()) {
                if (newPublicKeyFile != null) {
                    String publicKeyManualContent = IOUtils.fileToStringOrNull((File)newPublicKeyFile);
                    this.publicKeyFilename.set(newPublicKeyFile.getPath());
                    this.publicKeyContent.set(publicKeyManualContent);
                    this.badPublicKey.set(publicKeyManualContent == null);
                } else {
                    this.publicKeyFilename.set(null);
                    this.publicKeyContent.set(null);
                    this.badPublicKey.set(true);
                }
            }
        } else {
            this.requirePublicKeyfile.set(false);
            this.publicKeyFilename.set(null);
            this.publicKeyContent.set(this.getPublicKeyFromPuTTYFile(privKey, this.privateKeyContent.get()));
            this.badPublicKey.set(false);
        }
        LOG.debug("Public key loaded. requirePublicKeyfile={} publicKeyFilename={} badPublicKey={} publicKeyContent={}", new Object[]{this.requirePublicKeyfile.get(), this.publicKeyFilename.get(), this.badPublicKey.get(), this.publicKeyContent.get()});
    }

    private void updateStatus() {
        if (this.badPrivateKey.get()) {
            this.privKeyFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
        } else {
            this.privKeyFileTextField.setStatus(TextFieldWithStatus.Status.OK);
        }
        if (this.badPublicKey.get()) {
            this.pubKeyFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
        } else {
            this.pubKeyFileTextField.setStatus(TextFieldWithStatus.Status.OK);
        }
    }

    private void bindManagedToVisible(Node n) {
        n.managedProperty().bind((ObservableValue)n.visibleProperty());
    }

    @FXML
    protected void initialize() {
        this.useCustomKeyPairCheckBox.selectedProperty().bindBidirectional((Property)this.useCustomKey);
        this.useCertificateCheckBox.selectedProperty().bindBidirectional((Property)this.useCertKey);
        this.privKeyFileTextField.disableProperty().bind((ObservableValue)this.useCustomKey.not());
        this.privKeyBrowseButton.disableProperty().bind((ObservableValue)this.useCustomKey.not());
        this.privKeyFileTextField.textProperty().bind((ObservableValue)this.privateKeyFilename);
        this.pubKeyFileTextField.textProperty().bind((ObservableValue)this.publicKeyFilename);
        this.pubKeyContentTextArea.textProperty().bind((ObservableValue)this.publicKeyContent);
        this.badPrivateKey.addListener((observable, oldValue, newValue) -> this.updateStatus());
        this.badPublicKey.addListener((observable, oldValue, newValue) -> this.updateStatus());
        this.warnNoLoginKeyLabel.visibleProperty().bind((ObservableValue)this.useCertKey.not());
        if (this.os != null && this.os == OSDetector.OS.WIN) {
            this.warnMultiKeyLabel.visibleProperty().bind((ObservableValue)this.useCustomKey.and((ObservableBooleanValue)this.useCertKey));
            this.keyTypeInfoLabel.visibleProperty().bind((ObservableValue)this.useCustomKey);
        } else {
            this.warnMultiKeyLabel.setVisible(false);
            this.keyTypeInfoLabel.setVisible(false);
        }
        this.pubKeyInPrivKeyInfo.visibleProperty().bind((ObservableValue)this.state.isEqualTo((Object)SshAuthState.PRIV_OPENSSH_PUB_INPRIV).and((ObservableBooleanValue)this.useCustomKey));
        BooleanBinding requirePubKeyField = this.state.isEqualTo((Object)SshAuthState.PRIV_OPENSSH_PUB_EXTERNAL_AUTO).or((ObservableBooleanValue)this.state.isEqualTo((Object)SshAuthState.PRIV_OPENSSH_PUB_EXTERNAL_MANUAL)).and((ObservableBooleanValue)this.useCustomKey);
        this.pubKeyFileTextField.visibleProperty().bind((ObservableValue)requirePubKeyField);
        this.pubKeyBrowseButton.visibleProperty().bind((ObservableValue)requirePubKeyField);
        this.pubKeyLabel.visibleProperty().bind((ObservableValue)requirePubKeyField);
        BooleanBinding requireDisabledPubKeyField = this.state.isEqualTo((Object)SshAuthState.PRIV_OPENSSH_PUB_EXTERNAL_MANUAL).not();
        this.pubKeyFileTextField.disableProperty().bind((ObservableValue)requireDisabledPubKeyField);
        this.pubKeyBrowseButton.disableProperty().bind((ObservableValue)requireDisabledPubKeyField);
        this.pubKeyLabel.disableProperty().bind((ObservableValue)requireDisabledPubKeyField);
        this.bindManagedToVisible((Node)this.publicKeyContentLabel);
        this.bindManagedToVisible((Node)this.pubKeyContentTextArea);
        this.bindManagedToVisible((Node)this.privKeyFileTextField);
        this.bindManagedToVisible((Node)this.privKeyBrowseButton);
        this.bindManagedToVisible((Node)this.warnNoLoginKeyLabel);
        this.bindManagedToVisible((Node)this.warnMultiKeyLabel);
        this.bindManagedToVisible((Node)this.warnNoLoginKeyLabel);
        this.bindManagedToVisible((Node)this.pubKeyBrowseButton);
        this.bindManagedToVisible((Node)this.pubKeyLabel);
        this.bindManagedToVisible((Node)this.pubKeyFileTextField);
        this.bindManagedToVisible((Node)this.pubKeyInPrivKeyInfo);
        this.bindManagedToVisible((Node)this.customKeyPairLabel);
        this.bindManagedToVisible((Node)this.privKeyLabel);
        this.bindManagedToVisible((Node)this.keyTypeInfoLabel);
        this.privKeyFileTextField.visibleProperty().bind((ObservableValue)this.useCustomKey);
        this.privKeyBrowseButton.visibleProperty().bind((ObservableValue)this.useCustomKey);
        this.customKeyPairLabel.visibleProperty().bind((ObservableValue)this.useCustomKey);
        this.privKeyLabel.visibleProperty().bind((ObservableValue)this.useCustomKey);
        this.pubKeyContentTextArea.visibleProperty().bind((ObservableValue)this.useCustomKey);
        this.publicKeyContentLabel.visibleProperty().bind((ObservableValue)this.useCustomKey);
        this.useOpenSshRsaKey.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_RSA, false));
        this.useOpenSshECDSAKey.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519, false));
        this.useOpenSshECDSASKKey.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ECDSA_SK, false));
        this.useOpenSshEd25519Key.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519, false));
        this.useOpenSshEd25519SKKey.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519_SK, false));
        this.useCertificateCheckBox.selectedProperty().addListener(e -> {
            PublicKeyConvertor conv = PublicKeyConvertor.fromPublicKey((PublicKey)this.geniUserProvider.getLoggedInGeniUser().getPublicKey());
            String pk = conv.getOpensshFormString();
            LOG.info("The Login certificate public key in openssh format, is: ");
            LOG.info(pk);
        });
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    private void setFileChooserDir(@Nonnull FileChooser fc, File ... possibilitiesArr) {
        try {
            for (File file : possibilitiesArr) {
                if (file == null) continue;
                if (file.exists() && file.isDirectory()) {
                    fc.setInitialDirectory(file);
                    return;
                }
                File parent = file.getParentFile();
                if (!parent.exists() || !parent.isDirectory()) continue;
                fc.setInitialDirectory(parent);
                return;
            }
        }
        catch (Exception e) {
            LOG.error("Ignoring exception setting filechooser dir", (Throwable)e);
        }
    }

    @FXML
    protected void onBrowsePrivateKey() {
        FileChooser fc = new FileChooser();
        fc.setTitle("Select your Private Key");
        this.setFileChooserDir(fc, this.privateKeyFilename.get() == null ? null : new File(this.privateKeyFilename.get()), this.getLoggedInUserPrivateKeyFile(), new File(System.getProperty("user.home")));
        File selectedFile = fc.showOpenDialog(this.privKeyFileTextField.getScene().getWindow());
        if (selectedFile != null) {
            this.loadPrivKey(new File(selectedFile.getAbsolutePath()));
            this.updateStatus();
            if (this.badPrivateKey.get()) {
                JFDialogs.create().owner(this.root).message(" Please select a valid private key.").masthead("The provided private key is not valid.").title("Invalid private key file").showWarning();
            }
        }
    }

    @FXML
    protected void onBrowsePublicKey() {
        FileChooser fc = new FileChooser();
        fc.setTitle("Select your Public Key");
        this.setFileChooserDir(fc, this.publicKeyFilename.get() == null ? null : new File(this.publicKeyFilename.get()), this.privateKeyFilename.get() == null ? null : new File(this.privateKeyFilename.get()), this.getLoggedInUserPrivateKeyFile(), new File(System.getProperty("user.home")));
        File selectedFile = fc.showOpenDialog(this.pubKeyFileTextField.getScene().getWindow());
        if (selectedFile != null) {
            this.loadPubKey(new File(selectedFile.getAbsolutePath()));
            this.updateStatus();
            if (this.badPublicKey.get()) {
                JFDialogs.create().owner(this.root).message(" Please select a valid public key.").masthead("The provided public key is not valid.").title("Invalid public key file").showWarning();
            }
        }
    }

    protected File getLoggedInUserPrivateKeyFile() {
        return this.geniUserProvider.getLoggedInGeniUser().getPrivateKeyFile();
    }

    @Override
    public boolean check() {
        if (!this.useCustomKey.get() && !this.useCertKey.get()) {
            JFDialogs.create().owner(this.root).message("You need to provide at least one key").showError();
            return false;
        }
        if (this.useCustomKey.get()) {
            if (this.badPrivateKey.get()) {
                JFDialogs.create().owner(this.root).message("The provided private key file is not valid").showError();
                return false;
            }
            if (this.requirePublicKeyfile.get() && this.badPublicKey.get()) {
                JFDialogs.create().owner(this.root).message("The provided public key file is not valid").showError();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean save() {
        if (!this.check()) {
            return false;
        }
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_USE_LOGIN_KEY, this.useCertKey.get());
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_USE_CUSTOM_KEY, this.useCustomKey.get());
        if (this.useCustomKey.get()) {
            File privKeyFile = new File(this.privateKeyFilename.get());
            assert (privKeyFile.exists() && privKeyFile.isFile());
            if (this.state.get() == SshAuthState.PRIV_PUTTY) {
                this.jFedPreferences.clear((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PRIVATE_KEY_FILE);
                this.jFedPreferences.clear((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PUBLIC_KEY_FILE);
                this.jFedPreferences.setFile((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PUTTY_KEY_FILE, privKeyFile);
            } else {
                this.jFedPreferences.clear((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PUTTY_KEY_FILE);
                this.jFedPreferences.setFile((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PRIVATE_KEY_FILE, privKeyFile);
                if (this.requirePublicKeyfile.get()) {
                    this.jFedPreferences.setFile((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PUBLIC_KEY_FILE, new File(this.publicKeyFilename.get()));
                } else {
                    this.jFedPreferences.clear((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PUBLIC_KEY_FILE);
                }
            }
        } else {
            this.jFedPreferences.clear((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PUTTY_KEY_FILE);
            this.jFedPreferences.clear((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PUBLIC_KEY_FILE);
            this.jFedPreferences.clear((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_PRIVATE_KEY_FILE);
        }
        if (this.os != null && this.os == OSDetector.OS.WIN && this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE) == Boolean.TRUE) {
            GeniUser geniUser;
            HashSet<Object> keys = new HashSet<Object>();
            assert (this.geniUserProvider.isUserLoggedIn());
            PuTTYFilesKeyInfo sshKeyInfo = this.jFedPreferences.getCustomSshKeyInfo();
            if (sshKeyInfo == null) {
                geniUser = this.geniUserProvider.getLoggedInGeniUser();
                sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser);
            }
            keys.add(sshKeyInfo);
            if (!this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH, "UNKNOWN").equalsIgnoreCase("NEVER")) {
                geniUser = this.geniUserProvider.getLoggedInGeniUser();
                keys.add(SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser));
            }
            this.pageantHelper.registerKeys(keys, this.sshKeyInfoUnlocker);
        }
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_RSA, this.useOpenSshRsaKey.isSelected());
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519, this.useOpenSshECDSAKey.isSelected());
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ECDSA_SK, this.useOpenSshECDSASKKey.isSelected());
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519, this.useOpenSshEd25519Key.isSelected());
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSH_EXTRA_PUBLIC_KEY_OPENSSH_ED25519_SK, this.useOpenSshEd25519SKKey.isSelected());
        return true;
    }

    protected boolean isPEMPrivateKeyFile(@Nonnull File file, @Nonnull String content) throws IOException {
        try {
            return PEMUtil.extractPEM((String)content).toPrivateKey() != null;
        }
        catch (PEMUtil.PEMDecodingException e) {
            return false;
        }
    }

    protected boolean isPuttyPrivateKeyFile(@Nonnull File file, @Nonnull String content) throws IOException {
        return PuTTYPrivateKeyFile.isPuttyPrivateKey((String)content);
    }

    protected boolean isPrivateKeyFile(@Nonnull File file, @Nonnull String content) throws IOException {
        assert (file.exists() && file.isFile());
        assert (!content.trim().isEmpty());
        return this.isPuttyPrivateKeyFile(file, content) || this.isPEMPrivateKeyFile(file, content);
    }

    protected String getPublicKeyFromFile(@Nonnull File file, @Nonnull String content) throws IOException {
        if (this.isPuttyPrivateKeyFile(file, content)) {
            return this.getPublicKeyFromPuTTYFile(file, content);
        }
        if (this.isPEMPrivateKeyFile(file, content)) {
            return this.getPublicKeyFromPEMPrivKey(file, content);
        }
        return null;
    }

    protected String getPublicKeyFromPEMPrivKey(@Nonnull File file, @Nonnull String content) {
        try {
            PEMUtil.PEM pem = PEMUtil.extractPEM((String)content);
            PublicKeyConvertor p = pem.toPublicKeyConvertor();
            if (p == null) {
                throw new IllegalArgumentException("Unsupported key in PEM");
            }
            return p.getOpensshFormString();
        }
        catch (PEMUtil.PEMDecodingException e) {
            throw new IllegalArgumentException("Unsupported key in PEM");
        }
    }

    protected String getPublicKeyFromPuTTYFile(@Nonnull File file, @Nonnull String content) {
        try {
            if (PuTTYPrivateKeyFile.isPuttyPrivateKey((File)file)) {
                PuTTYPrivateKeyFile ppk = PuTTYPrivateKeyFile.read((File)file);
                return ppk.getPublicKeyOpenSshString();
            }
            try {
                PublicKeyConvertor pkc = PublicKeyConvertor.fromOpensshFormat((String)content);
                return pkc.getOpensshFormString();
            }
            catch (Exception pkc) {
                PublicKeyConvertor pkc2 = PEMUtil.extractPEM((String)content).toPublicKeyConvertor();
                if (pkc2 != null) {
                    return pkc2.getOpensshFormString();
                }
            }
        }
        catch (PEMUtil.PEMDecodingException | IOException ex) {
            JFDialogs.create().owner((Node)this.privKeyFileTextField).message("An error occured while processing the key file").masthead("Error").title("Error").showException(ex);
        }
        JFDialogs.create().owner((Node)this.privKeyFileTextField).message("No public key found in key file").masthead("Error").title("Error").showError();
        return null;
    }

    private static enum SshAuthState {
        PRIV_UNSPECIFIED,
        PRIV_BAD,
        PRIV_PUTTY,
        PRIV_OPENSSH_PUB_INPRIV,
        PRIV_OPENSSH_PUB_EXTERNAL_AUTO,
        PRIV_OPENSSH_PUB_EXTERNAL_MANUAL;

    }
}

