/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCommandPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(SshCommandPane.class);
    @FXML
    protected CheckBox autoCheckBox;
    @FXML
    private TextArea sshCommandTextArea;
    @FXML
    private TextArea sshProxyCommandTextArea;
    @FXML
    private CheckBox sshagentCheckBox;
    @FXML
    private BorderPane root;
    private final JFedHLPreferences jFedPreferences;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    SshCommandPane(JFedHLPreferences jFedPreferences) {
        super("SSH Commands", false);
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    private void initialize() {
        this.sshCommandTextArea.disableProperty().bind((ObservableValue)this.autoCheckBox.selectedProperty());
        this.sshProxyCommandTextArea.disableProperty().bind((ObservableValue)this.autoCheckBox.selectedProperty());
        this.setFromPreferences();
    }

    private void setFromPreferences() {
        this.sshagentCheckBox.setSelected(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE).booleanValue());
        this.setCommandsFromPreferences();
        boolean auto = this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_SSH_AUTO, true);
        this.autoCheckBox.setSelected(auto);
    }

    private void setCommandsFromPreferences() {
        this.sshCommandTextArea.setText(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_SSH));
        this.sshProxyCommandTextArea.setText(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_SSH_PROXY));
    }

    private static boolean containsAll(String t, String ... mustContain) {
        for (String c : mustContain) {
            if (t.contains(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean check() {
        if (this.autoCheckBox.isSelected()) {
            return true;
        }
        if (!SshCommandPane.containsAll(this.sshCommandTextArea.getText(), "$i", "$h", "$p", "$u")) {
            JFDialogs.create().owner((Node)this.root).message("Your SSH command must contain the placeholders: $i $u $h $p").showError();
            return false;
        }
        if (!SshCommandPane.containsAll(this.sshProxyCommandTextArea.getText(), "$i", "$h", "$p", "$u", "$I", "$H", "$P", "$U")) {
            JFDialogs.create().owner((Node)this.root).message("Your SSH command must contain the placeholders: $i $u $h $p $I $U $H $P").showError();
            return false;
        }
        return true;
    }

    @Override
    public boolean save() {
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_SSH_AUTO, this.autoCheckBox.isSelected());
        this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE, this.sshagentCheckBox.isSelected());
        if (!this.autoCheckBox.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_SSH, this.sshCommandTextArea.getText());
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_SSH_PROXY, this.sshProxyCommandTextArea.getText());
        } else {
            this.jFedPreferences.fillinBlanks();
        }
        return true;
    }
}

