/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ssh_terminal_tool.unix.TerminalFinder;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpContentFile;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalCommandPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalCommandPane.class);
    @FXML
    protected TextArea terminalCommandTextArea;
    @FXML
    private Label terminalCommandLabel;
    @FXML
    private BorderPane root;
    private final JFedHLPreferences jFedPreferences;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    TerminalCommandPane(JFedHLPreferences jFedPreferences) {
        super("External Terminal Command", false);
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    private void initialize() {
        if (OSDetector.findOS() == OSDetector.OS.MAC) {
            this.terminalCommandLabel.setText("AppleScript commands:");
        }
        if (this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL) != null) {
            this.terminalCommandTextArea.setText(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL));
        }
    }

    @FXML
    private void onAutoDetectTerminalButtonClick() {
        String command = TerminalFinder.findLinuxTerminalCommand();
        if (command != null) {
            if (!Objects.equals(command, this.terminalCommandTextArea.getText())) {
                this.terminalCommandTextArea.setText(command);
            } else {
                JFDialogs.create().owner(this.getRoot().getScene().getWindow()).message("Auto detected terminal command is the same as the shown command.").showInformation();
            }
        } else {
            JFDialogs.create().owner(this.getRoot().getScene().getWindow()).message("Could not auto detect the terminal command.").showError();
        }
    }

    @FXML
    private void onTestTerminalButtonClick() {
        String[] finalCommandSplit;
        String terminalCommand = this.terminalCommandTextArea.getText();
        if (!terminalCommand.contains("%")) {
            JFDialogs.create().owner(this.getRoot().getScene().getWindow()).message("Your terminal command must contain '%' at the location on which the SSH-command can be included").showError();
            return;
        }
        String testCommandForTerminal = "echo Testing if terminal command works correctly...\nsleep 2\necho If you see this and the terminal does not close 'automatically,' the terminal command works correctly.\n\necho You can close the terminal manually now.";
        TmpContentFile tmpCommandFile = new TmpContentFile("test-terminal", "sh", "#!/bin/bash \n\n" + testCommandForTerminal + "\n/bin/bash");
        String tmpCommandFilename = tmpCommandFile.getFilename();
        String callScriptCommand = "bash " + tmpCommandFilename;
        ArrayList<Object> commandList = new ArrayList<Object>();
        if (terminalCommand.contains("'%'") || terminalCommand.contains("\"%\"")) {
            terminalCommand = terminalCommand.replaceFirst(Pattern.quote("'%'"), "%").replaceFirst(Pattern.quote("\"%\""), "%");
            for (String aFinalCommandSplit : finalCommandSplit = terminalCommand.split(" ")) {
                if (Objects.equals(aFinalCommandSplit, "%")) {
                    commandList.add(callScriptCommand);
                    continue;
                }
                commandList.add(aFinalCommandSplit);
            }
        } else {
            terminalCommand = terminalCommand.replaceFirst(Pattern.quote("%"), callScriptCommand);
            finalCommandSplit = terminalCommand.split(" ");
            Collections.addAll(commandList, finalCommandSplit);
        }
        LOG.debug("Executing command to launch terminal: " + terminalCommand);
        LOG.debug("   testCommandForTerminal: " + testCommandForTerminal);
        LOG.info("launchLinuxTerminal: commandList=" + String.valueOf(commandList));
        Runnable processOutputMonitor = () -> {
            try {
                String line;
                LOG.debug("Starting terminal using command (list): " + String.valueOf(commandList));
                ProcessBuilder pb = new ProcessBuilder(commandList);
                pb = pb.redirectErrorStream(true);
                Process p = pb.start();
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = input.readLine()) != null) {
                    LOG.debug("External Terminal stdout+stderr: " + line);
                }
                input.close();
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.warn("processOutputMonitor thread interrupted while waiting for terminal to stop", (Throwable)e);
                }
                LOG.info("Terminal command exited with exit value: " + p.exitValue());
            }
            catch (AssertionError | Exception e) {
                LOG.error("Exception while trying to launch external terminal: " + ((Throwable)e).getMessage(), (Throwable)e);
            }
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            tmpCommandFile.delete();
        };
        try {
            tmpCommandFile.store();
            Thread t = new Thread(processOutputMonitor);
            t.setName("ExternalTerminal");
            t.setDaemon(true);
            t.start();
        }
        catch (AssertionError | Exception e) {
            LOG.error("Exception: " + ((Throwable)e).getMessage(), (Throwable)e);
            tmpCommandFile.delete();
        }
    }

    @Override
    public boolean check() {
        if (!this.terminalCommandTextArea.getText().contains("%")) {
            JFDialogs.create().owner((Node)this.root).message("Your terminal command must contain '%' at the location on which the SSH-command can be included").showError();
            return false;
        }
        return true;
    }

    @Override
    public boolean save() {
        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL, this.terminalCommandTextArea.getText());
        return true;
    }
}

