/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.preferences.subsections;

import be.iminds.ilabt.jfed.experimenter_gui.preferences.AbstractPreferencesSubPane;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.TextFieldWithStatus;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.authority.JFedTestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.authority.StoredTestbedInfo;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedsPane
extends AbstractPreferencesSubPane {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedsPane.class);
    @FXML
    private TextFieldWithStatus testbedsXmlUrlTextField;
    @FXML
    private HBox testbedsXmlUrlTextBox;
    @FXML
    private HBox testbedsXmlLocalFileBox;
    @FXML
    private TextFieldWithStatus testbedsXmlLocalFileTextField;
    @FXML
    private Button testbedsXmlLocalFileBrowseButton;
    @FXML
    private RadioButton defaultTestbedsXml;
    @FXML
    private RadioButton onlineTestbedXml;
    @FXML
    private RadioButton localTestbedXml;
    @FXML
    private RadioButton builtinTestbedXml;
    @FXML
    private RadioButton autoForceExoSM;
    @FXML
    private RadioButton yesForceExoSM;
    @FXML
    private RadioButton noForceExoSM;
    @FXML
    private RadioButton bothRecoverExoGeni;
    @FXML
    private RadioButton singleRecoverExoGeni;
    @FXML
    private BorderPane root;
    @FXML
    private Label extraTestbedsLabel;
    private final JFedHLPreferences jFedPreferences;

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Inject
    TestbedsPane(JFedHLPreferences jFedPreferences) {
        super("Testbed Catalog", true);
        this.jFedPreferences = jFedPreferences;
    }

    @FXML
    private void initialize() {
        this.testbedsXmlLocalFileBox.managedProperty().bind((ObservableValue)this.testbedsXmlLocalFileBox.visibleProperty());
        this.testbedsXmlLocalFileBox.visibleProperty().bind((ObservableValue)this.localTestbedXml.selectedProperty());
        this.testbedsXmlUrlTextBox.managedProperty().bind((ObservableValue)this.testbedsXmlUrlTextBox.visibleProperty());
        this.testbedsXmlUrlTextBox.visibleProperty().bind((ObservableValue)this.onlineTestbedXml.selectedProperty());
        this.testbedsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.ERROR);
        this.testbedsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
        this.testbedsXmlLocalFileTextField.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.testbedsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.NONE);
            } else {
                this.testTestbedsXmlLocalFile();
            }
        });
        this.testbedsXmlUrlTextField.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.testbedsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.NONE);
            } else {
                this.testTestbedsXmlUrl();
            }
        });
        String testbedsSourcePref = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDS_JSON_SOURCE);
        if (testbedsSourcePref.equalsIgnoreCase("AUTO") || testbedsSourcePref.equalsIgnoreCase("DEFAULT")) {
            this.defaultTestbedsXml.setSelected(true);
        } else if (testbedsSourcePref.equalsIgnoreCase("BUILTIN")) {
            this.builtinTestbedXml.setSelected(true);
        } else if (testbedsSourcePref.startsWith("file:")) {
            this.localTestbedXml.setSelected(true);
            this.testbedsXmlLocalFileTextField.setText(testbedsSourcePref.substring(5));
            this.testTestbedsXmlLocalFile();
        } else {
            this.onlineTestbedXml.setSelected(true);
            this.testbedsXmlUrlTextField.setText(testbedsSourcePref);
            this.testTestbedsXmlUrl();
        }
        String forceExoPref = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_FORCE_EXOSM);
        Boolean foreExoPrefBool = TextUtil.stringToBoolean((String)forceExoPref);
        if (forceExoPref.equalsIgnoreCase("AUTO")) {
            this.autoForceExoSM.setSelected(true);
        } else assert (foreExoPrefBool != null) : "Invalid value for PREF_TESTBEDSPECIFIC_EXOGENI_FORCE_EXOSM: \"" + forceExoPref + "\"";
        if (foreExoPrefBool != null && foreExoPrefBool.booleanValue()) {
            this.yesForceExoSM.setSelected(true);
        }
        if (foreExoPrefBool != null && !foreExoPrefBool.booleanValue()) {
            this.noForceExoSM.setSelected(true);
        }
        String recoverExoPref = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_RECOVER_METHOD);
        assert (recoverExoPref.equals("BOTH") || recoverExoPref.equals("SINGLE")) : "invalid preference value: \"" + recoverExoPref + "\"";
        if (Objects.equals(recoverExoPref, "BOTH")) {
            this.bothRecoverExoGeni.setSelected(true);
        } else {
            this.singleRecoverExoGeni.setSelected(true);
        }
        this.updateExtraTestbedsLabels();
    }

    private void updateExtraTestbedsLabels() {
        List extraFiles = JFedTestbedInfoSource.getExtraTestbedFiles();
        List overwriteFiles = JFedTestbedInfoSource.getOverwriteTestbedFiles();
        this.extraTestbedsLabel.setText("The files below will be scanned for additional testbed information:" + (extraFiles.isEmpty() ? "" : "\n  -  ") + extraFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining("\n   - ")) + (overwriteFiles.isEmpty() ? "" : "\n  - (*) ") + overwriteFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining("\n   - (*) ")) + (overwriteFiles.isEmpty() ? "" : "\n\nThe files marked with a (*) will overwrite information from other sources, the other files will never do this."));
        this.extraTestbedsLabel.setVisible(!extraFiles.isEmpty() || !overwriteFiles.isEmpty());
    }

    @FXML
    private void onTestbedsXmlLocalFileBrowseButtonAction(ActionEvent actionEvent) {
        FileChooser dc = new FileChooser();
        dc.setTitle("Select the local Testbed Information File");
        File selectedFile = dc.showOpenDialog(this.testbedsXmlLocalFileTextField.getScene().getWindow());
        if (selectedFile != null) {
            this.testbedsXmlLocalFileTextField.setText(selectedFile.getAbsolutePath());
            this.testTestbedsXmlLocalFile();
        }
    }

    private boolean testTestbedsXmlUrl() {
        URL url;
        try {
            url = new URL(this.testbedsXmlUrlTextField.getText());
        }
        catch (MalformedURLException e) {
            this.testbedsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            this.testbedsXmlUrlTextField.setStatusDetailString("Not a valid URL");
            return false;
        }
        try {
            List testbeds = StoredTestbedInfo.load((InputStream)url.openStream());
            if (testbeds != null && !testbeds.isEmpty()) {
                this.testbedsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.OK);
                this.testbedsXmlUrlTextField.setStatusDetailString("");
            } else {
                this.testbedsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.ERROR);
                this.testbedsXmlUrlTextField.setStatusDetailString("Content at URL is invalid");
                LOG.warn("Invalid content in remote testbeds.json \"" + String.valueOf(url) + "\"");
            }
            return true;
        }
        catch (IOException e) {
            this.testbedsXmlUrlTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            this.testbedsXmlUrlTextField.setStatusDetailString("IOException opening file: " + e.getMessage());
            LOG.warn("Failed to open user remote testbeds.json \"" + String.valueOf(url) + "\"", (Throwable)e);
            return false;
        }
    }

    private boolean testTestbedsXmlLocalFile() {
        File file = new File(this.testbedsXmlLocalFileTextField.getText());
        if (!file.exists()) {
            this.testbedsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            this.testbedsXmlLocalFileTextField.setStatusDetailString("File does not exist");
            LOG.warn("local testbeds.json \"" + file.getAbsolutePath() + "\" does not exist");
            return false;
        }
        try {
            List testbeds = StoredTestbedInfo.load((File)file);
            if (testbeds != null && !testbeds.isEmpty()) {
                this.testbedsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.OK);
                this.testbedsXmlLocalFileTextField.setStatusDetailString("");
            } else {
                this.testbedsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
                this.testbedsXmlLocalFileTextField.setStatusDetailString("Invalid content in file");
                LOG.warn("Invalid content in user local testbeds.json \"" + file.getAbsolutePath() + "\"");
            }
            return true;
        }
        catch (IOException e) {
            this.testbedsXmlLocalFileTextField.setStatus(TextFieldWithStatus.Status.ERROR);
            this.testbedsXmlLocalFileTextField.setStatusDetailString("IOException opening or reading file: " + e.getMessage());
            LOG.warn("Failed to open or read user local testbeds.json \"" + file.getAbsolutePath() + "\"", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean check() {
        if (this.localTestbedXml.isSelected() && this.testbedsXmlLocalFileTextField.getStatus() != TextFieldWithStatus.Status.OK) {
            JFDialogs.create().owner((Node)this.root).message("Please provide a valid Testbed Information File before saving.").showError();
            return false;
        }
        if (this.onlineTestbedXml.isSelected() && this.testbedsXmlUrlTextField.getStatus() != TextFieldWithStatus.Status.OK) {
            JFDialogs.create().owner((Node)this.root).message("Please provide a valid Testbed Information URL before saving.").showError();
            return false;
        }
        return true;
    }

    @Override
    public boolean save() {
        if (!this.check()) {
            return false;
        }
        if (this.defaultTestbedsXml.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDS_JSON_SOURCE, "AUTO");
        }
        if (this.builtinTestbedXml.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDS_JSON_SOURCE, "BUILTIN");
        }
        if (this.localTestbedXml.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDS_JSON_SOURCE, "file:" + this.testbedsXmlLocalFileTextField.getText());
        }
        if (this.onlineTestbedXml.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDS_JSON_SOURCE, this.testbedsXmlUrlTextField.getText());
        }
        if (this.autoForceExoSM.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_FORCE_EXOSM, "AUTO");
        }
        if (this.yesForceExoSM.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_FORCE_EXOSM, "YES");
        }
        if (this.noForceExoSM.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_FORCE_EXOSM, "NO");
        }
        if (this.bothRecoverExoGeni.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_RECOVER_METHOD, "BOTH");
        }
        if (this.singleRecoverExoGeni.isSelected()) {
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_TESTBEDSPECIFIC_EXOGENI_RECOVER_METHOD, "SINGLE");
        }
        return true;
    }
}

