/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.renew_report;

import be.iminds.ilabt.jfed.bugreport.model.BugReport;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportComposer;
import be.iminds.ilabt.jfed.experimenter_gui.bugreporting.BugReportToServerTask;
import be.iminds.ilabt.jfed.experimenter_gui.renew_report.RenewReportDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.ui.SceneAwareController;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.util.ExpirationChecker;
import be.iminds.ilabt.jfed.ui.javafx.util.TimeUtils;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TimeUtil;
import com.google.inject.name.Named;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewReportDialog
implements SceneAwareController,
Initializable {
    private static final Logger LOG = LoggerFactory.getLogger(RenewReportDialog.class);
    private Slice slice;
    private ExperimentTaskStatus jobSuccessExperimentTaskStatus;
    private ExperimentController experimentController;
    private SfaModel sfaModel;
    private Throwable jobFailureThrowable;
    @Nonnull
    private Instant requestedRenewInstant;
    @Nonnull
    private final RenewReportDialogFactory renewReportDialogFactory;
    @Nonnull
    private final Provider<BugReportComposer> bugReportComposerProvider;
    @Nonnull
    private final Provider<TaskService> taskServiceProvider;
    @Nonnull
    private final Provider<FedmonWebApiClientConfig> fedmonWebApiClientConfigProvider;
    @FXML
    private ProgressBar busyBar;
    @FXML
    private RowConstraints failInfoRow;
    @FXML
    private RowConstraints warningRow;
    @FXML
    private RowConstraints projectWarningRow;
    @FXML
    private Label helpLabel;
    @FXML
    private Label warningLabel;
    @FXML
    private Label projectWarningLabel;
    @FXML
    private Label summaryStatusLabel;
    @FXML
    private Label summaryTargetExpirationLabel;
    @FXML
    private Label summaryFirstExpirationLabel;
    @FXML
    private Label sliceExpirationLabel;
    @FXML
    private Label earliestSliverExpirationLabel;
    @FXML
    private TableColumn amColumn;
    @FXML
    private TableColumn sliverColumn;
    @FXML
    private TableColumn expirationColumn;
    @FXML
    private Button okButton;
    @FXML
    private Button bugreportButton;
    @FXML
    private Button retryButton;
    @FXML
    private Button refreshButton;
    @FXML
    private TableView<ExpirationDetail> expirationTable;
    private final ObservableList<ExpirationDetail> expirationDetails;
    private Scene scene;
    private Stage stage;
    private static final DateTimeFormatter dataTimeFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd  HH:mm:ss zzz").withZone(ZoneId.systemDefault());

    @Inject
    public RenewReportDialog(@Nonnull RenewReportDialogFactory renewReportDialogFactory, @Nonnull Provider<BugReportComposer> bugReportComposerProvider, @Nonnull Provider<TaskService> taskServiceProvider, @Nonnull @Named(value="clientAuthWebApiConfig") Provider<FedmonWebApiClientConfig> fedmonWebApiClientConfigProvider) {
        this.renewReportDialogFactory = renewReportDialogFactory;
        this.bugReportComposerProvider = bugReportComposerProvider;
        this.taskServiceProvider = taskServiceProvider;
        this.fedmonWebApiClientConfigProvider = fedmonWebApiClientConfigProvider;
        this.expirationDetails = FXCollections.observableArrayList();
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.expirationTable.setItems(this.expirationDetails);
        ReadOnlyDoubleProperty dividableWidth = this.expirationTable.widthProperty();
        this.amColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.25));
        this.sliverColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.375));
        this.expirationColumn.prefWidthProperty().bind((ObservableValue)dividableWidth.multiply(0.375));
    }

    @Override
    public void registerScene(Scene scene) {
        this.scene = scene;
        this.stage = (Stage)scene.getWindow();
        scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.F10, new KeyCombination.Modifier[0]), () -> this.simulateFailForDebug());
    }

    public void closeDialog() {
        if (this.stage != null) {
            this.stage.close();
        }
    }

    public void retryRenew() {
        this.experimentController.renew(this.requestedRenewInstant).whenCompleteAsync(new BiConsumer<ExperimentTaskStatus, Throwable>(){

            @Override
            public void accept(ExperimentTaskStatus experimentTaskStatus, Throwable throwable) {
                if (throwable != null) {
                    RenewReportDialog.this.renewReportDialogFactory.showDialog(RenewReportDialog.this.requestedRenewInstant, RenewReportDialog.this.experimentController, throwable, RenewReportDialog.this.sfaModel);
                } else {
                    RenewReportDialog.this.renewReportDialogFactory.showDialog(RenewReportDialog.this.requestedRenewInstant, RenewReportDialog.this.experimentController, experimentTaskStatus, RenewReportDialog.this.sfaModel);
                }
            }
        }, Platform::runLater);
        if (this.stage != null) {
            this.stage.close();
        }
    }

    public void sendBugreport() {
        Alert userInfoDialog = new Alert(Alert.AlertType.CONFIRMATION);
        if (this.stage != null) {
            userInfoDialog.initOwner((Window)this.stage);
        }
        userInfoDialog.setHeaderText("Extra Info");
        userInfoDialog.setResizable(true);
        VBox contentPane = new VBox(10.0);
        contentPane.setPrefWidth(600.0);
        Label headerLabel = new Label("How important/urgent is this Renew?");
        headerLabel.setFont(Font.font((String)Font.getDefault().getFamily(), (FontWeight)FontWeight.BOLD, (double)Font.getDefault().getSize()));
        Label infoLabel = new Label("Could you please provide info to help us set a priority for this bug report?");
        infoLabel.setWrapText(true);
        TextArea descriptionTextArea = new TextArea();
        descriptionTextArea.setPromptText("add extra info here");
        descriptionTextArea.setStyle("-fx-margin: 0 0 0 30px");
        descriptionTextArea.setPrefRowCount(3);
        contentPane.getChildren().addAll((Object[])new Node[]{headerLabel, infoLabel, descriptionTextArea});
        userInfoDialog.getDialogPane().setContent((Node)contentPane);
        Platform.runLater(() -> {
            if (userInfoDialog.showAndWait().isPresent()) {
                String userInfo = descriptionTextArea.getText();
                BugReportComposer bugReportComposer = (BugReportComposer)this.bugReportComposerProvider.get();
                bugReportComposer.setFirstRunConnectivityTests(false);
                String subject = "Renew Failed for " + this.slice.getUrn().getEncodedTopLevelAuthority_withoutSubAuth() + " slice \"" + this.slice.getUrn().getEncodedResourceName() + "\"";
                bugReportComposer.setPostOnPublicList(false);
                bugReportComposer.setReportType(BugReport.ReportType.BUG);
                bugReportComposer.setReportTarget(BugReport.ReportTarget.OTHER);
                bugReportComposer.setSubject(subject);
                Object description = "";
                description = (String)description + "Slice URN: " + this.slice.getUrnString() + "\n";
                description = (String)description + "Renew Summary: " + this.summaryStatusLabel.getText() + "\n";
                description = (String)description + "Requested expiration time: " + this.summaryTargetExpirationLabel.getText() + "\n";
                description = (String)description + "Actual expiration time: " + this.summaryFirstExpirationLabel.getText() + "\n";
                description = (String)description + "\n";
                description = (String)description + "Slice expiration time: " + this.sliceExpirationLabel.getText() + "\n";
                description = (String)description + "Earliest Sliver expiration time: " + this.earliestSliverExpirationLabel.getText() + "\n";
                description = (String)description + "\n";
                description = (String)description + "Sliver expiration overview:\n";
                for (ExpirationDetail expirationDetail : this.expirationDetails) {
                    description = (String)description + "   - " + expirationDetail.getSliver() + " expires at " + expirationDetail.getExpiration() + "\n";
                }
                if (userInfo != null && !userInfo.trim().isEmpty()) {
                    description = (String)description + "\n\nExtra info from user:\n" + userInfo + "\n";
                }
                bugReportComposer.setDescription(((String)description).toString());
                ((TaskService)this.taskServiceProvider.get()).submitTask(new BugReportToServerTask(bugReportComposer, (FedmonWebApiClientConfig)this.fedmonWebApiClientConfigProvider.get()));
            }
        });
        if (this.stage != null) {
            this.stage.close();
        }
    }

    public void refresh() {
        this.setBusy();
        CompletionStage future = this.experimentController.requestUpdate().whenCompleteAsync((aVoid, throwable) -> this.calculateStatus(), Platform::runLater);
    }

    public void setWarningLabel() {
        List refusedParts = this.experimentController.getExperiment().getPartsStream().filter(experimentPart -> experimentPart instanceof SfaExperimentPart).map(experimentPart -> (SfaExperimentPart)experimentPart).filter(sfaExperimentPart -> sfaExperimentPart.getRenewStatus() != null).filter(sfaExperimentPart -> sfaExperimentPart.getRenewStatus().isRefused()).collect(Collectors.toList());
        LOG.debug("setWarningLabel() part debug");
        for (ExperimentPart part : this.experimentController.getExperiment().getPartsListCopy()) {
            LOG.debug("   part name=" + part.getName() + " state=" + String.valueOf(part));
            if (!(part instanceof SfaExperimentPart)) continue;
            SfaExperimentPart sfaExperimentPart2 = (SfaExperimentPart)part;
            LOG.debug("   part renewStatus=" + String.valueOf(sfaExperimentPart2.getRenewStatus()));
        }
        if (!refusedParts.isEmpty()) {
            if (refusedParts.size() == 1) {
                this.warningLabel.setText("The AM has refused the Renew for " + ((SfaExperimentPart)refusedParts.get(0)).getComponentManagerSfaAuthority().getName() + ": \n" + ((SfaExperimentPart)refusedParts.get(0)).getRenewStatus().getMessage());
            } else {
                Object txt = "The AM has refused the Renew for: \n";
                for (SfaExperimentPart part : refusedParts) {
                    txt = (String)txt + "- " + part.getComponentManagerSfaAuthority().getName() + ": " + part.getRenewStatus().getMessage() + " \n";
                }
                this.warningLabel.setText((String)txt);
            }
            this.warningRow.setMinHeight(60.0);
            this.warningRow.setPrefHeight(100.0);
        } else {
            this.warningRow.setMinHeight(0.0);
            this.warningRow.setPrefHeight(0.0);
        }
        this.warningLabel.setVisible(!refusedParts.isEmpty());
    }

    public void setProjectWarningLabel() {
        boolean expireSoon;
        Instant projectExpiration;
        String projectName = this.experimentController.getExperiment().getSlice().getProjectName();
        GeniUrn projectUrn = this.experimentController.getExperiment().getSlice().getProjectUrn();
        Instant instant = projectExpiration = projectUrn == null ? null : this.sfaModel.getProjectExpiration(projectUrn);
        if (projectExpiration == null) {
            this.projectWarningRow.setMinHeight(0.0);
            this.projectWarningRow.setPrefHeight(0.0);
            this.projectWarningLabel.setVisible(false);
            return;
        }
        Duration duration = Duration.between(Instant.now(), projectExpiration);
        String humanExpire = TimeUtils.formatMillis((long)duration.toMillis(), (TimeUnit)TimeUnit.DAYS, (TimeUnit)TimeUnit.MINUTES, (int)2);
        boolean bl = expireSoon = duration.toMillis() < Duration.of(90L, ChronoUnit.DAYS).toMillis();
        if (expireSoon) {
            this.projectWarningLabel.setText("Your project \"" + projectName + "\" expires in " + humanExpire + ". You will not be able to renew the experiment past your project expiration date. You can ask for your project to be extended.");
            this.projectWarningRow.setMinHeight(60.0);
            this.projectWarningRow.setPrefHeight(100.0);
        } else {
            this.projectWarningRow.setMinHeight(0.0);
            this.projectWarningRow.setPrefHeight(0.0);
        }
        this.projectWarningLabel.setVisible(expireSoon);
    }

    public void setFailStatus(String text) {
        this.summaryStatusLabel.setText(text);
        this.setLabelStyle(this.summaryStatusLabel, false);
        this.bugreportButton.setVisible(true);
        this.retryButton.setVisible(true);
        this.okButton.setVisible(true);
        this.refreshButton.setVisible(true);
        this.helpLabel.setVisible(true);
        this.busyBar.setVisible(false);
        this.failInfoRow.setMinHeight(60.0);
        this.failInfoRow.setPrefHeight(100.0);
    }

    public void setSuccessStatus() {
        this.summaryStatusLabel.setText("Successfully Renewed Experiment");
        this.setLabelStyle(this.summaryStatusLabel, true);
        this.bugreportButton.setVisible(false);
        this.retryButton.setVisible(false);
        this.helpLabel.setVisible(false);
        this.okButton.setVisible(true);
        this.refreshButton.setVisible(true);
        this.busyBar.setVisible(false);
        this.failInfoRow.setMinHeight(0.0);
        this.failInfoRow.setPrefHeight(0.0);
    }

    public void setBusy() {
        this.summaryStatusLabel.setText("?");
        this.summaryTargetExpirationLabel.setText("?");
        this.summaryFirstExpirationLabel.setText("?");
        this.sliceExpirationLabel.setText("?");
        this.earliestSliverExpirationLabel.setText("?");
        this.setNoLabelStyle(this.summaryStatusLabel);
        this.setNoLabelStyle(this.summaryTargetExpirationLabel);
        this.setNoLabelStyle(this.summaryFirstExpirationLabel);
        this.setNoLabelStyle(this.sliceExpirationLabel);
        this.setNoLabelStyle(this.earliestSliverExpirationLabel);
        this.expirationDetails.clear();
        this.helpLabel.setVisible(false);
        this.bugreportButton.setVisible(false);
        this.retryButton.setVisible(false);
        this.okButton.setVisible(false);
        this.refreshButton.setVisible(false);
        this.busyBar.setVisible(true);
    }

    public void simulateFailForDebug() {
        this.calculateStatus();
    }

    private static String toHumanTime(@Nullable Instant instant) {
        if (instant == null) {
            return "unknown";
        }
        return dataTimeFormatter.format(instant) + "  (" + TimeUtil.calcIn((Instant)instant) + ")";
    }

    @Contract(value="null -> false")
    private boolean isExpireTimeOK(@Nullable Instant actualExpirationTime) {
        return !ExpirationChecker.isEarlyExpire((Instant)this.requestedRenewInstant, (Instant)actualExpirationTime);
    }

    private void setLabelStyle(@Nonnull Label target, boolean ok) {
        if (ok) {
            target.getStyleClass().removeAll((Object[])new String[]{"label-text-error", "label-error"});
            target.getStyleClass().addAll((Object[])new String[]{"label-ok", "label-text-ok"});
        } else {
            target.getStyleClass().removeAll((Object[])new String[]{"label-ok", "label-text-ok"});
            target.getStyleClass().addAll((Object[])new String[]{"label-text-error", "label-error"});
        }
    }

    private void setNoLabelStyle(@Nonnull Label target) {
        target.getStyleClass().removeAll((Object[])new String[]{"label-text-error", "label-error", "label-ok", "label-text-ok"});
    }

    private void setExpirationLabel(@Nonnull Label target, @Nullable Instant expireTime) {
        target.setText(RenewReportDialog.toHumanTime(expireTime));
        this.setLabelStyle(target, this.isExpireTimeOK(expireTime));
    }

    public void calculateStatus() {
        this.setBusy();
        if (this.experimentController == null) {
            throw new IllegalStateException("experimentController was not set");
        }
        if (this.sfaModel == null) {
            throw new IllegalStateException("sfaModel was not set");
        }
        if (this.requestedRenewInstant == null) {
            throw new IllegalStateException("requestedRenewInstant was not set");
        }
        if (this.slice == null) {
            throw new IllegalStateException("slice was not set");
        }
        this.summaryTargetExpirationLabel.setText(RenewReportDialog.toHumanTime(this.requestedRenewInstant));
        this.setExpirationLabel(this.sliceExpirationLabel, this.slice.getExpirationDate());
        boolean allOk = this.isExpireTimeOK(this.slice.getExpirationDate());
        Instant earliestSliverExpiration = ExpirationChecker.getEarliestSliverExpiration((Slice)this.slice);
        ArrayList<ExpirationDetail> newExpirationDetails = new ArrayList<ExpirationDetail>();
        for (Sliver sliver : this.slice.getSliversCopy()) {
            if (sliver.isFake()) continue;
            newExpirationDetails.add(new ExpirationDetail(sliver.getServer().getName(), sliver.getUrnString(), sliver.getExpirationDate(), this.isExpireTimeOK(sliver.getExpirationDate())));
            if (sliver.getExpirationDate() != null) {
                allOk = allOk && this.isExpireTimeOK(sliver.getExpirationDate());
                continue;
            }
            allOk = false;
        }
        this.setExpirationLabel(this.earliestSliverExpirationLabel, earliestSliverExpiration);
        Instant earliestSliverOrSliceExpiration = ExpirationChecker.getEarliestExpiration((Slice)this.slice);
        assert (Objects.equals(ExpirationChecker.getEarliestOrNull((Instant)this.slice.getExpirationDate(), (Instant)earliestSliverExpiration), earliestSliverOrSliceExpiration));
        this.setExpirationLabel(this.summaryFirstExpirationLabel, earliestSliverOrSliceExpiration);
        allOk = allOk && this.isExpireTimeOK(earliestSliverExpiration);
        this.expirationDetails.setAll(newExpirationDetails);
        this.setWarningLabel();
        this.setProjectWarningLabel();
        if (this.jobFailureThrowable != null) {
            allOk = false;
            this.setFailStatus("Job Failed - Status Unknown");
            return;
        }
        if (this.jobSuccessExperimentTaskStatus == null) {
            allOk = false;
            this.setFailStatus("Job Status Unknown");
            return;
        }
        if (this.jobSuccessExperimentTaskStatus != ExperimentTaskStatus.SUCCESS) {
            allOk = false;
            this.setFailStatus("Job was not successfull: " + String.valueOf(this.jobSuccessExperimentTaskStatus));
            return;
        }
        if (allOk) {
            this.setSuccessStatus();
        } else {
            this.setFailStatus("Renew failed.");
        }
    }

    public void setJobSuccessExperimentTaskStatus(@Nullable ExperimentTaskStatus jobSuccessExperimentTaskStatus) {
        this.jobSuccessExperimentTaskStatus = jobSuccessExperimentTaskStatus;
    }

    public void setExperimentController(@Nonnull ExperimentController experimentController) {
        this.experimentController = experimentController;
        this.slice = experimentController.getExperiment().getSlice();
    }

    public void setSfaModel(@Nonnull SfaModel sfaModel) {
        this.sfaModel = sfaModel;
    }

    public void setJobFailureThrowable(@Nonnull Throwable jobFailureThrowable) {
        this.jobFailureThrowable = jobFailureThrowable;
    }

    public void setRequestedRenewInstant(@Nonnull Instant requestedRenewInstant) {
        this.requestedRenewInstant = requestedRenewInstant;
    }

    public class ExpirationDetail {
        private final String am;
        private final String sliver;
        private final String expiration;
        private final boolean ok;

        public ExpirationDetail(String am, String sliver, Instant expiration, boolean ok) {
            this(am, sliver, RenewReportDialog.toHumanTime(expiration), ok);
        }

        public ExpirationDetail(String am, String sliver, String expiration, boolean ok) {
            this.am = am;
            this.sliver = sliver;
            this.expiration = expiration;
            this.ok = ok;
        }

        public String getAm() {
            return this.am;
        }

        public String getSliver() {
            return this.sliver;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public boolean isOk() {
            return this.ok;
        }
    }
}

