/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.renew_report;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.experimenter_gui.renew_report.RenewReportDialog;
import be.iminds.ilabt.jfed.experimenter_gui.ui.AbstractDialogFactory;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import java.time.Instant;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RenewReportDialogFactory
extends AbstractDialogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RenewReportDialogFactory.class);

    @Inject
    public RenewReportDialogFactory(Provider<FXMLLoader> loaderProvider, @Named(value="parentStage") Provider<Stage> parentStageProvider) {
        super(loaderProvider, parentStageProvider);
    }

    @Override
    protected String getTitle() {
        return "Renew Report";
    }

    public void showDialog(@Nonnull Instant requestedRenewInstant, @Nonnull ExperimentController experimentController, @Nullable ExperimentTaskStatus experimentTaskStatus, @Nonnull SfaModel sfaModel) {
        try {
            assert (Platform.isFxApplicationThread());
            AbstractDialogFactory.StageAndController stageAndController = this.createStage();
            RenewReportDialog controller = (RenewReportDialog)stageAndController.getController();
            controller.setRequestedRenewInstant(requestedRenewInstant);
            controller.setExperimentController(experimentController);
            controller.setSfaModel(sfaModel);
            controller.setJobSuccessExperimentTaskStatus(experimentTaskStatus);
            controller.calculateStatus();
            stageAndController.getStage().showAndWait();
        }
        catch (Throwable t) {
            LOG.error("Failed to show Renew Report", t);
            throw t;
        }
    }

    public void showDialog(@Nonnull Instant requestedRenewInstant, @Nonnull ExperimentController experimentController, @Nonnull Throwable t, @Nonnull SfaModel sfaModel) {
        AbstractDialogFactory.StageAndController stageAndController = this.createStage();
        RenewReportDialog controller = (RenewReportDialog)stageAndController.getController();
        controller.setRequestedRenewInstant(requestedRenewInstant);
        controller.setExperimentController(experimentController);
        controller.setSfaModel(sfaModel);
        controller.setJobFailureThrowable(t);
        controller.calculateStatus();
        stageAndController.getStage().showAndWait();
    }
}

