/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.reservations;

import be.iminds.ilabt.jfed.experimenter_gui.ui.LocalTimeTextField;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.Temporal;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartEndDurationPane
extends GridPane {
    private static final Logger LOG = LoggerFactory.getLogger(StartEndDurationPane.class);
    private static final Duration DEFAULT_DURATION = Duration.ofHours(2L);
    private static final int MAX_DAYS = 365;
    @FXML
    private ComboBox<Integer> daysComboBox;
    @FXML
    private ComboBox<Integer> hoursComboBox;
    @FXML
    private ComboBox<Integer> minutesComboBox;
    @FXML
    private DatePicker startDatePicker;
    @FXML
    private DatePicker endDatePicker;
    @FXML
    private LocalTimeTextField startTimeTextField;
    @FXML
    private LocalTimeTextField endTimeTextField;
    private final ObjectProperty<LocalDateTime> startDateTime = new SimpleObjectProperty((Object)LocalDateTime.now());
    private final ObjectProperty<LocalDateTime> endDateTime = new SimpleObjectProperty((Object)((LocalDateTime)this.startDateTime.get()).plus(DEFAULT_DURATION));
    private boolean updatingEndTime = false;
    private boolean updatingDuration = false;

    public StartEndDurationPane() {
        FXMLUtil.injectFXML((Object)((Object)this));
    }

    @FXML
    private void initialize() {
        this.daysComboBox.setItems(FXCollections.observableList(IntStream.range(0, 366).boxed().collect(Collectors.toList())));
        this.hoursComboBox.setItems(FXCollections.observableList(IntStream.range(0, 24).boxed().collect(Collectors.toList())));
        this.minutesComboBox.setItems(FXCollections.observableList(IntStream.range(0, 60).boxed().collect(Collectors.toList())));
        this.startTimeTextField.setShowSeconds(false);
        this.endTimeTextField.setShowSeconds(false);
        this.startDateTimeModelToView();
        this.endDateTimeModelToView();
        this.durationModelToView();
        Duration duration = this.getDuration();
        long durationTime = duration.toMinutes();
        this.minutesComboBox.setValue((Object)((int)(durationTime % 60L)));
        this.hoursComboBox.setValue((Object)((int)((durationTime /= 60L) % 24L)));
        this.daysComboBox.setValue((Object)((int)(durationTime /= 24L)));
        this.daysComboBox.valueProperty().addListener(event -> this.durationViewToModel());
        this.hoursComboBox.valueProperty().addListener(event -> this.durationViewToModel());
        this.minutesComboBox.valueProperty().addListener(event -> this.durationViewToModel());
        this.startDatePicker.setOnAction(event -> this.startDateTimeViewToModel());
        this.startTimeTextField.timeProperty().addListener(event -> this.startDateTimeViewToModel());
        this.endDatePicker.setOnAction(event -> this.endDateTimeViewToModel());
        this.endTimeTextField.timeProperty().addListener(event -> this.endDateTimeViewToModel());
    }

    private void startDateTimeViewToModel() {
        Duration oldDuration = this.getDuration();
        LocalDateTime newStartTime = LocalDateTime.of((LocalDate)this.startDatePicker.getValue(), this.startTimeTextField.getTime());
        this.startDateTime.set((Object)newStartTime);
        LocalDateTime newEndTime = newStartTime.plus(oldDuration);
        this.endDateTime.set((Object)newEndTime);
        this.endDateTimeModelToView();
    }

    private void startDateTimeModelToView() {
        this.startDatePicker.setValue((Object)((LocalDateTime)this.startDateTime.get()).toLocalDate());
        this.startTimeTextField.setTime(((LocalDateTime)this.startDateTime.get()).toLocalTime());
    }

    private void endDateTimeModelToView() {
        this.endDatePicker.setValue((Object)((LocalDateTime)this.endDateTime.get()).toLocalDate());
        this.endTimeTextField.setTime(((LocalDateTime)this.endDateTime.get()).toLocalTime());
    }

    private void endDateTimeViewToModel() {
        if (this.updatingDuration) {
            return;
        }
        this.updatingEndTime = true;
        boolean changed = false;
        if (Period.between((LocalDate)this.startDatePicker.getValue(), (LocalDate)this.endDatePicker.getValue()).getDays() > 365) {
            this.endDatePicker.setValue((Object)((LocalDate)this.startDatePicker.getValue()).plusDays(365L));
            changed = true;
        }
        LocalDateTime newEndTime = LocalDateTime.of((LocalDate)this.endDatePicker.getValue(), this.endTimeTextField.getTime());
        this.endDateTime.set((Object)newEndTime);
        this.durationModelToView();
        if (changed) {
            this.endDateTimeModelToView();
        }
        this.updatingEndTime = false;
    }

    private void durationModelToView() {
        Duration duration = this.getDuration();
        if (duration.isNegative()) {
            this.daysComboBox.getStyleClass().addAll((Object[])new String[]{"invalid-duration"});
            this.hoursComboBox.getStyleClass().addAll((Object[])new String[]{"invalid-duration"});
            this.minutesComboBox.getStyleClass().addAll((Object[])new String[]{"invalid-duration"});
        } else {
            this.daysComboBox.getStyleClass().addAll((Object[])new String[]{"valid-duration"});
            this.hoursComboBox.getStyleClass().addAll((Object[])new String[]{"valid-duration"});
            this.minutesComboBox.getStyleClass().addAll((Object[])new String[]{"valid-duration"});
        }
        long durationTime = duration.toMinutes();
        int minutes = (int)durationTime % 60;
        int hours = (int)(durationTime /= 60L) % 24;
        int days = (int)(durationTime /= 24L);
        if (minutes < 0) {
            --hours;
            minutes += 60;
        }
        while (hours < 0) {
            --days;
            hours += 24;
        }
        this.minutesComboBox.setValue((Object)minutes);
        this.hoursComboBox.setValue((Object)hours);
        this.daysComboBox.setValue((Object)days);
    }

    private void durationViewToModel() {
        if (this.updatingEndTime) {
            return;
        }
        this.updatingDuration = true;
        this.endDateTime.setValue((Object)((LocalDateTime)this.startDateTime.get()).plus(Duration.ofDays(((Integer)this.daysComboBox.getValue()).intValue()).plusHours(((Integer)this.hoursComboBox.getValue()).intValue()).plusMinutes(((Integer)this.minutesComboBox.getValue()).intValue())));
        this.endDateTimeModelToView();
        this.updatingDuration = false;
    }

    private Duration getDuration() {
        return Duration.between((Temporal)this.startDateTime.get(), (Temporal)this.endDateTime.get());
    }

    public LocalDateTime getEndDateTime() {
        return (LocalDateTime)this.endDateTime.get();
    }

    public LocalDateTime getStartDateTime() {
        return (LocalDateTime)this.startDateTime.get();
    }

    public DatePicker getEndDatePicker() {
        return this.endDatePicker;
    }

    public LocalTimeTextField getEndTimeTextField() {
        return this.endTimeTextField;
    }

    public DatePicker getStartDatePicker() {
        return this.startDatePicker;
    }

    public LocalTimeTextField getStartTimeTextField() {
        return this.startTimeTextField;
    }
}

